/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.lambda;

import java.util.List;
import org.robovm.compiler.plugin.lambda.SClass;

public class SMethodType {
    private final SClass<?> returnType;
    private final List<SClass<?>> parameters;

    public SMethodType(SClass<?> returnType, List<SClass<?>> parameters) {
        this.returnType = returnType;
        this.parameters = parameters;
    }

    public int parameterCount() {
        return this.parameters.size();
    }

    public SClass<?> parameterType(int i) {
        return this.parameters.get(i);
    }

    public SClass<?> returnType() {
        return this.returnType;
    }

    public String toMethodDescriptorString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (SClass<?> c : this.parameters) {
            sb.append(c.getDescriptor());
        }
        sb.append(")");
        sb.append(this.returnType.getDescriptor());
        return sb.toString();
    }

    public SMethodType changeReturnType(SClass<?> newReturnType) {
        return new SMethodType(newReturnType, this.parameters);
    }

    public List<SClass<?>> parameterList() {
        return this.parameters;
    }

    public String toString() {
        return this.toMethodDescriptorString();
    }
}

