/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.lambda;

import java.util.ArrayList;
import java.util.List;
import org.robovm.compiler.Types;
import org.robovm.compiler.plugin.lambda.SClass;
import soot.ArrayType;
import soot.PrimType;
import soot.RefType;
import soot.SootClass;
import soot.Type;

public class SootSClass
extends SClass {
    final Type type;

    public SootSClass(Type type) {
        this.type = type;
    }

    @Override
    public String getDescriptor() {
        return Types.getDescriptor(this.type);
    }

    @Override
    public boolean isPrimitive() {
        return this.type instanceof PrimType;
    }

    @Override
    public boolean isInterface() {
        if (this.type instanceof RefType) {
            return ((RefType)this.type).getSootClass().isInterface();
        }
        return false;
    }

    @Override
    public boolean isArray() {
        return this.type instanceof ArrayType;
    }

    public SClass getComponentType() {
        if (this.type instanceof ArrayType) {
            return SootSClass.forType(((ArrayType)this.type).getElementType());
        }
        return null;
    }

    public SClass getSuperclass() {
        if (this.isPrimitive() || this.isInterface()) {
            return null;
        }
        if (this.isArray()) {
            return SClass.ObjectClass;
        }
        RefType refType = (RefType)this.type;
        SootClass sc = refType.getSootClass();
        if (sc.hasSuperclass()) {
            return SootSClass.forType(sc.getSuperclass().getType());
        }
        return null;
    }

    public SClass[] getInterfaces() {
        if (this.isPrimitive()) {
            return null;
        }
        if (this.isArray()) {
            return new SClass[]{SClass.CloneableClass, SClass.SerializableClass};
        }
        RefType refType = (RefType)this.type;
        SootClass sc = refType.getSootClass();
        ArrayList result = new ArrayList();
        for (SootClass ifs : sc.getInterfaces()) {
            result.add(SootSClass.forType(ifs.getType()));
        }
        return result.toArray(new SClass[result.size()]);
    }

    public static SClass<?> forType(Type type) {
        String descriptor = Types.getDescriptor(type);
        return SClass.lookup(descriptor);
    }

    public static List<SClass<?>> forTypes(Type[] types) {
        ArrayList result = new ArrayList();
        for (Type type : types) {
            result.add(SootSClass.forType(type));
        }
        return result;
    }

    public static List<SClass<?>> forTypes(List<Type> types) {
        ArrayList result = new ArrayList();
        for (Type type : types) {
            result.add(SootSClass.forType(type));
        }
        return result;
    }
}

