/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.lambda;

import org.robovm.compiler.plugin.lambda.SClass;
import org.robovm.compiler.plugin.lambda.SClassLookup;
import org.robovm.compiler.plugin.lambda.SootSClass;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.ShortType;
import soot.SootResolver;
import soot.Type;
import soot.VoidType;

public class SootSClassLookup
implements SClassLookup {
    private Type resolve(String descriptor) {
        switch (descriptor.charAt(0)) {
            case 'Z': {
                return BooleanType.v();
            }
            case 'B': {
                return ByteType.v();
            }
            case 'S': {
                return ShortType.v();
            }
            case 'C': {
                return CharType.v();
            }
            case 'I': {
                return IntType.v();
            }
            case 'J': {
                return LongType.v();
            }
            case 'F': {
                return FloatType.v();
            }
            case 'D': {
                return DoubleType.v();
            }
            case 'V': {
                return VoidType.v();
            }
            case '[': {
                return this.resolve(descriptor.substring(1)).makeArrayType();
            }
        }
        String className = descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
        return SootResolver.v().makeClassRef(className).getType();
    }

    @Override
    public SClass lookup(String descriptor) {
        return new SootSClass(this.resolve(descriptor));
    }
}

