/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.lambda.java.lang.invoke;

import org.robovm.compiler.plugin.lambda.SCallSite;
import org.robovm.compiler.plugin.lambda.SClass;
import org.robovm.compiler.plugin.lambda.SMethodHandle;
import org.robovm.compiler.plugin.lambda.SMethodHandleInfo;
import org.robovm.compiler.plugin.lambda.SMethodHandles;
import org.robovm.compiler.plugin.lambda.SMethodType;
import org.robovm.compiler.plugin.lambda.java.lang.invoke.LambdaConversionException;
import org.robovm.compiler.plugin.lambda.sun.invoke.util.Wrapper;

abstract class AbstractValidatingLambdaMetafactory {
    final SClass<?> targetClass;
    final SMethodType invokedType;
    final SClass<?> samBase;
    final String samMethodName;
    final SMethodType samMethodType;
    final SMethodHandle implMethod;
    final SMethodHandleInfo implInfo;
    final int implKind;
    final boolean implIsInstanceMethod;
    final SClass<?> implDefiningClass;
    final SMethodType implMethodType;
    final SMethodType instantiatedMethodType;
    final boolean isSerializable;
    final SClass<?>[] markerInterfaces;
    final SMethodType[] additionalBridges;

    AbstractValidatingLambdaMetafactory(SMethodHandles.Lookup caller, SMethodType invokedType, String samMethodName, SMethodType samMethodType, SMethodHandle implMethod, SMethodType instantiatedMethodType, boolean isSerializable, SClass<?>[] markerInterfaces, SMethodType[] additionalBridges) throws LambdaConversionException {
        this.targetClass = caller.lookupClass();
        this.invokedType = invokedType;
        this.samBase = invokedType.returnType();
        this.samMethodName = samMethodName;
        this.samMethodType = samMethodType;
        this.implMethod = implMethod;
        this.implInfo = caller.revealDirect(implMethod);
        this.implKind = this.implInfo.getReferenceKind();
        this.implIsInstanceMethod = this.implKind == 5 || this.implKind == 7 || this.implKind == 9;
        this.implDefiningClass = this.implInfo.getDeclaringClass();
        this.implMethodType = this.implInfo.getMethodType();
        this.instantiatedMethodType = instantiatedMethodType;
        this.isSerializable = isSerializable;
        this.markerInterfaces = markerInterfaces;
        this.additionalBridges = additionalBridges;
        if (!this.samBase.isInterface()) {
            throw new LambdaConversionException(String.format("Functional interface %s is not an interface", this.samBase.getName()));
        }
        for (SClass<?> c : markerInterfaces) {
            if (c.isInterface()) continue;
            throw new LambdaConversionException(String.format("Marker interface %s is not an interface", c.getName()));
        }
    }

    abstract SCallSite buildCallSite() throws LambdaConversionException;

    void validateMetafactoryArgs() throws LambdaConversionException {
        int samStart;
        int capturedStart;
        switch (this.implKind) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new LambdaConversionException(String.format("Unsupported MethodHandle kind: %s", this.implInfo));
            }
        }
        int implArity = this.implMethodType.parameterCount();
        int receiverArity = this.implIsInstanceMethod ? 1 : 0;
        int capturedArity = this.invokedType.parameterCount();
        int samArity = this.samMethodType.parameterCount();
        int instantiatedArity = this.instantiatedMethodType.parameterCount();
        if (implArity + receiverArity != capturedArity + samArity) {
            throw new LambdaConversionException(String.format("Incorrect number of parameters for %s method %s; %d captured parameters, %d functional interface method parameters, %d implementation parameters", this.implIsInstanceMethod ? "instance" : "static", this.implInfo, capturedArity, samArity, implArity));
        }
        if (instantiatedArity != samArity) {
            throw new LambdaConversionException(String.format("Incorrect number of parameters for %s method %s; %d instantiated parameters, %d functional interface method parameters", this.implIsInstanceMethod ? "instance" : "static", this.implInfo, instantiatedArity, samArity));
        }
        for (SMethodType bridgeMT : this.additionalBridges) {
            if (bridgeMT.parameterCount() == samArity) continue;
            throw new LambdaConversionException(String.format("Incorrect number of parameters for bridge signature %s; incompatible with %s", bridgeMT, this.samMethodType));
        }
        if (this.implIsInstanceMethod) {
            SClass<?> receiverClass;
            if (capturedArity == 0) {
                capturedStart = 0;
                samStart = 1;
                receiverClass = this.instantiatedMethodType.parameterType(0);
            } else {
                capturedStart = 1;
                samStart = 0;
                receiverClass = this.invokedType.parameterType(0);
            }
            if (!this.implDefiningClass.isAssignableFrom(receiverClass)) {
                throw new LambdaConversionException(String.format("Invalid receiver type %s; not a subtype of implementation type %s", receiverClass, this.implDefiningClass));
            }
            SClass<?> implReceiverClass = this.implMethod.type().parameterType(0);
            if (implReceiverClass != this.implDefiningClass && !implReceiverClass.isAssignableFrom(receiverClass)) {
                throw new LambdaConversionException(String.format("Invalid receiver type %s; not a subtype of implementation receiver type %s", receiverClass, implReceiverClass));
            }
        } else {
            capturedStart = 0;
            samStart = 0;
        }
        int implFromCaptured = capturedArity - capturedStart;
        for (int i = 0; i < implFromCaptured; ++i) {
            SClass<?> implParamType = this.implMethodType.parameterType(i);
            SClass<?> capturedParamType = this.invokedType.parameterType(i + capturedStart);
            if (capturedParamType.equals(implParamType)) continue;
            throw new LambdaConversionException(String.format("Type mismatch in captured lambda parameter %d: expecting %s, found %s", i, capturedParamType, implParamType));
        }
        int samOffset = samStart - implFromCaptured;
        for (int i = implFromCaptured; i < implArity; ++i) {
            SClass<?> implParamType = this.implMethodType.parameterType(i);
            SClass<?> instantiatedParamType = this.instantiatedMethodType.parameterType(i + samOffset);
            if (this.isAdaptableTo(instantiatedParamType, implParamType, true)) continue;
            throw new LambdaConversionException(String.format("Type mismatch for lambda argument %d: %s is not convertible to %s", i, instantiatedParamType, implParamType));
        }
        SClass<?> expectedType = this.instantiatedMethodType.returnType();
        SClass<?> actualReturnType = this.implKind == 8 ? this.implDefiningClass : this.implMethodType.returnType();
        SClass<?> samReturnType = this.samMethodType.returnType();
        if (!this.isAdaptableToAsReturn(actualReturnType, expectedType)) {
            throw new LambdaConversionException(String.format("Type mismatch for lambda return: %s is not convertible to %s", actualReturnType, expectedType));
        }
        if (!this.isAdaptableToAsReturnStrict(expectedType, samReturnType)) {
            throw new LambdaConversionException(String.format("Type mismatch for lambda expected return: %s is not convertible to %s", expectedType, samReturnType));
        }
        for (SMethodType bridgeMT : this.additionalBridges) {
            if (this.isAdaptableToAsReturnStrict(expectedType, bridgeMT.returnType())) continue;
            throw new LambdaConversionException(String.format("Type mismatch for lambda expected return: %s is not convertible to %s", expectedType, bridgeMT.returnType()));
        }
    }

    private boolean isAdaptableTo(SClass<?> fromType, SClass<?> toType, boolean strict) {
        if (fromType.equals(toType)) {
            return true;
        }
        if (fromType.isPrimitive()) {
            Wrapper wfrom = Wrapper.forPrimitiveType(fromType);
            if (toType.isPrimitive()) {
                Wrapper wto = Wrapper.forPrimitiveType(toType);
                return wto.isConvertibleFrom(wfrom);
            }
            return toType.isAssignableFrom(wfrom.wrapperType());
        }
        if (toType.isPrimitive()) {
            Wrapper wfrom;
            if (Wrapper.isWrapperType(fromType) && (wfrom = Wrapper.forWrapperType(fromType)).primitiveType().isPrimitive()) {
                Wrapper wto = Wrapper.forPrimitiveType(toType);
                return wto.isConvertibleFrom(wfrom);
            }
            return !strict;
        }
        return !strict || toType.isAssignableFrom(fromType);
    }

    private boolean isAdaptableToAsReturn(SClass<?> fromType, SClass<?> toType) {
        return toType.equals(Void.TYPE) || !fromType.equals(Void.TYPE) && this.isAdaptableTo(fromType, toType, false);
    }

    private boolean isAdaptableToAsReturnStrict(SClass<?> fromType, SClass<?> toType) {
        if (fromType.equals(Void.TYPE)) {
            return toType.equals(Void.TYPE);
        }
        return this.isAdaptableTo(fromType, toType, true);
    }
}

