/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.lambda.java.lang.invoke;

import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.robovm.compiler.plugin.lambda.SCallSite;
import org.robovm.compiler.plugin.lambda.SClass;
import org.robovm.compiler.plugin.lambda.SMethodHandle;
import org.robovm.compiler.plugin.lambda.SMethodHandles;
import org.robovm.compiler.plugin.lambda.SMethodType;
import org.robovm.compiler.plugin.lambda.java.lang.invoke.AbstractValidatingLambdaMetafactory;
import org.robovm.compiler.plugin.lambda.java.lang.invoke.LambdaConversionException;
import org.robovm.compiler.plugin.lambda.java.lang.invoke.TypeConvertingMethodAdapter;
import org.robovm.compiler.plugin.lambda.sun.invoke.util.BytecodeDescriptor;

public class InnerClassLambdaMetafactory
extends AbstractValidatingLambdaMetafactory {
    private static final int CLASSFILE_VERSION = 51;
    private static final String METHOD_DESCRIPTOR_VOID = Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]);
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static final String NAME_CTOR = "<init>";
    private static final String NAME_FACTORY = "get$Lambda";
    private static final String NAME_SERIALIZED_LAMBDA = "java/lang/invoke/SerializedLambda";
    private static final String NAME_NOT_SERIALIZABLE_EXCEPTION = "java/io/NotSerializableException";
    private static final String DESCR_METHOD_WRITE_REPLACE = "()Ljava/lang/Object;";
    private static final String DESCR_METHOD_WRITE_OBJECT = "(Ljava/io/ObjectOutputStream;)V";
    private static final String DESCR_METHOD_READ_OBJECT = "(Ljava/io/ObjectInputStream;)V";
    private static final String NAME_METHOD_WRITE_REPLACE = "writeReplace";
    private static final String NAME_METHOD_READ_OBJECT = "readObject";
    private static final String NAME_METHOD_WRITE_OBJECT = "writeObject";
    private static final String DESCR_CTOR_SERIALIZED_LAMBDA = "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V";
    private static final String DESCR_CTOR_NOT_SERIALIZABLE_EXCEPTION = "(Ljava/lang/String;)V";
    private static final String[] SER_HOSTILE_EXCEPTIONS = new String[]{"java/io/NotSerializableException"};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final String implMethodClassName;
    private final String implMethodName;
    private final String implMethodDesc;
    private final SClass<?> implMethodReturnClass;
    private final SMethodType constructorType;
    private final ClassWriter cw;
    private final String[] argNames;
    private final String[] argDescs;
    private final String lambdaClassName;

    public InnerClassLambdaMetafactory(SMethodHandles.Lookup caller, SMethodType invokedType, String samMethodName, SMethodType samMethodType, SMethodHandle implMethod, SMethodType instantiatedMethodType, boolean isSerializable, SClass<?>[] markerInterfaces, SMethodType[] additionalBridges) throws LambdaConversionException {
        super(caller, invokedType, samMethodName, samMethodType, implMethod, instantiatedMethodType, isSerializable, markerInterfaces, additionalBridges);
        this.implMethodClassName = this.implDefiningClass.getName().replace('.', '/');
        this.implMethodName = this.implInfo.getName();
        this.implMethodDesc = this.implMethodType.toMethodDescriptorString();
        this.implMethodReturnClass = this.implKind == 8 ? this.implDefiningClass : this.implMethodType.returnType();
        this.constructorType = invokedType.changeReturnType(SClass.voidClass);
        this.lambdaClassName = this.targetClass.getName().replace('.', '/') + "$$Lambda$" + counter.incrementAndGet();
        this.cw = new ClassWriter(1);
        int parameterCount = invokedType.parameterCount();
        if (parameterCount > 0) {
            this.argNames = new String[parameterCount];
            this.argDescs = new String[parameterCount];
            for (int i = 0; i < parameterCount; ++i) {
                this.argNames[i] = "arg$" + (i + 1);
                this.argDescs[i] = BytecodeDescriptor.unparse(invokedType.parameterType(i));
            }
        } else {
            this.argDescs = EMPTY_STRING_ARRAY;
            this.argNames = EMPTY_STRING_ARRAY;
        }
    }

    @Override
    SCallSite buildCallSite() throws LambdaConversionException {
        byte[] classData = this.spinInnerClass();
        if (this.invokedType.parameterCount() == 0) {
            return new SCallSite(this.lambdaClassName, classData, NAME_CTOR, this.invokedType);
        }
        return new SCallSite(this.lambdaClassName, classData, NAME_FACTORY, this.invokedType);
    }

    public byte[] spinInnerClass() throws LambdaConversionException {
        String[] interfaces;
        boolean accidentallySerializable;
        String samIntf = this.samBase.getName().replace('.', '/');
        boolean bl = accidentallySerializable = !this.isSerializable && SClass.SerializableClass.isAssignableFrom(this.samBase);
        if (this.markerInterfaces.length == 0) {
            interfaces = new String[]{samIntf};
        } else {
            LinkedHashSet<String> itfs = new LinkedHashSet<String>(this.markerInterfaces.length + 1);
            itfs.add(samIntf);
            for (SClass markerInterface : this.markerInterfaces) {
                itfs.add(markerInterface.getName().replace('.', '/'));
                accidentallySerializable |= !this.isSerializable && SClass.SerializableClass.isAssignableFrom(markerInterface);
            }
            interfaces = itfs.toArray(new String[itfs.size()]);
        }
        this.cw.visit(51, 4144, this.lambdaClassName, null, JAVA_LANG_OBJECT, interfaces);
        for (int i = 0; i < this.argDescs.length; ++i) {
            FieldVisitor fv = this.cw.visitField(18, this.argNames[i], this.argDescs[i], null, null);
            fv.visitEnd();
        }
        this.generateConstructor();
        if (this.invokedType.parameterCount() != 0) {
            this.generateFactory();
        }
        MethodVisitor mv = this.cw.visitMethod(1, this.samMethodName, this.samMethodType.toMethodDescriptorString(), null, null);
        new ForwardingMethodGenerator(mv).generate(this.samMethodType);
        if (this.additionalBridges != null) {
            for (SMethodType mt : this.additionalBridges) {
                mv = this.cw.visitMethod(65, this.samMethodName, mt.toMethodDescriptorString(), null, null);
                new ForwardingMethodGenerator(mv).generate(mt);
            }
        }
        if (this.isSerializable) {
            this.generateSerializationFriendlyMethods();
        } else if (accidentallySerializable) {
            this.generateSerializationHostileMethods();
        }
        this.cw.visitEnd();
        byte[] classBytes = this.cw.toByteArray();
        return classBytes;
    }

    private void generateFactory() {
        MethodVisitor m = this.cw.visitMethod(8, NAME_FACTORY, this.invokedType.toMethodDescriptorString(), null, null);
        m.visitCode();
        m.visitTypeInsn(187, this.lambdaClassName);
        m.visitInsn(89);
        int parameterCount = this.invokedType.parameterCount();
        int varIndex = 0;
        for (int typeIndex = 0; typeIndex < parameterCount; ++typeIndex) {
            SClass<?> argType = this.invokedType.parameterType(typeIndex);
            m.visitVarInsn(InnerClassLambdaMetafactory.getLoadOpcode(argType), varIndex);
            varIndex += InnerClassLambdaMetafactory.getParameterSize(argType);
        }
        m.visitMethodInsn(183, this.lambdaClassName, NAME_CTOR, this.constructorType.toMethodDescriptorString());
        m.visitInsn(176);
        m.visitMaxs(-1, -1);
        m.visitEnd();
    }

    private void generateConstructor() {
        MethodVisitor ctor = this.cw.visitMethod(0, NAME_CTOR, this.constructorType.toMethodDescriptorString(), null, null);
        ctor.visitCode();
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, JAVA_LANG_OBJECT, NAME_CTOR, METHOD_DESCRIPTOR_VOID);
        int parameterCount = this.invokedType.parameterCount();
        int lvIndex = 0;
        for (int i = 0; i < parameterCount; ++i) {
            ctor.visitVarInsn(25, 0);
            SClass<?> argType = this.invokedType.parameterType(i);
            ctor.visitVarInsn(InnerClassLambdaMetafactory.getLoadOpcode(argType), lvIndex + 1);
            lvIndex += InnerClassLambdaMetafactory.getParameterSize(argType);
            ctor.visitFieldInsn(181, this.lambdaClassName, this.argNames[i], this.argDescs[i]);
        }
        ctor.visitInsn(177);
        ctor.visitMaxs(-1, -1);
        ctor.visitEnd();
    }

    private void generateSerializationFriendlyMethods() {
        TypeConvertingMethodAdapter mv = new TypeConvertingMethodAdapter(this.cw.visitMethod(18, NAME_METHOD_WRITE_REPLACE, DESCR_METHOD_WRITE_REPLACE, null, null));
        mv.visitCode();
        mv.visitTypeInsn(187, NAME_SERIALIZED_LAMBDA);
        mv.visitInsn(89);
        mv.visitLdcInsn(Type.getType(this.targetClass.getDescriptor()));
        mv.visitLdcInsn(this.invokedType.returnType().getName().replace('.', '/'));
        mv.visitLdcInsn(this.samMethodName);
        mv.visitLdcInsn(this.samMethodType.toMethodDescriptorString());
        mv.visitLdcInsn(this.implInfo.getReferenceKind());
        mv.visitLdcInsn(this.implInfo.getDeclaringClass().getName().replace('.', '/'));
        mv.visitLdcInsn(this.implInfo.getName());
        mv.visitLdcInsn(this.implInfo.getMethodType().toMethodDescriptorString());
        mv.visitLdcInsn(this.instantiatedMethodType.toMethodDescriptorString());
        mv.iconst(this.argDescs.length);
        mv.visitTypeInsn(189, JAVA_LANG_OBJECT);
        for (int i = 0; i < this.argDescs.length; ++i) {
            mv.visitInsn(89);
            mv.iconst(i);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.lambdaClassName, this.argNames[i], this.argDescs[i]);
            mv.boxIfTypePrimitive(Type.getType(this.argDescs[i]));
            mv.visitInsn(83);
        }
        mv.visitMethodInsn(183, NAME_SERIALIZED_LAMBDA, NAME_CTOR, DESCR_CTOR_SERIALIZED_LAMBDA);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void generateSerializationHostileMethods() {
        MethodVisitor mv = this.cw.visitMethod(18, NAME_METHOD_WRITE_OBJECT, DESCR_METHOD_WRITE_OBJECT, null, SER_HOSTILE_EXCEPTIONS);
        mv.visitCode();
        mv.visitTypeInsn(187, NAME_NOT_SERIALIZABLE_EXCEPTION);
        mv.visitInsn(89);
        mv.visitLdcInsn("Non-serializable lambda");
        mv.visitMethodInsn(183, NAME_NOT_SERIALIZABLE_EXCEPTION, NAME_CTOR, DESCR_CTOR_NOT_SERIALIZABLE_EXCEPTION);
        mv.visitInsn(191);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = this.cw.visitMethod(18, NAME_METHOD_READ_OBJECT, DESCR_METHOD_READ_OBJECT, null, SER_HOSTILE_EXCEPTIONS);
        mv.visitCode();
        mv.visitTypeInsn(187, NAME_NOT_SERIALIZABLE_EXCEPTION);
        mv.visitInsn(89);
        mv.visitLdcInsn("Non-serializable lambda");
        mv.visitMethodInsn(183, NAME_NOT_SERIALIZABLE_EXCEPTION, NAME_CTOR, DESCR_CTOR_NOT_SERIALIZABLE_EXCEPTION);
        mv.visitInsn(191);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    static int getParameterSize(SClass<?> c) {
        if (c == SClass.voidClass) {
            return 0;
        }
        if (c == SClass.longClass || c == SClass.doubleClass) {
            return 2;
        }
        return 1;
    }

    static int getLoadOpcode(SClass<?> c) {
        if (c == SClass.voidClass) {
            throw new InternalError("Unexpected void type of load opcode");
        }
        return 21 + InnerClassLambdaMetafactory.getOpcodeOffset(c);
    }

    static int getReturnOpcode(SClass<?> c) {
        if (c == SClass.voidClass) {
            return 177;
        }
        return 172 + InnerClassLambdaMetafactory.getOpcodeOffset(c);
    }

    private static int getOpcodeOffset(SClass<?> c) {
        if (c.isPrimitive()) {
            if (c == SClass.longClass) {
                return 1;
            }
            if (c == SClass.floatClass) {
                return 2;
            }
            if (c == SClass.doubleClass) {
                return 3;
            }
            return 0;
        }
        return 4;
    }

    private class ForwardingMethodGenerator
    extends TypeConvertingMethodAdapter {
        ForwardingMethodGenerator(MethodVisitor mv) {
            super(mv);
        }

        void generate(SMethodType methodType) {
            this.visitCode();
            if (InnerClassLambdaMetafactory.this.implKind == 8) {
                this.visitTypeInsn(187, InnerClassLambdaMetafactory.this.implMethodClassName);
                this.visitInsn(89);
            }
            for (int i = 0; i < InnerClassLambdaMetafactory.this.argNames.length; ++i) {
                this.visitVarInsn(25, 0);
                this.visitFieldInsn(180, InnerClassLambdaMetafactory.this.lambdaClassName, InnerClassLambdaMetafactory.this.argNames[i], InnerClassLambdaMetafactory.this.argDescs[i]);
            }
            this.convertArgumentTypes(methodType);
            this.visitMethodInsn(this.invocationOpcode(), InnerClassLambdaMetafactory.this.implMethodClassName, InnerClassLambdaMetafactory.this.implMethodName, InnerClassLambdaMetafactory.this.implMethodDesc);
            SClass<?> samReturnClass = methodType.returnType();
            this.convertType(InnerClassLambdaMetafactory.this.implMethodReturnClass, samReturnClass, samReturnClass);
            this.visitInsn(InnerClassLambdaMetafactory.getReturnOpcode(samReturnClass));
            this.visitMaxs(-1, -1);
            this.visitEnd();
        }

        private void convertArgumentTypes(SMethodType samType) {
            int samReceiverLength;
            int lvIndex = 0;
            boolean samIncludesReceiver = InnerClassLambdaMetafactory.this.implIsInstanceMethod && InnerClassLambdaMetafactory.this.invokedType.parameterCount() == 0;
            int n = samReceiverLength = samIncludesReceiver ? 1 : 0;
            if (samIncludesReceiver) {
                SClass<?> rcvrType = samType.parameterType(0);
                this.visitVarInsn(InnerClassLambdaMetafactory.getLoadOpcode(rcvrType), lvIndex + 1);
                lvIndex += InnerClassLambdaMetafactory.getParameterSize(rcvrType);
                this.convertType(rcvrType, InnerClassLambdaMetafactory.this.implDefiningClass, InnerClassLambdaMetafactory.this.instantiatedMethodType.parameterType(0));
            }
            int samParametersLength = samType.parameterCount();
            int argOffset = InnerClassLambdaMetafactory.this.implMethodType.parameterCount() - samParametersLength;
            for (int i = samReceiverLength; i < samParametersLength; ++i) {
                SClass<?> argType = samType.parameterType(i);
                this.visitVarInsn(InnerClassLambdaMetafactory.getLoadOpcode(argType), lvIndex + 1);
                lvIndex += InnerClassLambdaMetafactory.getParameterSize(argType);
                this.convertType(argType, InnerClassLambdaMetafactory.this.implMethodType.parameterType(argOffset + i), InnerClassLambdaMetafactory.this.instantiatedMethodType.parameterType(i));
            }
        }

        private int invocationOpcode() throws InternalError {
            switch (InnerClassLambdaMetafactory.this.implKind) {
                case 6: {
                    return 184;
                }
                case 8: {
                    return 183;
                }
                case 5: {
                    return 182;
                }
                case 9: {
                    return 185;
                }
                case 7: {
                    return 183;
                }
            }
            throw new InternalError("Unexpected invocation kind: " + InnerClassLambdaMetafactory.this.implKind);
        }
    }
}

