/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.lambda.java.lang.invoke;

import java.util.Arrays;
import org.robovm.compiler.plugin.lambda.SCallSite;
import org.robovm.compiler.plugin.lambda.SClass;
import org.robovm.compiler.plugin.lambda.SMethodHandle;
import org.robovm.compiler.plugin.lambda.SMethodHandles;
import org.robovm.compiler.plugin.lambda.SMethodType;
import org.robovm.compiler.plugin.lambda.java.lang.invoke.AbstractValidatingLambdaMetafactory;
import org.robovm.compiler.plugin.lambda.java.lang.invoke.InnerClassLambdaMetafactory;
import org.robovm.compiler.plugin.lambda.java.lang.invoke.LambdaConversionException;

public class LambdaMetafactory {
    public static final int FLAG_SERIALIZABLE = 1;
    public static final int FLAG_MARKERS = 2;
    public static final int FLAG_BRIDGES = 4;
    private static final SClass<?>[] EMPTY_CLASS_ARRAY = new SClass[0];
    private static final SMethodType[] EMPTY_MT_ARRAY = new SMethodType[0];

    public static SCallSite metafactory(SMethodHandles.Lookup caller, String invokedName, SMethodType invokedType, SMethodType samMethodType, SMethodHandle implMethod, SMethodType instantiatedMethodType) throws LambdaConversionException {
        InnerClassLambdaMetafactory mf = new InnerClassLambdaMetafactory(caller, invokedType, invokedName, samMethodType, implMethod, instantiatedMethodType, false, EMPTY_CLASS_ARRAY, EMPTY_MT_ARRAY);
        mf.validateMetafactoryArgs();
        return ((AbstractValidatingLambdaMetafactory)mf).buildCallSite();
    }

    public static SCallSite altMetafactory(SMethodHandles.Lookup caller, String invokedName, SMethodType invokedType, Object ... args) throws LambdaConversionException {
        boolean isSerializable;
        SMethodType[] bridges;
        SClass<?>[] markerInterfaces;
        SMethodType samMethodType = (SMethodType)args[0];
        SMethodHandle implMethod = (SMethodHandle)args[1];
        SMethodType instantiatedMethodType = (SMethodType)args[2];
        int flags = (Integer)args[3];
        int argIndex = 4;
        if ((flags & 2) != 0) {
            int markerCount = (Integer)args[argIndex++];
            markerInterfaces = new SClass[markerCount];
            System.arraycopy(args, argIndex, markerInterfaces, 0, markerCount);
            argIndex += markerCount;
        } else {
            markerInterfaces = EMPTY_CLASS_ARRAY;
        }
        if ((flags & 4) != 0) {
            int bridgeCount = (Integer)args[argIndex++];
            bridges = new SMethodType[bridgeCount];
            System.arraycopy(args, argIndex, bridges, 0, bridgeCount);
            argIndex += bridgeCount;
        } else {
            bridges = EMPTY_MT_ARRAY;
        }
        boolean bl = isSerializable = (flags & 1) != 0;
        if (isSerializable) {
            boolean foundSerializableSupertype = SClass.SerializableClass.isAssignableFrom(invokedType.returnType());
            for (SClass<?> c : markerInterfaces) {
                foundSerializableSupertype |= SClass.SerializableClass.isAssignableFrom(c);
            }
            if (!foundSerializableSupertype) {
                markerInterfaces = Arrays.copyOf(markerInterfaces, markerInterfaces.length + 1);
                markerInterfaces[markerInterfaces.length - 1] = SClass.SerializableClass;
            }
        }
        InnerClassLambdaMetafactory mf = new InnerClassLambdaMetafactory(caller, invokedType, invokedName, samMethodType, implMethod, instantiatedMethodType, isSerializable, markerInterfaces, bridges);
        mf.validateMetafactoryArgs();
        return ((AbstractValidatingLambdaMetafactory)mf).buildCallSite();
    }
}

