/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.lambda.sun.invoke.util;

import java.util.List;
import org.robovm.compiler.plugin.lambda.SClass;
import org.robovm.compiler.plugin.lambda.SMethodType;
import org.robovm.compiler.plugin.lambda.sun.invoke.util.Wrapper;

public class BytecodeDescriptor {
    private BytecodeDescriptor() {
    }

    public static String unparse(SClass<?> type) {
        StringBuilder sb = new StringBuilder();
        BytecodeDescriptor.unparseSig(type, sb);
        return sb.toString();
    }

    public static String unparse(SMethodType type) {
        return BytecodeDescriptor.unparseMethod(type.returnType(), type.parameterList());
    }

    public static String unparse(Object type) {
        if (type instanceof SClass) {
            return BytecodeDescriptor.unparse((SClass)type);
        }
        if (type instanceof SMethodType) {
            return BytecodeDescriptor.unparse((SMethodType)type);
        }
        return (String)type;
    }

    public static String unparseMethod(SClass<?> rtype, List<SClass<?>> ptypes) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (SClass<?> pt : ptypes) {
            BytecodeDescriptor.unparseSig(pt, sb);
        }
        sb.append(')');
        BytecodeDescriptor.unparseSig(rtype, sb);
        return sb.toString();
    }

    private static void unparseSig(SClass<?> t, StringBuilder sb) {
        char c = Wrapper.forBasicType(t).basicTypeChar();
        if (c != 'L') {
            sb.append(c);
        } else {
            boolean lsemi;
            boolean bl = lsemi = !t.isArray();
            if (lsemi) {
                sb.append('L');
            }
            sb.append(t.getName().replace('.', '/'));
            if (lsemi) {
                sb.append(';');
            }
        }
    }
}

