/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.objc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.robovm.compiler.Annotations;
import org.robovm.compiler.CompilerException;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.plugin.AbstractCompilerPlugin;
import org.robovm.compiler.plugin.objc.ObjCProtocolProxyPlugin;
import soot.Body;
import soot.BooleanType;
import soot.Local;
import soot.Modifier;
import soot.PatchingChain;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.SootResolver;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.jimple.ClassConstant;
import soot.jimple.IntConstant;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.Host;

public class ObjCMemberPlugin
extends AbstractCompilerPlugin {
    public static final String OBJC_ANNOTATIONS_PACKAGE = "org/robovm/objc/annotation";
    public static final String METHOD = "Lorg/robovm/objc/annotation/Method;";
    public static final String PROPERTY = "Lorg/robovm/objc/annotation/Property;";
    public static final String BIND_SELECTOR = "Lorg/robovm/objc/annotation/BindSelector;";
    public static final String NOT_IMPLEMENTED = "Lorg/robovm/objc/annotation/NotImplemented;";
    public static final String SELECTOR = "org.robovm.objc.Selector";
    public static final String OBJC_SUPER = "org.robovm.objc.ObjCSuper";
    public static final String OBJC_CLASS = "org.robovm.objc.ObjCClass";
    public static final String OBJC_OBJECT = "org.robovm.objc.ObjCObject";
    public static final String OBJC_RUNTIME = "org.robovm.objc.ObjCRuntime";
    public static final String OBJC_EXTENSIONS = "org.robovm.objc.ObjCExtensions";
    private boolean initialized = false;
    private SootClass org_robovm_objc_ObjCClass = null;
    private SootClass org_robovm_objc_ObjCSuper = null;
    private SootClass org_robovm_objc_ObjCObject = null;
    private SootClass org_robovm_objc_ObjCRuntime = null;
    private SootClass org_robovm_objc_ObjCExtensions = null;
    private SootClass org_robovm_objc_Selector = null;
    private SootClass java_lang_String = null;
    private SootClass java_lang_Class = null;
    private SootMethodRef org_robovm_objc_Selector_register = null;
    private SootMethodRef org_robovm_objc_ObjCObject_getSuper = null;
    private SootFieldRef org_robovm_objc_ObjCObject_customClass = null;
    private SootMethodRef org_robovm_objc_ObjCClass_getByType = null;
    private SootMethodRef org_robovm_objc_ObjCRuntime_bind = null;
    private SootMethodRef org_robovm_objc_ObjCObject_updateStrongRef = null;
    private SootMethodRef org_robovm_objc_ObjCExtensions_updateStrongRef = null;

    static SootMethod getOrCreateStaticInitializer(SootClass sootClass) {
        for (SootMethod m : sootClass.getMethods()) {
            if (!"<clinit>".equals(m.getName())) continue;
            return m;
        }
        SootMethod m = new SootMethod("<clinit>", Collections.emptyList(), VoidType.v(), 8);
        JimpleBody body = Jimple.v().newBody(m);
        body.getUnits().add(Jimple.v().newReturnVoidStmt());
        m.setActiveBody(body);
        sootClass.addMethod(m);
        return m;
    }

    private String getSelectorFieldName(String selectorName) {
        return "$sel$" + selectorName.replace(':', '$');
    }

    private SootField getSelectorField(String selectorName) {
        return new SootField(this.getSelectorFieldName(selectorName), this.org_robovm_objc_Selector.getType(), 26);
    }

    private SootMethod getMsgSendMethod(String selectorName, SootMethod method, boolean isCallback, Type receiverType, boolean extensions) {
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        if (extensions) {
            paramTypes.add(method.getParameterType(0));
        } else if (method.isStatic()) {
            paramTypes.add(this.org_robovm_objc_ObjCClass.getType());
        } else {
            paramTypes.add(receiverType == null ? method.getDeclaringClass().getType() : receiverType);
        }
        paramTypes.add(this.org_robovm_objc_Selector.getType());
        if (extensions) {
            paramTypes.addAll(method.getParameterTypes().subList(1, method.getParameterTypes().size()));
        } else {
            paramTypes.addAll(method.getParameterTypes());
        }
        SootMethod m = new SootMethod((isCallback ? "$cb$" : "$m$") + selectorName.replace(':', '$'), paramTypes, method.getReturnType(), 0xA | (isCallback ? 0 : 256));
        Annotations.copyAnnotations(method, m, Annotations.Visibility.RuntimeVisible);
        if (extensions) {
            Annotations.copyParameterAnnotations(method, m, 0, 1, 0, Annotations.Visibility.RuntimeVisible);
            if (method.getParameterCount() > 1) {
                Annotations.copyParameterAnnotations(method, m, 1, method.getParameterCount(), 1, Annotations.Visibility.RuntimeVisible);
            }
        } else {
            Annotations.copyParameterAnnotations(method, m, 0, method.getParameterCount(), 2, Annotations.Visibility.RuntimeVisible);
        }
        return m;
    }

    private SootMethod getMsgSendMethod(String selectorName, SootMethod method, boolean extensions) {
        return this.getMsgSendMethod(selectorName, method, false, null, extensions);
    }

    private SootMethod getMsgSendSuperMethod(String selectorName, SootMethod method) {
        ArrayList<RefType> paramTypes = new ArrayList<RefType>();
        paramTypes.add(this.org_robovm_objc_ObjCSuper.getType());
        paramTypes.add(this.org_robovm_objc_Selector.getType());
        paramTypes.addAll(method.getParameterTypes());
        SootMethod m = new SootMethod("$m$super$" + selectorName.replace(':', '$'), paramTypes, method.getReturnType(), 266);
        Annotations.copyAnnotations(method, m, Annotations.Visibility.RuntimeVisible);
        Annotations.copyParameterAnnotations(method, m, 0, method.getParameterCount(), 2, Annotations.Visibility.RuntimeVisible);
        return m;
    }

    private SootMethod getCallbackMethod(String selectorName, SootMethod method, Type receiverType) {
        return this.getMsgSendMethod(selectorName, method, true, receiverType, false);
    }

    private void addBindCall(SootClass sootClass) {
        Jimple j = Jimple.v();
        SootMethod clinit = ObjCMemberPlugin.getOrCreateStaticInitializer(sootClass);
        Body body = clinit.retrieveActiveBody();
        String internalName = sootClass.getName().replace('.', '/');
        ClassConstant c = ClassConstant.v(internalName);
        PatchingChain<Unit> units = body.getUnits();
        for (Unit unit : units) {
            StaticInvokeExpr expr;
            SootMethodRef ref;
            InvokeStmt stmt;
            if (!(unit instanceof InvokeStmt) || !((stmt = (InvokeStmt)unit).getInvokeExpr() instanceof StaticInvokeExpr) || !(ref = (expr = (StaticInvokeExpr)stmt.getInvokeExpr()).getMethodRef()).isStatic() || !ref.declaringClass().equals(this.org_robovm_objc_ObjCRuntime) || !ref.name().equals("bind") || !ref.parameterTypes().isEmpty() && !expr.getArg(0).equals(c)) continue;
            return;
        }
        units.insertBefore(j.newInvokeStmt(j.newStaticInvokeExpr(this.org_robovm_objc_ObjCRuntime_bind, ClassConstant.v(internalName))), (Unit)units.getLast());
    }

    private void addObjCClassField(SootClass sootClass) {
        Jimple j = Jimple.v();
        SootMethod clinit = ObjCMemberPlugin.getOrCreateStaticInitializer(sootClass);
        Body body = clinit.retrieveActiveBody();
        Local objCClass = Jimple.v().newLocal("$objCClass", this.org_robovm_objc_ObjCClass.getType());
        body.getLocals().add(objCClass);
        PatchingChain<Unit> units = body.getUnits();
        SootField f = new SootField("$objCClass", this.org_robovm_objc_ObjCClass.getType(), 26);
        sootClass.addField(f);
        units.insertBefore((Unit)((Object)Arrays.asList(j.newAssignStmt(objCClass, j.newStaticInvokeExpr(this.org_robovm_objc_ObjCClass_getByType, ClassConstant.v(sootClass.getName().replace('.', '/')))), j.newAssignStmt(j.newStaticFieldRef(f.makeRef()), objCClass))), (Unit)units.getLast());
    }

    private void registerSelectors(SootClass sootClass, Set<String> selectors) {
        Jimple j = Jimple.v();
        SootMethod clinit = ObjCMemberPlugin.getOrCreateStaticInitializer(sootClass);
        Body body = clinit.retrieveActiveBody();
        Local sel = Jimple.v().newLocal("$sel", this.org_robovm_objc_Selector.getType());
        body.getLocals().add(sel);
        PatchingChain<Unit> units = body.getUnits();
        for (String selectorName : selectors) {
            SootField f = this.getSelectorField(selectorName);
            sootClass.addField(f);
            units.insertBefore((Unit)((Object)Arrays.asList(j.newAssignStmt(sel, j.newStaticInvokeExpr(this.org_robovm_objc_Selector_register, StringConstant.v(selectorName))), j.newAssignStmt(j.newStaticFieldRef(f.makeRef()), sel))), (Unit)units.getLast());
        }
    }

    private void init(Config config) {
        if (this.initialized) {
            return;
        }
        if (config.getClazzes().load(OBJC_OBJECT.replace('.', '/')) == null) {
            this.initialized = true;
            return;
        }
        SootResolver r = SootResolver.v();
        this.org_robovm_objc_ObjCObject = r.resolveClass(OBJC_OBJECT, 1);
        this.org_robovm_objc_ObjCExtensions = r.resolveClass(OBJC_EXTENSIONS, 1);
        this.org_robovm_objc_ObjCClass = r.makeClassRef(OBJC_CLASS);
        this.org_robovm_objc_ObjCSuper = r.makeClassRef(OBJC_SUPER);
        this.org_robovm_objc_ObjCRuntime = r.makeClassRef(OBJC_RUNTIME);
        this.org_robovm_objc_Selector = r.makeClassRef(SELECTOR);
        SootClass java_lang_Object = r.makeClassRef("java.lang.Object");
        this.java_lang_String = r.makeClassRef("java.lang.String");
        this.java_lang_Class = r.makeClassRef("java.lang.Class");
        this.org_robovm_objc_Selector_register = Scene.v().makeMethodRef(this.org_robovm_objc_Selector, "register", Arrays.asList(this.java_lang_String.getType()), this.org_robovm_objc_Selector.getType(), true);
        this.org_robovm_objc_ObjCObject_getSuper = Scene.v().makeMethodRef(this.org_robovm_objc_ObjCObject, "getSuper", Collections.emptyList(), this.org_robovm_objc_ObjCSuper.getType(), false);
        this.org_robovm_objc_ObjCObject_updateStrongRef = Scene.v().makeMethodRef(this.org_robovm_objc_ObjCObject, "updateStrongRef", Arrays.asList(java_lang_Object.getType(), java_lang_Object.getType()), VoidType.v(), false);
        this.org_robovm_objc_ObjCClass_getByType = Scene.v().makeMethodRef(this.org_robovm_objc_ObjCClass, "getByType", Arrays.asList(this.java_lang_Class.getType()), this.org_robovm_objc_ObjCClass.getType(), true);
        this.org_robovm_objc_ObjCRuntime_bind = Scene.v().makeMethodRef(this.org_robovm_objc_ObjCRuntime, "bind", Arrays.asList(this.java_lang_Class.getType()), VoidType.v(), true);
        this.org_robovm_objc_ObjCObject_customClass = Scene.v().makeFieldRef(this.org_robovm_objc_ObjCObject, "customClass", BooleanType.v(), false);
        this.org_robovm_objc_ObjCExtensions_updateStrongRef = Scene.v().makeMethodRef(this.org_robovm_objc_ObjCExtensions, "updateStrongRef", Arrays.asList(this.org_robovm_objc_ObjCObject.getType(), java_lang_Object.getType(), java_lang_Object.getType()), VoidType.v(), true);
        this.initialized = true;
    }

    private boolean isObjCObject(SootClass cls) {
        if (this.org_robovm_objc_ObjCObject == null || this.org_robovm_objc_ObjCObject.isPhantom()) {
            return false;
        }
        while (cls != this.org_robovm_objc_ObjCObject && cls.hasSuperclass()) {
            cls = cls.getSuperclass();
        }
        return cls == this.org_robovm_objc_ObjCObject;
    }

    private boolean isObjCExtensions(SootClass cls) {
        if (this.org_robovm_objc_ObjCExtensions == null || this.org_robovm_objc_ObjCExtensions.isPhantom()) {
            return false;
        }
        while (cls != this.org_robovm_objc_ObjCExtensions && cls.hasSuperclass()) {
            cls = cls.getSuperclass();
        }
        return cls == this.org_robovm_objc_ObjCExtensions;
    }

    @Override
    public void beforeClass(Config config, Clazz clazz, ModuleBuilder moduleBuilder) {
        this.init(config);
        SootClass sootClass = clazz.getSootClass();
        boolean extensions = false;
        if (!sootClass.isInterface() && (this.isObjCObject(sootClass) || (extensions = this.isObjCExtensions(sootClass)))) {
            TreeSet<String> selectors = new TreeSet<String>();
            HashSet<String> overridables = new HashSet<String>();
            for (SootMethod method : sootClass.getMethods()) {
                if ("<clinit>".equals(method.getName()) || "<init>".equals(method.getName())) continue;
                this.transformMethod(config, clazz, sootClass, method, selectors, overridables, extensions);
            }
            this.addBindCall(sootClass);
            if (!extensions) {
                this.addObjCClassField(sootClass);
            }
            this.registerSelectors(sootClass, selectors);
        }
    }

    private static <E> List<E> l(E head, List<E> tail) {
        LinkedList<E> l = new LinkedList<E>(tail);
        l.addFirst(head);
        return l;
    }

    private boolean isOverridable(SootMethod method) {
        return !method.isStatic() && !method.isPrivate() && (method.getModifiers() & 0x10) == 0 && (method.getDeclaringClass().getModifiers() & 0x10) == 0;
    }

    private boolean checkOverridable(Set<String> overridables, String selectorName, SootMethod method) {
        boolean b = this.isOverridable(method);
        if (b && overridables.contains(selectorName)) {
            throw new CompilerException("Found multiple overridable @Method or @Property methods in " + method.getDeclaringClass() + " with the selector '" + selectorName + "'.");
        }
        return b;
    }

    private void transformMethod(Config config, Clazz clazz, SootClass sootClass, SootMethod method, Set<String> selectors, Set<String> overridables, boolean extensions) {
        AnnotationTag methodAnno = Annotations.getAnnotation(method, METHOD);
        if (methodAnno != null) {
            if (!(!extensions || method.isStatic() && method.isNative())) {
                throw new CompilerException("Objective-C @Method method " + method + " in extension class must be static and native.");
            }
            String selectorName = Annotations.readStringElem(methodAnno, "selector", "").trim();
            if (selectorName.length() == 0) {
                int i;
                StringBuilder sb = new StringBuilder(method.getName());
                int argCount = method.getParameterCount();
                int n = i = extensions ? 1 : 0;
                while (i < argCount) {
                    sb.append(':');
                    ++i;
                }
                selectorName = sb.toString();
            }
            if (!extensions && (method.getModifiers() & 0x10) == 0) {
                RefType receiverType = ObjCProtocolProxyPlugin.isObjCProxy(sootClass) ? sootClass.getInterfaces().getFirst().getType() : sootClass.getType();
                this.createCallback(sootClass, method, selectorName, receiverType);
            }
            if (method.isNative()) {
                if (this.checkOverridable(overridables, selectorName, method)) {
                    overridables.add(selectorName);
                }
                selectors.add(selectorName);
                this.createBridge(sootClass, method, selectorName, false, extensions);
            }
        } else {
            AnnotationTag propertyAnno = Annotations.getAnnotation(method, PROPERTY);
            if (propertyAnno != null) {
                int setterParamCount;
                if (!(!extensions || method.isStatic() && method.isNative())) {
                    throw new CompilerException("Objective-C @Property method " + method + " in extension class must be static and native.");
                }
                int getterParamCount = extensions ? 1 : 0;
                int n = setterParamCount = extensions ? 2 : 1;
                if (method.getReturnType() != VoidType.v() && method.getParameterCount() != getterParamCount || method.getReturnType() == VoidType.v() && method.getParameterCount() != setterParamCount) {
                    if (!extensions) {
                        throw new CompilerException("Objective-C @Property method " + method + " does not have a supported signature. @Property getter methods" + " must take 0 arguments and must not return void. " + "@Property setter methods must take 1 argument and return void.");
                    }
                    throw new CompilerException("Objective-C @Property method " + method + " in extension class" + " does not have a supported signature. @Property getter methods in extension classes" + " must take 1 argument (the 'this' reference) and must not return void. " + "@Property setter methods in extension classes must " + "take 2 arguments (first is the 'this' reference) and return void.");
                }
                boolean isGetter = method.getReturnType() != VoidType.v();
                String selectorName = Annotations.readStringElem(propertyAnno, "selector", "").trim();
                if (selectorName.length() == 0) {
                    String methodName = method.getName();
                    if (!(isGetter && methodName.startsWith("get") && methodName.length() > 3 || isGetter && methodName.startsWith("is") && methodName.length() > 2 || !isGetter && methodName.startsWith("set") && methodName.length() > 3)) {
                        throw new CompilerException("Invalid Objective-C @Property method name " + method + ". @Property methods without an explicit selector value " + "must follow the Java beans property method naming convention.");
                    }
                    selectorName = methodName;
                    if (isGetter) {
                        selectorName = methodName.startsWith("is") ? methodName.substring(2) : methodName.substring(3);
                        selectorName = selectorName.substring(0, 1).toLowerCase() + selectorName.substring(1);
                    } else {
                        selectorName = selectorName + ":";
                    }
                }
                if (!extensions && (method.getModifiers() & 0x10) == 0) {
                    RefType receiverType = ObjCProtocolProxyPlugin.isObjCProxy(sootClass) ? sootClass.getInterfaces().getFirst().getType() : sootClass.getType();
                    this.createCallback(sootClass, method, selectorName, receiverType);
                }
                if (method.isNative()) {
                    if (this.checkOverridable(overridables, selectorName, method)) {
                        overridables.add(selectorName);
                    }
                    selectors.add(selectorName);
                    boolean strongRefSetter = !isGetter && Annotations.readBooleanElem(propertyAnno, "strongRef", false);
                    this.createBridge(sootClass, method, selectorName, strongRefSetter, extensions);
                }
            }
        }
    }

    private void createCallback(SootClass sootClass, SootMethod method, String selectorName, Type receiverType) {
        Jimple j = Jimple.v();
        SootMethod callbackMethod = this.getCallbackMethod(selectorName, method, receiverType);
        sootClass.addMethod(callbackMethod);
        ObjCMemberPlugin.addCallbackAnnotation(callbackMethod);
        ObjCMemberPlugin.addBindSelectorAnnotation(callbackMethod, selectorName);
        JimpleBody body = j.newBody(callbackMethod);
        callbackMethod.setActiveBody(body);
        PatchingChain<Unit> units = body.getUnits();
        Local thiz = null;
        if (!method.isStatic()) {
            thiz = j.newLocal("$this", receiverType);
            body.getLocals().add(thiz);
            units.add(j.newIdentityStmt(thiz, j.newParameterRef(receiverType, 0)));
        }
        LinkedList<Local> args = new LinkedList<Local>();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Type t = method.getParameterType(i);
            Local p = j.newLocal("$p" + i, t);
            body.getLocals().add(p);
            units.add(j.newIdentityStmt(p, j.newParameterRef(t, i + 2)));
            args.add(p);
        }
        Local ret = null;
        if (method.getReturnType() != VoidType.v()) {
            ret = j.newLocal("$ret", method.getReturnType());
            body.getLocals().add(ret);
        }
        SootMethodRef targetMethod = method.makeRef();
        if (((RefType)receiverType).getSootClass().isInterface()) {
            List parameterTypes = method.getParameterTypes();
            targetMethod = Scene.v().makeMethodRef(((RefType)receiverType).getSootClass(), method.getName(), parameterTypes, method.getReturnType(), false);
        }
        StaticInvokeExpr expr = method.isStatic() ? j.newStaticInvokeExpr(targetMethod, args) : (((RefType)receiverType).getSootClass().isInterface() ? j.newInterfaceInvokeExpr(thiz, targetMethod, args) : j.newVirtualInvokeExpr(thiz, targetMethod, args));
        units.add(ret == null ? j.newInvokeStmt(expr) : j.newAssignStmt(ret, expr));
        if (ret != null) {
            units.add(j.newReturnStmt(ret));
        } else {
            units.add(j.newReturnVoidStmt());
        }
    }

    private SootMethod findStrongRefGetter(SootClass sootClass, SootMethod method, boolean extensions) {
        String setterPropName = Annotations.readStringElem(Annotations.getAnnotation(method, PROPERTY), "name", "").trim();
        if (setterPropName.length() == 0) {
            String methodName = method.getName();
            if (!methodName.startsWith("set") || methodName.length() == 3) {
                throw new CompilerException("Failed to determine the property name from the @Property method " + method + ". Either specify the name explicitly in the @Property " + "annotation or rename the method according to the Java " + "beans property setter method naming convention.");
            }
            setterPropName = methodName.substring(3);
            setterPropName = setterPropName.substring(0, 1).toLowerCase() + setterPropName.substring(1);
        }
        int paramCount = extensions ? 1 : 0;
        Type propType = method.getParameterType(extensions ? 1 : 0);
        for (SootMethod m : sootClass.getMethods()) {
            AnnotationTag propertyAnno;
            if (m == method || method.isStatic() != m.isStatic() || m.getParameterCount() != paramCount || !m.getReturnType().equals(propType) || (propertyAnno = Annotations.getAnnotation(m, PROPERTY)) == null) continue;
            String getterPropName = Annotations.readStringElem(propertyAnno, "name", "").trim();
            if (getterPropName.length() == 0) {
                String methodName = m.getName();
                if (!methodName.startsWith("get") || methodName.length() == 3) continue;
                getterPropName = methodName.substring(3);
                getterPropName = getterPropName.substring(0, 1).toLowerCase() + getterPropName.substring(1);
            }
            if (!setterPropName.equals(getterPropName)) continue;
            return m;
        }
        throw new CompilerException("Failed to determine the getter method corresponding to the strong ref @Property setter method " + method + ". The getter must either specify the name explicitly in the @Property " + "annotation or be named according to the Java " + "beans property getter method naming convention.");
    }

    private void createBridge(SootClass sootClass, SootMethod method, String selectorName, boolean strongRefSetter, boolean extensions) {
        Stmt invokeMsgSendStmt;
        Type propType;
        int i;
        Jimple j = Jimple.v();
        SootMethod msgSendMethod = this.getMsgSendMethod(selectorName, method, extensions);
        sootClass.addMethod(msgSendMethod);
        ObjCMemberPlugin.addBridgeAnnotation(msgSendMethod);
        SootMethod msgSendSuperMethod = null;
        if (!extensions && !method.isStatic()) {
            msgSendSuperMethod = this.getMsgSendSuperMethod(selectorName, method);
            sootClass.addMethod(msgSendSuperMethod);
            ObjCMemberPlugin.addBridgeAnnotation(msgSendSuperMethod);
        }
        method.setModifiers(method.getModifiers() & 0xFFFFFEFF);
        if (this.isOverridable(method)) {
            ObjCMemberPlugin.addNotImplementedAnnotation(method, selectorName);
        }
        JimpleBody body = j.newBody(method);
        method.setActiveBody(body);
        PatchingChain<Unit> units = body.getUnits();
        Local thiz = null;
        if (extensions) {
            thiz = j.newLocal("$this", method.getParameterType(0));
            body.getLocals().add(thiz);
            units.add(j.newIdentityStmt(thiz, j.newParameterRef(method.getParameterType(0), 0)));
        } else if (!method.isStatic()) {
            thiz = j.newLocal("$this", sootClass.getType());
            body.getLocals().add(thiz);
            units.add(j.newIdentityStmt(thiz, j.newThisRef(sootClass.getType())));
        }
        LinkedList<Local> args = new LinkedList<Local>();
        int n = i = extensions ? 1 : 0;
        while (i < method.getParameterCount()) {
            Type t = method.getParameterType(i);
            Local p = j.newLocal("$p" + i, t);
            body.getLocals().add(p);
            units.add(j.newIdentityStmt(p, j.newParameterRef(t, i)));
            args.add(p);
            ++i;
        }
        Local objCClass = null;
        if (!extensions && method.isStatic()) {
            objCClass = j.newLocal("$objCClass", this.org_robovm_objc_ObjCClass.getType());
            body.getLocals().add(objCClass);
            units.add(j.newAssignStmt(objCClass, j.newStaticFieldRef(Scene.v().makeFieldRef(sootClass, "$objCClass", this.org_robovm_objc_ObjCClass.getType(), true))));
        }
        if (strongRefSetter && (propType = method.getParameterType(extensions ? 1 : 0)) instanceof RefLikeType) {
            SootMethodRef getter = this.findStrongRefGetter(sootClass, method, extensions).makeRef();
            Local before = j.newLocal("$before", propType);
            body.getLocals().add(before);
            units.add(j.newAssignStmt(before, extensions ? j.newStaticInvokeExpr(getter, thiz) : (objCClass != null ? j.newStaticInvokeExpr(getter) : j.newVirtualInvokeExpr(thiz, getter))));
            Value after = (Value)args.get(0);
            if (extensions) {
                units.add(j.newInvokeStmt(j.newStaticInvokeExpr(this.org_robovm_objc_ObjCExtensions_updateStrongRef, Arrays.asList(thiz, before, after))));
            } else {
                units.add(j.newInvokeStmt(j.newVirtualInvokeExpr(objCClass != null ? objCClass : thiz, this.org_robovm_objc_ObjCObject_updateStrongRef, before, after)));
            }
        }
        Local sel = j.newLocal("$sel", this.org_robovm_objc_Selector.getType());
        body.getLocals().add(sel);
        units.add(j.newAssignStmt(sel, j.newStaticFieldRef(Scene.v().makeFieldRef(sootClass, this.getSelectorFieldName(selectorName), this.org_robovm_objc_Selector.getType(), true))));
        args.addFirst(sel);
        Local customClass = null;
        if (!(extensions || Modifier.isFinal(sootClass.getModifiers()) || method.isStatic())) {
            customClass = j.newLocal("$customClass", BooleanType.v());
            body.getLocals().add(customClass);
            units.add(j.newAssignStmt(customClass, j.newInstanceFieldRef(thiz, this.org_robovm_objc_ObjCObject_customClass)));
        }
        Local ret = null;
        if (method.getReturnType() != VoidType.v()) {
            ret = j.newLocal("$ret", method.getReturnType());
            body.getLocals().add(ret);
        }
        StaticInvokeExpr invokeMsgSendExpr = j.newStaticInvokeExpr(msgSendMethod.makeRef(), ObjCMemberPlugin.l(thiz != null ? thiz : objCClass, args));
        Stmt stmt = invokeMsgSendStmt = ret == null ? j.newInvokeStmt(invokeMsgSendExpr) : j.newAssignStmt(ret, invokeMsgSendExpr);
        if (customClass != null) {
            units.add(j.newIfStmt((Value)j.newEqExpr(customClass, IntConstant.v(0)), invokeMsgSendStmt));
            Local zuper = j.newLocal("$super", this.org_robovm_objc_ObjCSuper.getType());
            body.getLocals().add(zuper);
            units.add(j.newAssignStmt(zuper, j.newVirtualInvokeExpr(body.getThisLocal(), this.org_robovm_objc_ObjCObject_getSuper)));
            StaticInvokeExpr invokeMsgSendSuperExpr = j.newStaticInvokeExpr(msgSendSuperMethod.makeRef(), ObjCMemberPlugin.l(zuper, args));
            units.add(ret == null ? j.newInvokeStmt(invokeMsgSendSuperExpr) : j.newAssignStmt(ret, invokeMsgSendSuperExpr));
            if (ret != null) {
                units.add(j.newReturnStmt(ret));
            } else {
                units.add(j.newReturnVoidStmt());
            }
        }
        units.add(invokeMsgSendStmt);
        if (ret != null) {
            units.add(j.newReturnStmt(ret));
        } else {
            units.add(j.newReturnVoidStmt());
        }
    }

    static void addBridgeAnnotation(SootMethod method) {
        Annotations.addRuntimeVisibleAnnotation((Host)method, "Lorg/robovm/rt/bro/annotation/Bridge;");
    }

    static void addCallbackAnnotation(SootMethod method) {
        Annotations.addRuntimeVisibleAnnotation((Host)method, "Lorg/robovm/rt/bro/annotation/Callback;");
    }

    static void addBindSelectorAnnotation(SootMethod method, String selectorName) {
        AnnotationTag annotationTag = new AnnotationTag(BIND_SELECTOR, 1);
        annotationTag.addElem(new AnnotationStringElem(selectorName, 's', "value"));
        Annotations.addRuntimeVisibleAnnotation((Host)method, annotationTag);
    }

    static void addNotImplementedAnnotation(SootMethod method, String selectorName) {
        AnnotationTag annotationTag = new AnnotationTag(NOT_IMPLEMENTED, 1);
        annotationTag.addElem(new AnnotationStringElem(selectorName, 's', "value"));
        Annotations.addRuntimeVisibleAnnotation((Host)method, annotationTag);
    }
}

