/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.robovm.compiler.clazz.Path;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.config.Resource;
import org.robovm.compiler.target.LaunchParameters;
import org.robovm.compiler.target.Launcher;
import org.robovm.compiler.target.Target;
import org.robovm.compiler.util.ToolchainUtil;
import org.simpleframework.xml.Transient;

public abstract class AbstractTarget
implements Target {
    @Transient
    protected Config config;

    protected AbstractTarget() {
    }

    @Override
    public void init(Config config) {
        this.config = config;
    }

    @Override
    public LaunchParameters createLaunchParameters() {
        return new LaunchParameters();
    }

    @Override
    public String getInstallRelativeArchivePath(Path path) {
        String name = this.config.getArchiveName(path);
        if (path.isInBootClasspath()) {
            return "lib" + File.separator + "boot" + File.separator + name;
        }
        return "lib" + File.separator + name;
    }

    @Override
    public boolean canLaunchInPlace() {
        return true;
    }

    @Override
    public void build(List<File> objectFiles) throws IOException {
        File outFile = new File(this.config.getTmpDir(), this.config.getExecutableName());
        this.config.getLogger().debug("Building executable %s", outFile);
        LinkedList<String> ccArgs = new LinkedList<String>();
        LinkedList<String> libs = new LinkedList<String>();
        String libSuffix = this.config.isUseDebugLibs() ? "-dbg" : "";
        libs.add("-lrobovm-bc" + libSuffix);
        if (this.config.getOs().getFamily() == OS.Family.darwin) {
            libs.add("-force_load");
            libs.add(new File(this.config.getOsArchDepLibDir(), "librobovm-rt" + libSuffix + ".a").getAbsolutePath());
        } else {
            libs.addAll(Arrays.asList("-Wl,--whole-archive", "-lrobovm-rt" + libSuffix, "-Wl,--no-whole-archive"));
        }
        if (this.config.isSkipInstall()) {
            libs.add("-lrobovm-debug" + libSuffix);
        }
        libs.addAll(Arrays.asList("-lrobovm-core" + libSuffix, "-lgc" + libSuffix, "-lpthread", "-ldl", "-lm"));
        if (this.config.getOs().getFamily() == OS.Family.linux) {
            libs.add("-lrt");
        }
        if (this.config.getOs().getFamily() == OS.Family.darwin) {
            libs.add("-liconv");
            libs.add("-lsqlite3");
            libs.add("-framework");
            libs.add("Foundation");
        }
        ccArgs.add("-L");
        ccArgs.add(this.config.getOsArchDepLibDir().getAbsolutePath());
        if (this.config.getOs().getFamily() == OS.Family.linux) {
            ccArgs.add("-Wl,-rpath=$ORIGIN");
            ccArgs.add("-Wl,--gc-sections");
        } else if (this.config.getOs().getFamily() == OS.Family.darwin) {
            ccArgs.add("-ObjC");
            File exportedSymbolsFile = new File(this.config.getTmpDir(), "exported_symbols");
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.config.isSkipInstall()) {
                arrayList.add("catch_exception_raise");
            }
            arrayList.addAll(this.config.getExportedSymbols());
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.set(i, "_" + (String)arrayList.get(i));
            }
            FileUtils.writeLines(exportedSymbolsFile, "ASCII", arrayList);
            ccArgs.add("-exported_symbols_list");
            ccArgs.add(exportedSymbolsFile.getAbsolutePath());
            ccArgs.add("-Wl,-no_implicit_dylibs");
            ccArgs.add("-Wl,-dead_strip");
        }
        if (this.config.getOs().getFamily() == OS.Family.darwin && !this.config.getFrameworks().isEmpty()) {
            for (String string : this.config.getFrameworks()) {
                libs.add("-framework");
                libs.add(string);
            }
        }
        if (this.config.getOs().getFamily() == OS.Family.darwin && !this.config.getWeakFrameworks().isEmpty()) {
            for (String string : this.config.getWeakFrameworks()) {
                libs.add("-weak_framework");
                libs.add(string);
            }
        }
        if (this.config.getOs().getFamily() == OS.Family.darwin && !this.config.getFrameworkPaths().isEmpty()) {
            for (File file : this.config.getFrameworkPaths()) {
                ccArgs.add("-F" + file.getAbsolutePath());
            }
        }
        if (!this.config.getLibs().isEmpty()) {
            objectFiles = new ArrayList<File>(objectFiles);
            for (Config.Lib lib : this.config.getLibs()) {
                String p = lib.getValue();
                if (p.endsWith(".o")) {
                    objectFiles.add(new File(p));
                    continue;
                }
                if (p.endsWith(".a")) {
                    if (this.config.getOs().getFamily() == OS.Family.darwin) {
                        if (lib.isForce()) {
                            libs.add("-force_load");
                        }
                        libs.add(new File(p).getAbsolutePath());
                        continue;
                    }
                    if (lib.isForce()) {
                        libs.add("-Wl,--whole-archive");
                    }
                    libs.add(new File(p).getAbsolutePath());
                    if (!lib.isForce()) continue;
                    libs.add("-Wl,--no-whole-archive");
                    continue;
                }
                libs.add("-l" + p);
            }
        }
        this.doBuild(outFile, ccArgs, objectFiles, libs);
    }

    protected void doBuild(File outFile, List<String> ccArgs, List<File> objectFiles, List<String> libs) throws IOException {
        ToolchainUtil.link(this.config, ccArgs, objectFiles, libs, outFile);
    }

    protected void copyResources(File destDir) throws IOException {
        for (Resource res : this.config.getResources()) {
            res.walk(new Resource.Walker(){

                @Override
                public void process(Resource resource, File file, File destDir) throws IOException {
                    AbstractTarget.this.copyFile(resource, file, destDir);
                }
            }, destDir);
        }
    }

    protected void copyFile(Resource resource, File file, File destDir) throws IOException {
        this.config.getLogger().debug("Copying resource %s to %s", file, destDir);
        FileUtils.copyFileToDirectory(file, destDir, true);
    }

    @Override
    public void install() throws IOException {
        this.config.getLogger().debug("Installing executable to %s", this.config.getInstallDir());
        this.config.getInstallDir().mkdirs();
        this.doInstall(this.config.getInstallDir(), this.config.getExecutableName());
    }

    protected void doInstall(File installDir, String executable) throws IOException {
        if (!this.config.getTmpDir().equals(installDir) || !executable.equals(this.config.getExecutableName())) {
            File destFile = new File(installDir, executable);
            FileUtils.copyFile(new File(this.config.getTmpDir(), this.config.getExecutableName()), destFile);
            destFile.setExecutable(true, false);
        }
        for (File f : this.config.getOsArchDepLibDir().listFiles()) {
            if (!f.getName().matches(".*\\.(so|dylib)(\\.1)?")) continue;
            FileUtils.copyFileToDirectory(f, installDir);
        }
        this.stripArchives(installDir);
        this.copyResources(installDir);
    }

    @Override
    public Process launch(LaunchParameters launchParameters) throws IOException {
        if (this.config.isSkipLinking()) {
            throw new IllegalStateException("Cannot skip linking if target should be run");
        }
        boolean add = true;
        for (String arg : launchParameters.getArguments()) {
            if (!arg.startsWith("-rvm:log=")) continue;
            add = false;
            break;
        }
        if (add) {
            ArrayList<String> args = new ArrayList<String>(launchParameters.getArguments());
            args.add(0, "-rvm:log=warn");
            launchParameters.setArguments(args);
        }
        return this.doLaunch(launchParameters);
    }

    protected Process doLaunch(LaunchParameters launchParameters) throws IOException {
        return this.createLauncher(launchParameters).execAsync();
    }

    protected abstract Launcher createLauncher(LaunchParameters var1) throws IOException;

    protected Target build(Config config) {
        return this;
    }

    protected void stripArchives(File installDir) throws IOException {
        ArrayList<Path> allPaths = new ArrayList<Path>();
        allPaths.addAll(this.config.getClazzes().getPaths());
        allPaths.addAll(this.config.getResourcesPaths());
        for (Path path : allPaths) {
            File destJar = new File(installDir, this.getInstallRelativeArchivePath(path));
            if (!destJar.getParentFile().exists()) {
                destJar.getParentFile().mkdirs();
            }
            this.stripArchive(path, destJar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stripArchive(Path path, File output) throws IOException {
        if (!this.config.isClean() && output.exists() && !path.hasChangedSince(output.lastModified())) {
            this.config.getLogger().debug("Not creating stripped archive file %s for unchanged path %s", output, path.getFile());
            return;
        }
        this.config.getLogger().debug("Creating stripped archive file %s", output);
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(output)));
            if (path.getFile().isFile()) {
                ZipFile archive = null;
                try {
                    archive = new ZipFile(path.getFile());
                    Enumeration<? extends ZipEntry> entries = archive.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (entry.getName().toLowerCase().endsWith(".class") || entry.getName().startsWith("META-INF/robovm/")) continue;
                        ZipEntry newEntry = new ZipEntry(entry.getName());
                        newEntry.setTime(entry.getTime());
                        out.putNextEntry(newEntry);
                        InputStream in = null;
                        try {
                            in = archive.getInputStream(entry);
                            IOUtils.copy(in, (OutputStream)out);
                            out.closeEntry();
                        }
                        finally {
                            IOUtils.closeQuietly(in);
                        }
                    }
                }
                finally {
                    try {
                        archive.close();
                    }
                    catch (Throwable t) {}
                }
            }
            String basePath = path.getFile().getAbsolutePath();
            Collection files = FileUtils.listFiles(path.getFile(), null, true);
            for (File f : files) {
                String entryName;
                if (f.getName().toLowerCase().endsWith(".class") || (entryName = f.getAbsolutePath().substring(basePath.length() + 1)).startsWith("META-INF/robovm/")) continue;
                ZipEntry newEntry = new ZipEntry(entryName);
                newEntry.setTime(f.lastModified());
                out.putNextEntry(newEntry);
                FileInputStream in = null;
                try {
                    in = new FileInputStream(f);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    out.closeEntry();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly(in);
            }
            IOUtils.closeQuietly(out);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(out);
            output.delete();
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }
}

