/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.target.AbstractTarget;
import org.robovm.compiler.target.LaunchParameters;
import org.robovm.compiler.target.Launcher;
import org.robovm.compiler.util.Executor;
import org.robovm.compiler.util.io.OpenOnWriteFileOutputStream;

public class ConsoleTarget
extends AbstractTarget {
    private OS os;
    private Arch arch;

    @Override
    public OS getOs() {
        return this.os;
    }

    @Override
    public Arch getArch() {
        return this.arch;
    }

    @Override
    protected Launcher createLauncher(LaunchParameters launchParameters) throws IOException {
        File dir = this.config.isSkipInstall() ? this.config.getTmpDir() : this.config.getInstallDir();
        OutputStream out = System.out;
        OutputStream err = System.err;
        if (launchParameters.getStdoutFifo() != null) {
            out = new OpenOnWriteFileOutputStream(launchParameters.getStdoutFifo());
        }
        if (launchParameters.getStderrFifo() != null) {
            err = new OpenOnWriteFileOutputStream(launchParameters.getStderrFifo());
        }
        return this.createExecutor(launchParameters, new File(dir, this.config.getExecutableName()).getAbsolutePath(), launchParameters.getArguments()).out(out).err(err).closeOutputStreams(true);
    }

    protected Executor createExecutor(LaunchParameters launchParameters, String cmd, List<? extends Object> args) throws IOException {
        Map<String, String> env = launchParameters.getEnvironment();
        return new Executor(this.config.getLogger(), cmd).args(new Object[]{args}).wd(launchParameters.getWorkingDirectory()).inheritEnv(env == null).env(env == null ? Collections.emptyMap() : env);
    }

    @Override
    public void init(Config config) {
        super.init(config);
        this.os = config.getOs();
        if (this.os == null) {
            this.os = OS.getDefaultOS();
        }
        this.arch = config.getArch();
        if (this.arch == null) {
            this.arch = Arch.getDefaultArch();
        }
    }

    @Override
    protected void doBuild(File outFile, List<String> ccArgs, List<File> objectFiles, List<String> libArgs) throws IOException {
        if (this.config.getOs() == OS.macosx) {
            ccArgs.add("-mmacosx-version-min=10.6");
        }
        super.doBuild(outFile, ccArgs, objectFiles, libArgs);
    }
}

