/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target.ios;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.target.ios.SDK;
import org.robovm.compiler.util.Executor;

public class DeviceType {
    public static final String PREFIX = "com.apple.CoreSimulator.SimDeviceType.";
    private final String deviceName;
    private final SDK sdk;

    public DeviceType(String deviceName, SDK sdk) {
        this.deviceName = deviceName;
        this.sdk = sdk;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public SDK getSdk() {
        return this.sdk;
    }

    public String getDeviceTypeId() {
        return this.deviceName + ", " + this.sdk.getVersion();
    }

    public String getSimpleDeviceTypeId() {
        return this.getSimpleDeviceName() + ", " + this.sdk.getVersion();
    }

    public String getSimpleDeviceName() {
        return this.deviceName.substring(PREFIX.length());
    }

    public DeviceFamily getFamily() {
        if (this.deviceName.contains("iPhone")) {
            return DeviceFamily.iPhone;
        }
        return DeviceFamily.iPad;
    }

    public static List<DeviceType> listDeviceTypes(Config.Home home) {
        try {
            String capture = new Executor(Logger.NULL_LOGGER, new File(home.getBinDir(), "ios-sim")).args("showdevicetypes").execCapture();
            ArrayList<DeviceType> types = new ArrayList<DeviceType>();
            String[] deviceTypeIds = capture.split("\n");
            List<SDK> sdks = SDK.listSimulatorSDKs();
            HashMap<String, SDK> sdkMap = new HashMap<String, SDK>();
            for (SDK sdk : sdks) {
                sdkMap.put(sdk.getVersion(), sdk);
            }
            for (String deviceTypeId : deviceTypeIds) {
                String[] tokens = deviceTypeId.split(",");
                tokens[0] = tokens[0].trim();
                tokens[1] = tokens[1].trim();
                SDK sdk = (SDK)sdkMap.get(tokens[1]);
                if (sdk == null) continue;
                types.add(new DeviceType(tokens[0], sdk));
            }
            return types;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static List<String> getSimpleDeviceTypeIds(Config.Home home) {
        ArrayList<String> result = new ArrayList<String>();
        for (DeviceType type : DeviceType.listDeviceTypes(home)) {
            result.add(type.getSimpleDeviceTypeId());
        }
        return result;
    }

    public static DeviceType getDeviceType(Config.Home home, String deviceTypeId) {
        List<DeviceType> types = DeviceType.listDeviceTypes(home);
        if (deviceTypeId == null) {
            return null;
        }
        if (!deviceTypeId.startsWith(PREFIX)) {
            deviceTypeId = PREFIX + deviceTypeId;
        }
        for (DeviceType type : types) {
            if (!deviceTypeId.equals(type.getDeviceTypeId())) continue;
            return type;
        }
        return null;
    }

    public static DeviceType getBestDeviceType(Config.Home home) {
        DeviceType best = null;
        for (DeviceType type : DeviceType.listDeviceTypes(home)) {
            int typeVersion;
            if (type.getFamily() != DeviceFamily.iPhone) continue;
            if (best == null) {
                best = type;
                continue;
            }
            int bestVersion = best.getSdk().getMajor() << 8 | best.getSdk().getMinor();
            if (bestVersion >= (typeVersion = type.getSdk().getMajor() << 8 | type.getSdk().getMinor())) continue;
            best = type;
        }
        return best;
    }

    public static DeviceType getBestDeviceType(Config.Home home, DeviceFamily family) {
        DeviceType best = null;
        for (DeviceType type : DeviceType.listDeviceTypes(home)) {
            int typeVersion;
            if (type.getFamily() != family) continue;
            if (best == null) {
                best = type;
                continue;
            }
            int bestVersion = best.getSdk().getMajor() << 8 | best.getSdk().getMinor();
            if (bestVersion >= (typeVersion = type.getSdk().getMajor() << 8 | type.getSdk().getMinor())) continue;
            best = type;
        }
        return best;
    }

    public static enum DeviceFamily {
        iPad,
        iPhone;

    }
}

