/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target.ios;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import com.dd.plist.XMLPropertyListParser;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.config.Resource;
import org.robovm.compiler.target.AbstractTarget;
import org.robovm.compiler.target.LaunchParameters;
import org.robovm.compiler.target.Launcher;
import org.robovm.compiler.target.ios.AppLauncherProcess;
import org.robovm.compiler.target.ios.DeviceType;
import org.robovm.compiler.target.ios.IOSDeviceLaunchParameters;
import org.robovm.compiler.target.ios.IOSSimulatorLaunchParameters;
import org.robovm.compiler.target.ios.ProvisioningProfile;
import org.robovm.compiler.target.ios.SDK;
import org.robovm.compiler.target.ios.SigningIdentity;
import org.robovm.compiler.util.Executor;
import org.robovm.compiler.util.ToolchainUtil;
import org.robovm.compiler.util.io.OpenOnWriteFileOutputStream;
import org.robovm.libimobiledevice.AfcClient;
import org.robovm.libimobiledevice.IDevice;
import org.robovm.libimobiledevice.InstallationProxyClient;
import org.robovm.libimobiledevice.util.AppLauncher;
import org.robovm.libimobiledevice.util.AppPathCallback;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class IOSTarget
extends AbstractTarget {
    private Arch arch;
    private SDK sdk;
    private File infoPList = null;
    private NSDictionary infoPListDict = null;
    private File resourceRulesPList;
    private File entitlementsPList;
    private SigningIdentity signIdentity;
    private ProvisioningProfile provisioningProfile;
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([^}]+)\\}");

    @Override
    public Arch getArch() {
        return this.arch;
    }

    @Override
    public LaunchParameters createLaunchParameters() {
        if (this.arch == Arch.x86) {
            return new IOSSimulatorLaunchParameters();
        }
        return new IOSDeviceLaunchParameters();
    }

    public List<SDK> getSDKs() {
        if (this.arch == Arch.x86) {
            return SDK.listSimulatorSDKs();
        }
        return SDK.listDeviceSDKs();
    }

    @Override
    protected Launcher createLauncher(LaunchParameters launchParameters) throws IOException {
        if (this.arch == Arch.x86) {
            return this.createIOSSimLauncher(launchParameters);
        }
        return this.createIOSDevLauncher(launchParameters);
    }

    private Launcher createIOSSimLauncher(LaunchParameters launchParameters) throws IOException {
        File dir = this.getAppDir();
        String iosSimPath = new File(this.config.getHome().getBinDir(), "ios-sim").getAbsolutePath();
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("launch");
        args.add(dir);
        args.add("--timeout");
        args.add("90");
        args.add("--unbuffered");
        if (((IOSSimulatorLaunchParameters)launchParameters).getDeviceType() != null) {
            DeviceType deviceType = ((IOSSimulatorLaunchParameters)launchParameters).getDeviceType();
            args.add("--devicetypeid");
            args.add(deviceType.getDeviceTypeId());
        }
        if (launchParameters.getStdoutFifo() != null) {
            args.add("--stdout");
            args.add(launchParameters.getStdoutFifo());
        }
        if (launchParameters.getStderrFifo() != null) {
            args.add("--stderr");
            args.add(launchParameters.getStderrFifo());
        }
        if (launchParameters.getEnvironment() != null) {
            for (Map.Entry<String, String> entry : launchParameters.getEnvironment().entrySet()) {
                args.add("--setenv");
                args.add(entry.getKey() + "=" + entry.getValue());
            }
        }
        if (!launchParameters.getArguments().isEmpty()) {
            args.add("--args");
            args.addAll(launchParameters.getArguments());
        }
        File xcodePath = new File(ToolchainUtil.findXcodePath());
        Map<String, String> env = Collections.singletonMap("DEVELOPER_DIR", xcodePath.getAbsolutePath());
        return new Executor(this.config.getLogger(), iosSimPath).args(args).wd(launchParameters.getWorkingDirectory()).inheritEnv(false).env(env);
    }

    private Launcher createIOSDevLauncher(LaunchParameters launchParameters) throws IOException {
        IOSDeviceLaunchParameters deviceLaunchParameters = (IOSDeviceLaunchParameters)launchParameters;
        String deviceId = deviceLaunchParameters.getDeviceId();
        int forwardPort = deviceLaunchParameters.getForwardPort();
        AppPathCallback callback = deviceLaunchParameters.getAppPathCallback();
        if (deviceId == null) {
            String[] udids = IDevice.listUdids();
            if (udids.length == 0) {
                throw new RuntimeException("No devices connected");
            }
            if (udids.length > 1) {
                this.config.getLogger().warn("More than 1 device connected (%s). Using %s.", Arrays.asList(udids), udids[0]);
            }
            deviceId = udids[0];
        }
        IDevice device = new IDevice(deviceId);
        OutputStream out = null;
        out = launchParameters.getStdoutFifo() != null ? new OpenOnWriteFileOutputStream(launchParameters.getStdoutFifo()) : System.out;
        Map<String, String> env = launchParameters.getEnvironment();
        if (env == null) {
            env = Collections.emptyMap();
        }
        AppLauncher launcher = new AppLauncher(device, this.getAppDir()){

            @Override
            protected void log(String s, Object ... args) {
                IOSTarget.this.config.getLogger().debug(s, args);
            }
        }.stdout(out).closeOutOnExit(true).args(launchParameters.getArguments().toArray(new String[0])).env(env).forward(forwardPort).appPathCallback(callback).xcodePath(ToolchainUtil.findXcodePath()).uploadProgressCallback(new AfcClient.UploadProgressCallback(){
            boolean first = true;

            @Override
            public void success() {
                IOSTarget.this.config.getLogger().debug("[100%%] Upload complete", new Object[0]);
            }

            @Override
            public void progress(File path, int percentComplete) {
                if (this.first) {
                    IOSTarget.this.config.getLogger().debug("[  0%%] Beginning upload...", new Object[0]);
                }
                this.first = false;
                IOSTarget.this.config.getLogger().debug("[%3d%%] Uploading %s...", percentComplete, path);
            }

            @Override
            public void error(String message) {
            }
        }).installStatusCallback(new InstallationProxyClient.StatusCallback(){
            boolean first = true;

            @Override
            public void success() {
                IOSTarget.this.config.getLogger().debug("[100%%] Install complete", new Object[0]);
            }

            @Override
            public void progress(String status, int percentComplete) {
                if (this.first) {
                    IOSTarget.this.config.getLogger().debug("[  0%%] Beginning installation...", new Object[0]);
                }
                this.first = false;
                IOSTarget.this.config.getLogger().debug("[%3d%%] %s", percentComplete, status);
            }

            @Override
            public void error(String message) {
            }
        });
        return new AppLauncherProcess(this.config.getLogger(), launcher, launchParameters);
    }

    @Override
    protected void doBuild(File outFile, List<String> ccArgs, List<File> objectFiles, List<String> libArgs) throws IOException {
        if (!this.config.getFrameworks().contains("UIKit")) {
            libArgs.add("-framework");
            libArgs.add("UIKit");
        }
        if (this.arch == Arch.thumbv7) {
            ccArgs.add("-miphoneos-version-min=5.0");
        } else {
            ccArgs.add("-mios-simulator-version-min=5.0");
        }
        ccArgs.add("-isysroot");
        ccArgs.add(this.sdk.getRoot().getAbsolutePath());
        super.doBuild(outFile, ccArgs, objectFiles, libArgs);
    }

    protected void prepareInstall(File installDir) throws IOException {
        this.createInfoPList(installDir);
        this.generateDsym(installDir, this.getExecutable());
        if (this.arch == Arch.thumbv7) {
            this.strip(installDir, this.getExecutable());
            this.copyResourcesPList(installDir);
            if (this.config.isIosSkipSigning()) {
                this.config.getLogger().warn("Skiping code signing. The resulting app will be unsigned and will not run on unjailbroken devices", new Object[0]);
                this.ldid(this.entitlementsPList, installDir);
            } else {
                this.copyProvisioningProfile(this.provisioningProfile, installDir);
                boolean getTaskAllow = this.provisioningProfile.getType() == ProvisioningProfile.Type.Development;
                this.codesign(this.signIdentity, this.getOrCreateEntitlementsPList(getTaskAllow), installDir);
                new Executor(this.config.getLogger(), "ln").args("-f", "-s", "_CodeSignature/CodeResources", new File(installDir, "CodeResources")).exec();
            }
        }
    }

    private void copyProvisioningProfile(ProvisioningProfile profile, File destDir) throws IOException {
        this.config.getLogger().debug("Copying %s provisioning profile: %s (%s)", new Object[]{profile.getType(), profile.getName(), profile.getEntitlements().objectForKey("application-identifier")});
        FileUtils.copyFile(profile.getFile(), new File(destDir, "embedded.mobileprovision"));
    }

    protected void prepareLaunch(File appDir) throws IOException {
        super.doInstall(appDir, this.getExecutable());
        this.createInfoPList(appDir);
        this.generateDsym(appDir, this.getExecutable());
        if (this.arch == Arch.thumbv7) {
            this.copyResourcesPList(appDir);
            if (this.config.isIosSkipSigning()) {
                this.config.getLogger().warn("Skiping code signing. The resulting app will be unsigned and will not run on unjailbroken devices", new Object[0]);
                this.ldid(this.getOrCreateEntitlementsPList(true), appDir);
            } else {
                this.copyProvisioningProfile(this.provisioningProfile, appDir);
                this.codesign(this.signIdentity, this.getOrCreateEntitlementsPList(true), appDir);
            }
        }
    }

    private void codesign(SigningIdentity identity, File entitlementsPList, File appDir) throws IOException {
        this.config.getLogger().debug("Code signing using identity '%s' with fingerprint %s", identity.getName(), identity.getFingerprint());
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("-f");
        args.add("-s");
        args.add(identity.getFingerprint());
        if (entitlementsPList != null) {
            args.add("--entitlements");
            args.add(entitlementsPList);
        }
        args.add(appDir);
        new Executor(this.config.getLogger(), "codesign").addEnv("CODESIGN_ALLOCATE", ToolchainUtil.findXcodeCommand("codesign_allocate", "iphoneos")).args(args).exec();
    }

    private void ldid(File entitlementsPList, File appDir) throws IOException {
        File executableFile = new File(appDir, this.getExecutable());
        this.config.getLogger().debug("Pseudo-signing %s", executableFile.getAbsolutePath());
        ArrayList<Object> args = new ArrayList<Object>();
        if (entitlementsPList != null) {
            args.add("-S" + entitlementsPList.getAbsolutePath());
        } else {
            args.add("-S");
        }
        args.add(executableFile);
        new Executor(this.config.getLogger(), new File(this.config.getHome().getBinDir(), "ldid")).args(args).exec();
    }

    private void copyResourcesPList(File destDir) throws IOException {
        File destFile = new File(destDir, "ResourceRules.plist");
        if (this.resourceRulesPList != null) {
            FileUtils.copyFile(this.resourceRulesPList, destFile);
        } else {
            FileUtils.copyURLToFile(this.getClass().getResource("/ResourceRules.plist"), destFile);
        }
    }

    private File getOrCreateEntitlementsPList(boolean getTaskAllow) throws IOException {
        try {
            File destFile = new File(this.config.getTmpDir(), "Entitlements.plist");
            NSDictionary dict = null;
            dict = this.entitlementsPList != null ? (NSDictionary)PropertyListParser.parse(this.entitlementsPList) : (NSDictionary)PropertyListParser.parse(IOUtils.toByteArray(this.getClass().getResourceAsStream("/Entitlements.plist")));
            if (this.provisioningProfile != null) {
                NSDictionary profileEntitlements = this.provisioningProfile.getEntitlements();
                for (String key : profileEntitlements.allKeys()) {
                    if (dict.objectForKey(key) != null) continue;
                    dict.put(key, profileEntitlements.objectForKey(key));
                }
                dict.put("application-identifier", this.provisioningProfile.getAppIdPrefix() + "." + this.getBundleId());
            }
            dict.put("get-task-allow", getTaskAllow);
            PropertyListParser.saveAsXML(dict, destFile);
            return destFile;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void generateDsym(File dir, String executable) throws IOException {
        File dsymDir = new File(dir.getParentFile(), dir.getName() + ".dSYM");
        FileUtils.deleteDirectory(dsymDir);
        new Executor(this.config.getLogger(), "xcrun").args("dsymutil", "-o", dsymDir, new File(dir, executable)).exec();
    }

    private void strip(File dir, String executable) throws IOException {
        File exportedSymbolsFile = new File(this.config.getTmpDir(), "exported_symbols");
        new Executor(this.config.getLogger(), "xcrun").args("strip", "-s", exportedSymbolsFile, new File(dir, executable)).exec();
    }

    @Override
    protected void doInstall(File installDir, String executable) throws IOException {
        super.doInstall(installDir, this.getExecutable());
        this.prepareInstall(installDir);
    }

    @Override
    protected Process doLaunch(LaunchParameters launchParameters) throws IOException {
        this.prepareLaunch(this.getAppDir());
        return super.doLaunch(launchParameters);
    }

    public void createIpa() throws IOException {
        this.config.getLogger().debug("Creating IPA in %s", this.config.getInstallDir());
        this.config.getInstallDir().mkdirs();
        File tmpDir = new File(this.config.getInstallDir(), this.getExecutable() + ".app");
        FileUtils.deleteDirectory(tmpDir);
        tmpDir.mkdirs();
        super.doInstall(tmpDir, this.getExecutable());
        this.prepareInstall(tmpDir);
        ToolchainUtil.packageApplication(this.config, tmpDir, new File(this.config.getInstallDir(), this.getExecutable() + ".ipa"));
    }

    @Override
    protected void copyFile(Resource resource, File file, File destDir) throws IOException {
        if (this.arch == Arch.thumbv7 && !resource.isSkipPngCrush() && file.getName().toLowerCase().endsWith(".png")) {
            destDir.mkdirs();
            File outFile = new File(destDir, file.getName());
            ToolchainUtil.pngcrush(this.config, file, outFile);
        } else if (file.getName().toLowerCase().endsWith(".strings")) {
            destDir.mkdirs();
            File outFile = new File(destDir, file.getName());
            ToolchainUtil.compileStrings(this.config, file, outFile);
        } else {
            super.copyFile(resource, file, destDir);
        }
    }

    protected File getAppDir() {
        File dir = null;
        if (!this.config.isSkipInstall()) {
            dir = this.config.getInstallDir();
        } else {
            dir = new File(this.config.getTmpDir(), this.getExecutable() + ".app");
            dir.mkdirs();
        }
        return dir;
    }

    protected String getExecutable() {
        NSObject bundleExecutable;
        if (this.infoPListDict != null && (bundleExecutable = this.infoPListDict.objectForKey("CFBundleExecutable")) != null) {
            return bundleExecutable.toString();
        }
        return this.config.getExecutableName();
    }

    protected String getBundleId() {
        NSObject bundleIdentifier;
        if (this.infoPListDict != null && (bundleIdentifier = this.infoPListDict.objectForKey("CFBundleIdentifier")) != null) {
            return bundleIdentifier.toString();
        }
        return this.config.getMainClass() != null ? this.config.getMainClass() : this.config.getExecutableName();
    }

    private void putIfAbsent(NSDictionary dict, String key, String value) {
        if (dict.objectForKey(key) == null) {
            dict.put(key, value);
        }
    }

    protected void customizeInfoPList(NSDictionary dict) {
        if (this.arch == Arch.x86) {
            dict.put("CFBundleSupportedPlatforms", new NSArray(new NSString("iPhoneSimulator")));
        } else {
            dict.put("CFBundleResourceSpecification", "ResourceRules.plist");
            dict.put("CFBundleSupportedPlatforms", new NSArray(new NSString("iPhoneOS")));
            dict.put("DTPlatformVersion", this.sdk.getPlatformVersion());
            dict.put("DTPlatformBuild", this.sdk.getPlatformBuild());
            dict.put("DTSDKBuild", this.sdk.getBuild());
            this.putIfAbsent(dict, "DTXcode", "0502");
            this.putIfAbsent(dict, "DTXcodeBuild", "5A3005");
        }
    }

    protected void createInfoPList(File dir) throws IOException {
        NSDictionary dict = new NSDictionary();
        if (this.infoPListDict != null) {
            for (String key : this.infoPListDict.allKeys()) {
                dict.put(key, this.infoPListDict.objectForKey(key));
            }
        } else {
            dict.put("CFBundleVersion", "1.0");
            dict.put("CFBundleExecutable", this.config.getExecutableName());
            dict.put("CFBundleName", this.config.getExecutableName());
            dict.put("CFBundleIdentifier", this.getBundleId());
            dict.put("CFBundlePackageType", "APPL");
            dict.put("LSRequiresIPhoneOS", true);
            NSObject supportedDeviceFamilies = this.sdk.getDefaultProperty("SUPPORTED_DEVICE_FAMILIES");
            if (supportedDeviceFamilies != null) {
                NSArray families = null;
                if (supportedDeviceFamilies instanceof NSString) {
                    NSString defFamilies = (NSString)supportedDeviceFamilies;
                    String[] parts = defFamilies.toString().split(",");
                    families = new NSArray(parts.length);
                    for (int i = 0; i < families.count(); ++i) {
                        families.setValue(i, new NSNumber(parts[i].trim()));
                    }
                } else {
                    NSArray defFamilies = (NSArray)supportedDeviceFamilies;
                    families = new NSArray(defFamilies.count());
                    for (int i = 0; i < families.count(); ++i) {
                        families.setValue(i, new NSNumber(defFamilies.objectAtIndex(i).toString()));
                    }
                }
                dict.put("UIDeviceFamily", families);
            }
            dict.put("UISupportedInterfaceOrientations", new NSArray(new NSString("UIInterfaceOrientationPortrait"), new NSString("UIInterfaceOrientationLandscapeLeft"), new NSString("UIInterfaceOrientationLandscapeRight"), new NSString("UIInterfaceOrientationPortraitUpsideDown")));
            dict.put("UISupportedInterfaceOrientations~ipad", new NSArray(new NSString("UIInterfaceOrientationPortrait"), new NSString("UIInterfaceOrientationLandscapeLeft"), new NSString("UIInterfaceOrientationLandscapeRight"), new NSString("UIInterfaceOrientationPortraitUpsideDown")));
            dict.put("UIRequiredDeviceCapabilities", new NSArray(new NSString("armv7")));
        }
        dict.put("DTPlatformName", this.sdk.getPlatformName());
        dict.put("DTSDKName", this.sdk.getCanonicalName());
        if (dict.objectForKey("MinimumOSVersion") == null) {
            dict.put("MinimumOSVersion", "5.0");
        }
        this.customizeInfoPList(dict);
        File tmpInfoPlist = new File(this.config.getTmpDir(), "Info.plist");
        PropertyListParser.saveAsBinary(dict, tmpInfoPlist);
        this.config.getLogger().debug("Installing Info.plist to %s", dir);
        FileUtils.copyFile(tmpInfoPlist, new File(dir, tmpInfoPlist.getName()));
    }

    @Override
    public void init(Config config) {
        super.init(config);
        if (config.getArch() == null) {
            this.arch = Arch.thumbv7;
        } else {
            if (config.getArch() != Arch.x86 && config.getArch() != Arch.thumbv7) {
                throw new IllegalArgumentException("Arch '" + (Object)((Object)config.getArch()) + "' is unsupported for iOS target");
            }
            this.arch = config.getArch();
        }
        if (this.arch == Arch.thumbv7 && !config.isIosSkipSigning()) {
            this.signIdentity = config.getIosSignIdentity();
            if (this.signIdentity == null) {
                this.signIdentity = SigningIdentity.find(SigningIdentity.list(), "iPhone Developer");
            }
        }
        this.infoPList = config.getIosInfoPList();
        if (this.infoPList != null) {
            try {
                this.infoPListDict = (NSDictionary)IOSTarget.parsePropertyList(this.infoPList, config.getProperties());
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Failed to parse Info.plist XML file: " + this.infoPList, t);
            }
        }
        if (this.arch == Arch.thumbv7 && !config.isIosSkipSigning()) {
            this.provisioningProfile = config.getIosProvisioningProfile();
            if (this.provisioningProfile == null) {
                NSString bundleId;
                NSString nSString = bundleId = this.infoPListDict != null ? (NSString)this.infoPListDict.objectForKey("CFBundleIdentifier") : null;
                if (bundleId == null) {
                    bundleId = new NSString("*");
                }
                this.provisioningProfile = ProvisioningProfile.find(ProvisioningProfile.list(), this.signIdentity, bundleId.toString());
            }
        }
        String sdkVersion = config.getIosSdkVersion();
        List<SDK> sdks = this.getSDKs();
        if (sdkVersion == null) {
            if (sdks.isEmpty()) {
                throw new IllegalArgumentException("No " + (this.arch == Arch.thumbv7 ? "device" : "simulator") + " SDKs installed");
            }
            Collections.sort(sdks);
            this.sdk = sdks.get(sdks.size() - 1);
        } else {
            for (SDK sdk : sdks) {
                if (!sdk.getVersion().equals(sdkVersion)) continue;
                this.sdk = sdk;
                break;
            }
            if (this.sdk == null) {
                throw new IllegalArgumentException("No SDK found matching version string " + sdkVersion);
            }
        }
        this.entitlementsPList = config.getIosEntitlementsPList();
    }

    @Override
    public OS getOs() {
        return OS.ios;
    }

    @Override
    public boolean canLaunchInPlace() {
        return false;
    }

    static void replacePropertyRefs(Node node, Properties props) {
        Text el;
        String value;
        if (node instanceof Text && (value = (el = (Text)node).getNodeValue()) != null && value.trim().length() > 0) {
            Matcher matcher = VARIABLE_PATTERN.matcher(value);
            StringBuilder sb = new StringBuilder();
            int pos = 0;
            while (matcher.find()) {
                if (pos < matcher.start()) {
                    sb.append(value.substring(pos, matcher.start()));
                }
                String key = matcher.group(1);
                sb.append(props.getProperty(key, matcher.group()));
                pos = matcher.end();
            }
            if (pos < value.length()) {
                sb.append(value.substring(pos));
            }
            el.setNodeValue(sb.toString());
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            IOSTarget.replacePropertyRefs(children.item(i), props);
        }
    }

    static NSObject parsePropertyList(File file, Properties props) throws Exception {
        Properties allProps = new Properties(System.getProperties());
        allProps.putAll((Map<?, ?>)props);
        Method getDocBuilder = XMLPropertyListParser.class.getDeclaredMethod("getDocBuilder", new Class[0]);
        getDocBuilder.setAccessible(true);
        Method parseDocument = XMLPropertyListParser.class.getDeclaredMethod("parseDocument", Document.class);
        parseDocument.setAccessible(true);
        DocumentBuilder docBuilder = (DocumentBuilder)getDocBuilder.invoke(null, new Object[0]);
        Document doc = docBuilder.parse(file);
        IOSTarget.replacePropertyRefs(doc, allProps);
        return (NSObject)parseDocument.invoke(null, doc);
    }
}

