/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target.ios;

import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cms.CMSSignedData;
import org.robovm.compiler.target.ios.SigningIdentity;

public class ProvisioningProfile
implements Comparable<ProvisioningProfile> {
    private static final String HEX_DIGITS = "0123456789ABCDEF";
    private final Type type;
    private final File file;
    private final NSDictionary dict;
    private final String uuid;
    private final String name;
    private final String appIdName;
    private final String appIdPrefix;
    private final String appId;
    private final Date creationDate;
    private final Date expirationDate;
    private final NSDictionary entitlements;
    private final List<String> certFingerprints = new ArrayList<String>();

    ProvisioningProfile(File file, NSDictionary dict) {
        this.file = file;
        this.dict = dict;
        this.uuid = dict.objectForKey("UUID").toString();
        this.name = dict.objectForKey("Name").toString();
        this.appIdName = dict.objectForKey("AppIDName") != null ? dict.objectForKey("AppIDName").toString() : null;
        this.appIdPrefix = ((NSArray)dict.objectForKey("ApplicationIdentifierPrefix")).objectAtIndex(0).toString();
        this.creationDate = ((NSDate)dict.objectForKey("CreationDate")).getDate();
        this.expirationDate = ((NSDate)dict.objectForKey("ExpirationDate")).getDate();
        this.entitlements = (NSDictionary)dict.objectForKey("Entitlements");
        this.appId = this.entitlements.objectForKey("application-identifier").toString();
        for (NSObject o : ((NSArray)dict.objectForKey("DeveloperCertificates")).getArray()) {
            NSData data = (NSData)o;
            this.certFingerprints.add(ProvisioningProfile.getCertFingerprint(data.bytes()));
        }
        boolean getTaskAllow = ((NSNumber)this.entitlements.objectForKey("get-task-allow")).boolValue();
        NSArray provisionedDevices = (NSArray)dict.objectForKey("ProvisionedDevices");
        this.type = getTaskAllow ? Type.Development : (provisionedDevices != null ? Type.AdHoc : Type.AppStore);
    }

    @Override
    public int compareTo(ProvisioningProfile o) {
        return this.name.compareToIgnoreCase(o.name);
    }

    private static String getCertFingerprint(byte[] certData) {
        try {
            CertificateFactory x509CertFact = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)x509CertFact.generateCertificate(new ByteArrayInputStream(certData));
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return ProvisioningProfile.toHexString(md.digest(cert.getEncoded()));
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String toHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(HEX_DIGITS.charAt((bytes[i] & 0xF0) >> 4));
            buf.append(HEX_DIGITS.charAt(bytes[i] & 0xF));
        }
        return buf.toString();
    }

    public Type getType() {
        return this.type;
    }

    public File getFile() {
        return this.file;
    }

    public NSDictionary getDict() {
        return this.dict;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getAppIdName() {
        return this.appIdName;
    }

    public String getAppIdPrefix() {
        return this.appIdPrefix;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public NSDictionary getEntitlements() {
        return this.entitlements;
    }

    private static ProvisioningProfile create(File file) {
        ProvisioningProfile provisioningProfile;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            CMSSignedData data = new CMSSignedData(in);
            byte[] content = (byte[])data.getSignedContent().getContent();
            NSDictionary dict = (NSDictionary)PropertyListParser.parse(content);
            provisioningProfile = new ProvisioningProfile(file, dict);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        return provisioningProfile;
    }

    public static List<ProvisioningProfile> list() {
        File dir = new File(new File(System.getProperty("user.home")), "Library/MobileDevice/Provisioning Profiles");
        if (!dir.exists() || !dir.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<ProvisioningProfile> result = new ArrayList<ProvisioningProfile>();
        for (File f : dir.listFiles()) {
            if (!f.getName().endsWith(".mobileprovision")) continue;
            ProvisioningProfile p = ProvisioningProfile.create(f);
            if (!p.expirationDate.after(new Date())) continue;
            result.add(p);
        }
        Collections.sort(result);
        return result;
    }

    public static ProvisioningProfile find(List<ProvisioningProfile> profiles, String search) {
        for (ProvisioningProfile p : profiles) {
            if (!p.uuid.equals(search) && !p.appIdPrefix.equals(search) && (p.appIdName == null || !p.appIdName.equals(search)) && !p.name.equals(search)) continue;
            return p;
        }
        throw new IllegalArgumentException("No provisioning profile found matching '" + search + "'");
    }

    public static ProvisioningProfile find(List<ProvisioningProfile> profiles, SigningIdentity signingIdentity, String bundleId) {
        return ProvisioningProfile.find(profiles, signingIdentity, bundleId, bundleId);
    }

    private static ProvisioningProfile find(List<ProvisioningProfile> profiles, SigningIdentity signingIdentity, String bundleId, String origBundleId) {
        for (ProvisioningProfile p : profiles) {
            if (!p.appId.equals(p.appIdPrefix + "." + bundleId)) continue;
            for (String fp : p.certFingerprints) {
                if (!fp.equals(signingIdentity.getFingerprint())) continue;
                return p;
            }
        }
        if (!bundleId.equals("*")) {
            int lastDot;
            if (bundleId.endsWith(".*")) {
                bundleId = bundleId.substring(0, bundleId.length() - 2);
            }
            bundleId = (lastDot = bundleId.lastIndexOf(46)) != -1 ? bundleId.substring(0, lastDot) + ".*" : "*";
            return ProvisioningProfile.find(profiles, signingIdentity, bundleId, origBundleId);
        }
        throw new IllegalArgumentException("No provisioning profile found matching signing identity '" + signingIdentity.getName() + "' and app bundle ID '" + origBundleId + "'");
    }

    public String toString() {
        return "ProvisioningProfile [type=" + (Object)((Object)this.type) + ", file=" + this.file + ", uuid=" + this.uuid + ", name=" + this.name + ", appIdName=" + this.appIdName + ", appIdPrefix=" + this.appIdPrefix + ", appId=" + this.appId + ", creationDate=" + this.creationDate + ", expirationDate=" + this.expirationDate + ", certFingerprints=" + this.certFingerprints + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisioningProfile other = (ProvisioningProfile)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(ProvisioningProfile.list());
        } else if (args.length == 1) {
            System.out.println(ProvisioningProfile.find(ProvisioningProfile.list(), args[0]));
        } else {
            System.out.println(ProvisioningProfile.find(ProvisioningProfile.list(), SigningIdentity.find(SigningIdentity.list(), args[0]), args[1]));
        }
    }

    public static enum Type {
        Development,
        AppStore,
        AdHoc;

    }
}

