/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.trampoline;

import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.trampoline.Trampoline;

public class NativeCall
extends Trampoline {
    private static final long serialVersionUID = 1L;
    private final String methodName;
    private final String methodDesc;
    private final boolean ztatic;

    public NativeCall(String callingClass, String targetClass, String methodName, String methodDesc, boolean ztatic) {
        super(callingClass, targetClass);
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.ztatic = ztatic;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public boolean isStatic() {
        return this.ztatic;
    }

    @Override
    public FunctionType getFunctionType() {
        return Types.getNativeFunctionType(this.methodDesc, this.ztatic);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.methodDesc == null ? 0 : this.methodDesc.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NativeCall other = (NativeCall)obj;
        if (this.methodDesc == null ? other.methodDesc != null : !this.methodDesc.equals(other.methodDesc)) {
            return false;
        }
        return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
    }

    @Override
    public int compareTo(Trampoline o) {
        int c = super.compareTo(o);
        if (c == 0 && (c = this.methodName.compareTo(((NativeCall)o).methodName)) == 0) {
            c = this.methodDesc.compareTo(((NativeCall)o).methodDesc);
        }
        return c;
    }

    @Override
    public String toString() {
        return Symbols.trampolineMethodSymbol(this, this.getCallingClass(), this.getTarget(), this.getMethodName(), this.getMethodDesc());
    }
}

