/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class GenericSignatureParser {
    private final String signature;

    public GenericSignatureParser(String signature) {
        int s = signature.indexOf(40);
        String sig = signature;
        if (s > 0) {
            sig = sig.substring(s);
        } else if (s < 0 || sig.indexOf(58) >= 0 || sig.startsWith("(V)")) {
            throw new IllegalArgumentException("Bad method signature: " + signature);
        }
        this.signature = sig;
    }

    public Iterator<String> parameterSignatureIterator() {
        return new ParameterSignatureIterator();
    }

    public String getParameterSignature(int index) {
        Iterator<String> it = this.parameterSignatureIterator();
        while (index > 0) {
            it.next();
            --index;
        }
        return it.next();
    }

    public String getReturnTypeSignature() {
        int endOfParams = this.signature.lastIndexOf(41);
        if (endOfParams < 0) {
            throw new IllegalArgumentException("Bad method signature: " + this.signature);
        }
        return this.signature.substring(endOfParams + 1);
    }

    public int getNumParameters() {
        int count = 0;
        Iterator<String> i = this.parameterSignatureIterator();
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        return count;
    }

    private class ParameterSignatureIterator
    implements Iterator<String> {
        private int index = 1;

        private ParameterSignatureIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < GenericSignatureParser.this.signature.length() && GenericSignatureParser.this.signature.charAt(this.index) != ')' && GenericSignatureParser.this.signature.charAt(this.index) != '^';
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String next() {
            boolean done;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StringBuilder result = new StringBuilder();
            do {
                done = true;
                char ch = GenericSignatureParser.this.signature.charAt(this.index);
                switch (ch) {
                    case '*': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'Z': {
                        result.append(GenericSignatureParser.this.signature.charAt(this.index));
                        ++this.index;
                        break;
                    }
                    case 'L': 
                    case 'T': {
                        String tmp = "";
                        int startsemi = this.index;
                        int leftCount = 0;
                        int i = startsemi + 1;
                        block12: while (true) {
                            char c = GenericSignatureParser.this.signature.charAt(i);
                            switch (c) {
                                case ';': {
                                    if (leftCount != 0) break;
                                    break block12;
                                }
                                case '<': {
                                    ++leftCount;
                                    break;
                                }
                                case '>': {
                                    --leftCount;
                                }
                            }
                            ++i;
                        }
                        String foo = GenericSignatureParser.this.signature.substring(startsemi, i + 1);
                        result.append(foo);
                        this.index = i + 1;
                        break;
                    }
                    case '+': 
                    case '-': 
                    case '[': {
                        result.append(GenericSignatureParser.this.signature.charAt(this.index));
                        ++this.index;
                        done = false;
                        break;
                    }
                    case ')': 
                    case '^': {
                        throw new NoSuchElementException("Should have already thrown NoSuchElementException");
                    }
                    default: {
                        throw new IllegalStateException("Invalid method signature: '" + GenericSignatureParser.this.signature + "' : " + GenericSignatureParser.this.signature.substring(this.index) + " " + result);
                    }
                }
            } while (!done);
            return result.toString();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

