/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util.generic;

import org.robovm.compiler.util.generic.ListOfTypes;
import org.robovm.compiler.util.generic.ParameterizedType;
import org.robovm.compiler.util.generic.SootClassType;
import org.robovm.compiler.util.generic.Type;
import soot.SootResolver;

public final class ImplForType
implements ParameterizedType {
    private final ListOfTypes args;
    private final ImplForType ownerType0;
    private Type ownerTypeRes;
    private SootClassType rawType;
    private final String rawTypeName;

    public ImplForType(ImplForType ownerType, String rawTypeName, ListOfTypes args) {
        this.ownerType0 = ownerType;
        this.rawTypeName = rawTypeName;
        this.args = args;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.args.getResolvedTypes().clone();
    }

    @Override
    public Type getOwnerType() {
        if (this.ownerTypeRes == null) {
            this.ownerTypeRes = this.ownerType0 != null ? this.ownerType0.getResolvedType() : this.getRawType().getDeclaringClass();
        }
        return this.ownerTypeRes;
    }

    @Override
    public SootClassType getRawType() {
        if (this.rawType == null) {
            this.rawType = new SootClassType(SootResolver.v().makeClassRef(this.rawTypeName));
        }
        return this.rawType;
    }

    Type getResolvedType() {
        if (this.args.getResolvedTypes().length == 0) {
            return this.getRawType();
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rawTypeName);
        if (this.args.length() > 0) {
            sb.append("<").append(this.args).append(">");
        }
        return sb.toString();
    }
}

