/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util.generic;

import org.robovm.compiler.util.generic.GenericDeclaration;
import org.robovm.compiler.util.generic.ListOfTypes;
import org.robovm.compiler.util.generic.SootClassType;
import org.robovm.compiler.util.generic.SootConstructorType;
import org.robovm.compiler.util.generic.SootMethodType;
import org.robovm.compiler.util.generic.Type;
import org.robovm.compiler.util.generic.TypeVariable;

public final class ImplForVariable<D extends GenericDeclaration>
implements TypeVariable<D> {
    private ImplForVariable<D> formalVar;
    private final GenericDeclaration declOfVarUser;
    private final String name;
    private D genericDeclaration;
    private ListOfTypes bounds;

    public boolean equals(Object o) {
        if (!(o instanceof TypeVariable)) {
            return false;
        }
        TypeVariable that = (TypeVariable)o;
        return this.getName().equals(that.getName()) && this.getGenericDeclaration().equals(that.getGenericDeclaration());
    }

    public int hashCode() {
        return 31 * this.getName().hashCode() + this.getGenericDeclaration().hashCode();
    }

    ImplForVariable(D genericDecl, String name, ListOfTypes bounds) {
        this.genericDeclaration = genericDecl;
        this.name = name;
        this.bounds = bounds;
        this.formalVar = this;
        this.declOfVarUser = null;
    }

    ImplForVariable(D genericDecl, String name) {
        this.name = name;
        this.declOfVarUser = genericDecl;
    }

    static TypeVariable findFormalVar(GenericDeclaration layer, String name) {
        TypeVariable<?>[] formalVars;
        for (TypeVariable<?> var : formalVars = layer.getTypeParameters()) {
            if (!name.equals(var.getName())) continue;
            return var;
        }
        return null;
    }

    private static GenericDeclaration nextLayer(GenericDeclaration decl) {
        if (decl instanceof SootClassType) {
            SootClassType cl = (SootClassType)decl;
            if ((decl = cl.getEnclosingMethod()) != null) {
                return decl;
            }
            decl = cl.getEnclosingConstructor();
            if (decl != null) {
                return decl;
            }
            return cl.getEnclosingClass();
        }
        if (decl instanceof SootMethodType) {
            return ((SootMethodType)decl).getDeclaringClass();
        }
        if (decl instanceof SootConstructorType) {
            return ((SootConstructorType)decl).getDeclaringClass();
        }
        throw new AssertionError();
    }

    void resolve() {
        TypeVariable var;
        if (this.formalVar != null) {
            return;
        }
        GenericDeclaration curLayer = this.declOfVarUser;
        while ((var = ImplForVariable.findFormalVar(curLayer, this.name)) == null) {
            if ((curLayer = ImplForVariable.nextLayer(curLayer)) == null) {
                throw new AssertionError((Object)"illegal type variable reference");
            }
        }
        this.formalVar = (ImplForVariable)var;
        this.genericDeclaration = this.formalVar.genericDeclaration;
        this.bounds = this.formalVar.bounds;
    }

    @Override
    public Type[] getBounds() {
        this.resolve();
        return (Type[])this.bounds.getResolvedTypes().clone();
    }

    @Override
    public D getGenericDeclaration() {
        this.resolve();
        return this.genericDeclaration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

