/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util.generic;

import java.util.Arrays;
import org.robovm.compiler.util.generic.ListOfTypes;
import org.robovm.compiler.util.generic.SootClassType;
import org.robovm.compiler.util.generic.Type;
import org.robovm.compiler.util.generic.WildcardType;

public final class ImplForWildcard
implements WildcardType {
    private final ListOfTypes extendsBound;
    private final ListOfTypes superBound;

    public ImplForWildcard(ListOfTypes extendsBound, ListOfTypes superBound) {
        this.extendsBound = extendsBound;
        this.superBound = superBound;
    }

    @Override
    public Type[] getLowerBounds() {
        return (Type[])this.superBound.getResolvedTypes().clone();
    }

    @Override
    public Type[] getUpperBounds() {
        return (Type[])this.extendsBound.getResolvedTypes().clone();
    }

    public boolean equals(Object o) {
        if (!(o instanceof WildcardType)) {
            return false;
        }
        WildcardType that = (WildcardType)o;
        return Arrays.equals(this.getLowerBounds(), that.getLowerBounds()) && Arrays.equals(this.getUpperBounds(), that.getUpperBounds());
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.getLowerBounds()) + Arrays.hashCode(this.getUpperBounds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("?");
        if (this.extendsBound.length() == 1 && !this.extendsBound.getResolvedTypes()[0].equals(new SootClassType("java.lang.Object")) || this.extendsBound.length() > 1) {
            sb.append(" extends ").append(this.extendsBound);
        } else if (this.superBound.length() > 0) {
            sb.append(" super ").append(this.superBound);
        }
        return sb.toString();
    }
}

