/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util.generic;

import org.robovm.compiler.util.generic.GenericDeclaration;
import org.robovm.compiler.util.generic.GenericSignatureParser;
import org.robovm.compiler.util.generic.SootBaseType;
import org.robovm.compiler.util.generic.SootClassType;
import org.robovm.compiler.util.generic.Type;
import org.robovm.compiler.util.generic.TypeVariable;
import org.robovm.compiler.util.generic.Types;
import soot.SootMethod;
import soot.tagkit.SignatureTag;

public class SootMethodType
extends SootBaseType
implements GenericDeclaration {
    private final SootMethod sootMethod;

    public SootMethodType(SootMethod sootMethod) {
        this.sootMethod = sootMethod;
    }

    public SootMethod getSootMethod() {
        return this.sootMethod;
    }

    public TypeVariable<SootMethodType>[] getTypeParameters() {
        GenericSignatureParser parser = new GenericSignatureParser();
        parser.parseForMethod(this, (SignatureTag)this.sootMethod.getTag("SignatureTag"), this.getExceptionTypes());
        return parser.formalTypeParameters;
    }

    public Type[] getGenericParameterTypes() {
        GenericSignatureParser parser = new GenericSignatureParser();
        parser.parseForMethod(this, (SignatureTag)this.sootMethod.getTag("SignatureTag"), this.getExceptionTypes());
        return parser.parameterTypes.getResolvedTypes();
    }

    public Type getGenericReturnType() {
        GenericSignatureParser parser = new GenericSignatureParser();
        parser.parseForMethod(this, (SignatureTag)this.sootMethod.getTag("SignatureTag"), this.getExceptionTypes());
        return Types.getType(parser.returnType);
    }

    public Type[] getParameterTypes() {
        return this.wrapTypes(this.sootMethod.getParameterTypes());
    }

    public SootClassType[] getExceptionTypes() {
        return this.wrapClasses(this.sootMethod.getExceptions());
    }

    public SootClassType getDeclaringClass() {
        return new SootClassType(this.sootMethod.getDeclaringClass());
    }

    public Type getReturnType() {
        return this.wrapType(this.sootMethod.getReturnType());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sootMethod == null ? 0 : this.sootMethod.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SootMethodType other = (SootMethodType)obj;
        return !(this.sootMethod == null ? other.sootMethod != null : !this.sootMethod.equals(other.sootMethod));
    }
}

