/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice;

import org.robovm.libimobiledevice.IDevice;
import org.robovm.libimobiledevice.LibIMobileDeviceException;
import org.robovm.libimobiledevice.binding.IDeviceConnectionRef;
import org.robovm.libimobiledevice.binding.IntOut;
import org.robovm.libimobiledevice.binding.LibIMobileDevice;

public class IDeviceConnection
implements AutoCloseable {
    protected IDeviceConnectionRef ref;

    IDeviceConnection(IDeviceConnectionRef ref) {
        this.ref = ref;
    }

    protected IDeviceConnectionRef getRef() {
        this.checkDisposed();
        return this.ref;
    }

    public int receive(byte[] buffer, int offset, int count) {
        return this.receive(buffer, offset, count, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receive(byte[] buffer, int offset, int count, int timeout) {
        if ((offset | count) < 0 || offset > buffer.length || buffer.length - offset < count) {
            throw new ArrayIndexOutOfBoundsException("length=" + buffer.length + "; regionStart=" + offset + "; regionLength=" + count);
        }
        if (count == 0) {
            return 0;
        }
        byte[] data = buffer;
        if (offset > 0) {
            data = new byte[count];
        }
        IntOut bytesReceivedOut = new IntOut();
        try {
            IDevice.checkResult(LibIMobileDevice.idevice_connection_receive_timeout(this.getRef(), data, count, bytesReceivedOut, timeout));
            int bytesRead = bytesReceivedOut.getValue();
            if (bytesRead > 0 && data != buffer) {
                System.arraycopy(data, 0, buffer, offset, bytesRead);
            }
            int n = bytesRead;
            return n;
        }
        finally {
            bytesReceivedOut.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(byte[] buffer, int offset, int count) {
        if ((offset | count) < 0 || offset > buffer.length || buffer.length - offset < count) {
            throw new ArrayIndexOutOfBoundsException("length=" + buffer.length + "; regionStart=" + offset + "; regionLength=" + count);
        }
        if (count == 0) {
            return 0;
        }
        byte[] data = buffer;
        if (offset > 0) {
            data = new byte[count];
            System.arraycopy(buffer, offset, data, 0, count);
        }
        IntOut bytesSentOut = new IntOut();
        try {
            IDevice.checkResult(LibIMobileDevice.idevice_connection_send(this.getRef(), data, count, bytesSentOut));
            int n = bytesSentOut.getValue();
            return n;
        }
        finally {
            bytesSentOut.delete();
        }
    }

    public void disconnect() {
        this.dispose();
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LibIMobileDeviceException("Already disposed");
        }
    }

    public synchronized void dispose() {
        this.checkDisposed();
        LibIMobileDevice.idevice_disconnect(this.ref);
        this.ref = null;
    }

    @Override
    public void close() {
        this.dispose();
    }
}

