/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.robovm.libimobiledevice.AfcClient;
import org.robovm.libimobiledevice.Callbacks;
import org.robovm.libimobiledevice.IDevice;
import org.robovm.libimobiledevice.LibIMobileDeviceException;
import org.robovm.libimobiledevice.LockdowndClient;
import org.robovm.libimobiledevice.LockdowndServiceDescriptor;
import org.robovm.libimobiledevice.PlistUtil;
import org.robovm.libimobiledevice.binding.InstproxyClientRef;
import org.robovm.libimobiledevice.binding.InstproxyClientRefOut;
import org.robovm.libimobiledevice.binding.LibIMobileDevice;
import org.robovm.libimobiledevice.binding.LockdowndServiceDescriptorStruct;
import org.robovm.libimobiledevice.binding.PlistRef;
import org.robovm.libimobiledevice.binding.PlistRefOut;

public class InstallationProxyClient
implements AutoCloseable {
    public static final String SERVICE_NAME = "com.apple.mobile.installation_proxy";
    protected InstproxyClientRef ref;

    InstallationProxyClient(InstproxyClientRef ref) {
        this.ref = ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstallationProxyClient(IDevice device, LockdowndServiceDescriptor service) {
        if (device == null) {
            throw new NullPointerException("device");
        }
        if (service == null) {
            throw new NullPointerException("service");
        }
        InstproxyClientRefOut refOut = new InstproxyClientRefOut();
        LockdowndServiceDescriptorStruct serviceStruct = new LockdowndServiceDescriptorStruct();
        serviceStruct.setPort((short)service.getPort());
        serviceStruct.setSslEnabled(service.isSslEnabled());
        try {
            InstallationProxyClient.checkResult(LibIMobileDevice.instproxy_client_new(device.getRef(), serviceStruct, refOut));
            this.ref = refOut.getValue();
        }
        finally {
            serviceStruct.delete();
            refOut.delete();
        }
    }

    public NSArray browse() throws IOException {
        return this.browse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray browse(Options.ApplicationType type) throws IOException {
        PlistRefOut plistOut = new PlistRefOut();
        PlistRef clientOpts = new Options().applicationType(type).toPlistRef();
        try {
            InstallationProxyClient.checkResult(LibIMobileDevice.instproxy_browse(this.getRef(), clientOpts, plistOut));
            PlistRef plist = plistOut.getValue();
            NSArray nSArray = (NSArray)PlistUtil.toJavaPlist(plist);
            return nSArray;
        }
        finally {
            plistOut.delete();
            LibIMobileDevice.plist_free(clientOpts);
        }
    }

    public void install(String pkgPath, Options options, StatusCallback callback) throws IOException {
        this.installOrUpgrade(pkgPath, options, callback, false);
    }

    public void upgrade(String pkgPath, Options options, StatusCallback callback) throws IOException {
        this.installOrUpgrade(pkgPath, options, callback, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installOrUpgrade(String pkgPath, Options options, StatusCallback callback, boolean upgrade) throws IOException {
        PlistRef clientOpts = options.toPlistRef();
        try {
            long cb = 0L;
            int cbId = 0;
            if (callback != null) {
                cb = LibIMobileDevice.get_global_instproxy_status_cb();
                cbId = Callbacks.registerInstproxyCallback(callback);
            }
            if (upgrade) {
                InstallationProxyClient.checkResult(LibIMobileDevice.instproxy_upgrade(this.getRef(), pkgPath, clientOpts, cb, cbId));
            } else {
                InstallationProxyClient.checkResult(LibIMobileDevice.instproxy_install(this.getRef(), pkgPath, clientOpts, cb, cbId));
            }
        }
        finally {
            LibIMobileDevice.plist_free(clientOpts);
        }
    }

    protected InstproxyClientRef getRef() {
        this.checkDisposed();
        return this.ref;
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LibIMobileDeviceException("Already disposed");
        }
    }

    public synchronized void dispose() {
        this.checkDisposed();
        LibIMobileDevice.instproxy_client_free(this.ref);
        this.ref = null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    private static void checkResult(int result) {
        switch (result) {
            case 0: {
                return;
            }
            case -1: {
                throw new LibIMobileDeviceException(result, "INSTPROXY_E_INVALID_ARG");
            }
            case -2: {
                throw new LibIMobileDeviceException(result, "INSTPROXY_E_PLIST_ERROR");
            }
            case -3: {
                throw new LibIMobileDeviceException(result, "INSTPROXY_E_CONN_FAILED");
            }
            case -4: {
                throw new LibIMobileDeviceException(result, "INSTPROXY_E_OP_IN_PROGRESS");
            }
            case -5: {
                throw new LibIMobileDeviceException(result, "INSTPROXY_E_OP_FAILED");
            }
            case -6: {
                throw new LibIMobileDeviceException(result, "INSTPROXY_E_RECEIVE_TIMEOUT");
            }
            case -256: {
                throw new LibIMobileDeviceException(result, "INSTPROXY_E_UNKNOWN_ERROR");
            }
        }
        throw new LibIMobileDeviceException(result);
    }

    private static void printUsageAndExit() {
        System.err.println(InstallationProxyClient.class.getName() + " [deviceid] <action> ...");
        System.err.println("  Actions:");
        System.err.println("    install <remotepath>   Performs an install using the package in the specified path.");
        System.err.println("    upgrade <remotepath>   Performs an upgrade using the package in the specified path.");
        System.exit(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        String deviceId = null;
        String action = null;
        int index = 0;
        try {
            action = args[index++];
            if (action.matches("[0-9a-f]{40}")) {
                deviceId = action;
                action = args[index++];
            }
            if (!action.matches("install|upgrade")) {
                System.err.println("Unknown action: " + action);
                InstallationProxyClient.printUsageAndExit();
            }
            if (deviceId == null && deviceId == null) {
                String[] udids = IDevice.listUdids();
                if (udids.length == 0) {
                    System.err.println("No device connected");
                    return;
                }
                if (udids.length > 1) {
                    System.err.println("More than 1 device connected (" + Arrays.asList(udids) + "). Using " + udids[0]);
                }
                deviceId = udids[0];
            }
            try (IDevice device = new IDevice(deviceId);
                 LockdowndClient lockdowndClient = new LockdowndClient(device, AfcClient.class.getSimpleName(), true);){
                LockdowndServiceDescriptor service = lockdowndClient.startService(SERVICE_NAME);
                try (InstallationProxyClient client = new InstallationProxyClient(device, service);){
                    String path = args[index];
                    Options options = new Options();
                    if (path.toLowerCase().endsWith(".app") || path.endsWith("/")) {
                        options.packageType(Options.PackageType.Developer);
                    }
                    final CountDownLatch countDownLatch = new CountDownLatch(1);
                    StatusCallback callback = new StatusCallback(){

                        @Override
                        public void progress(String status, int percentComplete) {
                            System.out.format("[%3d%%] %s\n", percentComplete, status);
                        }

                        @Override
                        public void success() {
                            System.out.format("[100%%] Success!\n", new Object[0]);
                            countDownLatch.countDown();
                        }

                        @Override
                        public void error(String message) {
                            System.out.format("Error: %s\n", message);
                            countDownLatch.countDown();
                        }
                    };
                    switch (action) {
                        case "install": {
                            client.install(path, options, callback);
                            countDownLatch.await();
                            return;
                        }
                        case "upgrade": {
                            client.upgrade(path, options, callback);
                            countDownLatch.await();
                            return;
                        }
                    }
                    return;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            InstallationProxyClient.printUsageAndExit();
        }
    }

    public static interface StatusCallback {
        public void progress(String var1, int var2);

        public void success();

        public void error(String var1);
    }

    public static class Options {
        private Boolean skipUninstall;
        private ApplicationType applicationType;
        private PackageType packageType;
        private ArchiveType archiveType;
        private NSObject applicationSINF;
        private NSObject iTunesMetadata;
        private NSObject returnAttributes;

        public Options skipUninstall(boolean skipUninstall) {
            this.skipUninstall = skipUninstall;
            return this;
        }

        public Options applicationType(ApplicationType applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        public Options packageType(PackageType packageType) {
            this.packageType = packageType;
            return this;
        }

        public Options archiveType(ArchiveType archiveType) {
            this.archiveType = archiveType;
            return this;
        }

        public Options applicationSINF(NSObject applicationSINF) {
            this.applicationSINF = applicationSINF;
            return this;
        }

        public Options iTunesMetadata(NSObject iTunesMetadata) {
            this.iTunesMetadata = iTunesMetadata;
            return this;
        }

        public Options returnAttributes(NSObject returnAttributes) {
            this.returnAttributes = returnAttributes;
            return this;
        }

        PlistRef toPlistRef() throws IOException {
            NSDictionary dict = new NSDictionary();
            if (this.skipUninstall != null) {
                dict.put("SkipUninstall", this.skipUninstall);
            }
            if (this.applicationType != null) {
                dict.put("ApplicationType", this.applicationType.toString());
            }
            if (this.packageType != null) {
                dict.put("PackageType", this.packageType.toString());
            }
            if (this.archiveType != null) {
                dict.put("ArchiveType", this.archiveType.toString());
            }
            if (this.applicationSINF != null) {
                dict.put("ApplicationSINF", this.applicationSINF);
            }
            if (this.iTunesMetadata != null) {
                dict.put("iTunesMetadata", this.iTunesMetadata);
            }
            if (this.returnAttributes != null) {
                dict.put("ReturnAttributes", this.returnAttributes);
            }
            byte[] bytes = BinaryPropertyListWriter.writeToArray(dict);
            PlistRefOut plistOut = new PlistRefOut();
            LibIMobileDevice.plist_from_bin(bytes, bytes.length, plistOut);
            PlistRef plist = plistOut.getValue();
            plistOut.delete();
            return plist;
        }

        public static enum ArchiveType {
            ApplicationOnly,
            DocumentsOnly;

        }

        public static enum PackageType {
            CarrierBundle,
            Developer;

        }

        public static enum ApplicationType {
            User,
            System;

        }
    }
}

