/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice;

import com.dd.plist.NSObject;
import java.io.IOException;
import org.robovm.libimobiledevice.IDevice;
import org.robovm.libimobiledevice.LibIMobileDeviceException;
import org.robovm.libimobiledevice.LockdowndServiceDescriptor;
import org.robovm.libimobiledevice.PlistUtil;
import org.robovm.libimobiledevice.binding.LibIMobileDevice;
import org.robovm.libimobiledevice.binding.LockdowndClientRef;
import org.robovm.libimobiledevice.binding.LockdowndClientRefOut;
import org.robovm.libimobiledevice.binding.LockdowndServiceDescriptorStruct;
import org.robovm.libimobiledevice.binding.LockdowndServiceDescriptorStructOut;
import org.robovm.libimobiledevice.binding.PlistRef;
import org.robovm.libimobiledevice.binding.PlistRefOut;

public class LockdowndClient
implements AutoCloseable {
    protected LockdowndClientRef ref;

    LockdowndClient(LockdowndClientRef ref) {
        this.ref = ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockdowndClient(IDevice device, String label, boolean handshake) {
        if (device == null) {
            throw new NullPointerException("device");
        }
        LockdowndClientRefOut refOut = new LockdowndClientRefOut();
        try {
            LockdowndClient.checkResult(handshake ? LibIMobileDevice.lockdownd_client_new_with_handshake(device.getRef(), refOut, label) : LibIMobileDevice.lockdownd_client_new(device.getRef(), refOut, label));
            this.ref = refOut.getValue();
        }
        finally {
            refOut.delete();
        }
    }

    protected LockdowndClientRef getRef() {
        this.checkDisposed();
        return this.ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockdowndServiceDescriptor startService(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier");
        }
        LockdowndServiceDescriptorStructOut serviceOut = new LockdowndServiceDescriptorStructOut();
        try {
            LockdowndClient.checkResult(LibIMobileDevice.lockdownd_start_service(this.getRef(), identifier, serviceOut));
            LockdowndServiceDescriptor lockdowndServiceDescriptor = new LockdowndServiceDescriptor(serviceOut.getValue());
            return lockdowndServiceDescriptor;
        }
        finally {
            LockdowndServiceDescriptorStruct d = serviceOut.getValue();
            if (d != null) {
                LibIMobileDevice.lockdownd_service_descriptor_free(d);
            }
            serviceOut.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSObject getValue(String domain, String key) throws IOException {
        PlistRefOut plistOut = new PlistRefOut();
        try {
            LockdowndClient.checkResult(LibIMobileDevice.lockdownd_get_value(this.getRef(), domain, key, plistOut));
            PlistRef plist = plistOut.getValue();
            NSObject nSObject = PlistUtil.toJavaPlist(plist);
            return nSObject;
        }
        finally {
            plistOut.delete();
        }
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LibIMobileDeviceException("Already disposed");
        }
    }

    public synchronized void dispose() {
        this.checkDisposed();
        LibIMobileDevice.lockdownd_client_free(this.ref);
        this.ref = null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    private static void checkResult(int result) {
        switch (result) {
            case 0: {
                return;
            }
            case -1: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_INVALID_ARG");
            }
            case -2: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_INVALID_CONF");
            }
            case -3: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_PLIST_ERROR");
            }
            case -4: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_PAIRING_FAILED");
            }
            case -5: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_SSL_ERROR");
            }
            case -6: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_DICT_ERROR");
            }
            case -7: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_START_SERVICE_FAILED");
            }
            case -8: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_NOT_ENOUGH_DATA");
            }
            case -9: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_SET_VALUE_PROHIBITED");
            }
            case -10: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_GET_VALUE_PROHIBITED");
            }
            case -11: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_REMOVE_VALUE_PROHIBITED");
            }
            case -12: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_MUX_ERROR");
            }
            case -13: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_ACTIVATION_FAILED");
            }
            case -14: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_PASSWORD_PROTECTED");
            }
            case -15: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_NO_RUNNING_SESSION");
            }
            case -16: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_INVALID_HOST_ID");
            }
            case -17: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_INVALID_SERVICE");
            }
            case -18: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_INVALID_ACTIVATION_RECORD");
            }
            case -20: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_PAIRING_DIALOG_PENDING");
            }
            case -21: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_USER_DENIED_PAIRING");
            }
            case -256: {
                throw new LibIMobileDeviceException(result, "LOCKDOWN_E_UNKNOWN_ERROR");
            }
        }
        throw new LibIMobileDeviceException(result);
    }
}

