/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice.util;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.robovm.libimobiledevice.AfcClient;
import org.robovm.libimobiledevice.IDevice;
import org.robovm.libimobiledevice.IDeviceConnection;
import org.robovm.libimobiledevice.InstallationProxyClient;
import org.robovm.libimobiledevice.LibIMobileDeviceException;
import org.robovm.libimobiledevice.LockdowndClient;
import org.robovm.libimobiledevice.LockdowndServiceDescriptor;
import org.robovm.libimobiledevice.MobileImageMounterClient;
import org.robovm.libimobiledevice.util.AppPathCallback;

public class AppLauncher {
    public static final int DEFAULT_FORWARD_PORT = 17777;
    private static final String DEBUG_SERVER_SERVICE_NAME = "com.apple.debugserver";
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final int RECEIVE_TIMEOUT = 5000;
    private static final byte[] BREAK = new byte[]{3};
    private byte[] buffer = new byte[4096];
    private StringBuilder bufferedResponses = new StringBuilder(4096);
    private final IDevice device;
    private final String appId;
    private File localAppPath;
    private List<String> args = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private OutputStream stdout = System.out;
    private boolean closeOutOnExit = false;
    private boolean debug = false;
    private int localPort = -1;
    private AppPathCallback appPathCallback = null;
    private volatile boolean killed = false;
    private InstallationProxyClient.StatusCallback installStatusCallback;
    private AfcClient.UploadProgressCallback uploadProgressCallback;
    private String xcodePath;

    public AppLauncher(IDevice device, String appId) {
        this(device, appId, null);
    }

    public AppLauncher(IDevice device, File localAppPath) throws IOException {
        this(device, AppLauncher.getAppId(localAppPath), localAppPath);
    }

    private AppLauncher(IDevice device, String appId, File localAppPath) {
        if (device == null) {
            throw new NullPointerException("device");
        }
        if (appId == null) {
            throw new NullPointerException("appId");
        }
        this.device = device;
        this.appId = appId;
        this.localAppPath = localAppPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getAppId(File f) throws IOException {
        File infoPlistFile;
        if (f == null) {
            throw new NullPointerException("localAppPath");
        }
        if (!f.exists()) {
            throw new FileNotFoundException(f.getAbsolutePath());
        }
        NSDictionary infoPlistDict = null;
        if (f.getName().toLowerCase().endsWith(".ipa")) {
            try (ZipFile zipFile = new ZipFile(f);){
                for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
                    if (!zipEntry.getName().matches("Payload/[^/]+\\.app/Info\\.plist")) continue;
                    try (InputStream is = zipFile.getInputStream(zipEntry);){
                        try {
                            infoPlistDict = (NSDictionary)PropertyListParser.parse(is);
                        }
                        catch (IOException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                    }
                }
            }
        } else if (f.isDirectory() && (infoPlistFile = new File(f, "Info.plist")).exists()) {
            try {
                infoPlistDict = (NSDictionary)PropertyListParser.parse(infoPlistFile);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (infoPlistDict == null) {
            throw new IllegalArgumentException("Path " + f + " is neither a " + ".ipa file nor an iOS app bundle directory.");
        }
        NSString appId = (NSString)infoPlistDict.objectForKey("CFBundleIdentifier");
        if (appId == null) {
            throw new IllegalArgumentException("No CFBundleIdentifier found in the Info.plist file in " + f);
        }
        return appId.toString();
    }

    public AppLauncher uploadProgressCallback(AfcClient.UploadProgressCallback callback) {
        this.uploadProgressCallback = callback;
        return this;
    }

    public AppLauncher installStatusCallback(InstallationProxyClient.StatusCallback callback) {
        this.installStatusCallback = callback;
        return this;
    }

    public AppLauncher args(String ... args) {
        this.args.addAll(Arrays.asList(args));
        return this;
    }

    public AppLauncher stdout(OutputStream stdout) {
        if (stdout == null) {
            throw new NullPointerException("stdout");
        }
        this.stdout = stdout;
        return this;
    }

    public AppLauncher closeOutOnExit(boolean closeOutOnExit) {
        this.closeOutOnExit = closeOutOnExit;
        return this;
    }

    public AppLauncher env(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.env.put(name, value);
        return this;
    }

    public AppLauncher env(Map<String, String> env) {
        if (env == null) {
            throw new NullPointerException("env");
        }
        this.env.putAll(env);
        return this;
    }

    public AppLauncher debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public AppLauncher forward(int localPort) {
        this.localPort = localPort;
        return this;
    }

    public AppLauncher appPathCallback(AppPathCallback callback) {
        this.appPathCallback = callback;
        return this;
    }

    public AppLauncher xcodePath(String xcodePath) {
        this.xcodePath = xcodePath;
        return this;
    }

    public void kill() {
        this.killed = true;
    }

    private static String toHex(String s) {
        byte[] bytes;
        StringBuilder sb = new StringBuilder(s.length() * 2);
        try {
            bytes = s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        for (int i = 0; i < bytes.length; ++i) {
            int c = bytes[i] & 0xFF;
            sb.append(HEX_CHARS[c >> 4]);
            sb.append(HEX_CHARS[c & 0xF]);
        }
        return sb.toString();
    }

    private static byte fromHex(char c1, char c2) {
        int d = 0;
        d = c1 <= '9' ? c1 - 48 : c1 - 97 + 10;
        d <<= 4;
        d = c2 <= '9' ? (d |= c2 - 48) : (d |= c2 - 97 + 10);
        return (byte)d;
    }

    private static byte[] fromHex(String s) {
        int length = s.length();
        byte[] data = new byte[length / 2];
        for (int i = 0; i < length >> 1; ++i) {
            data[i] = AppLauncher.fromHex(s.charAt(i * 2), s.charAt(i * 2 + 1));
        }
        return data;
    }

    private static byte[] fromHex(byte[] buffer, int offset, int length) {
        byte[] data = new byte[length / 2];
        for (int i = 0; i < length >> 1; ++i) {
            data[i] = AppLauncher.fromHex((char)buffer[offset + i * 2], (char)buffer[offset + i * 2 + 1]);
        }
        return data;
    }

    private String encode(String cmd) {
        int checksum = 0;
        for (int i = 0; i < cmd.length(); ++i) {
            checksum += cmd.charAt(i);
        }
        return String.format("$%s#%02x", cmd, checksum & 0xFF);
    }

    private String decode(String packet) {
        int start = 1;
        if (packet.charAt(0) == '+' || packet.charAt(0) == '-') {
            start = 2;
        }
        int end = packet.lastIndexOf(35);
        return packet.substring(start, end);
    }

    private void debugGdb(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }

    protected void log(String s, Object ... args) {
        System.out.format(s, args);
        System.out.println();
    }

    private void sendGdbPacket(IDeviceConnection conn, String packet) throws IOException {
        int sentBytes;
        this.debugGdb("Sending packet: " + packet);
        byte[] data = packet.getBytes("ASCII");
        while ((sentBytes = conn.send(data, 0, data.length)) != data.length) {
            data = Arrays.copyOfRange(data, sentBytes, data.length);
        }
    }

    private String receiveGdbPacket(IDeviceConnection conn) throws IOException, TimeoutException {
        return this.receiveGdbPacket(conn, Integer.MAX_VALUE);
    }

    private String receiveGdbPacket(IDeviceConnection conn, long timeout) throws IOException, TimeoutException {
        int packetEnd = this.bufferedResponses.indexOf("#");
        if (packetEnd != -1 && this.bufferedResponses.length() - packetEnd > 2) {
            String packet = this.bufferedResponses.substring(0, packetEnd + 3);
            this.bufferedResponses.delete(0, packetEnd + 3);
            this.debugGdb("Received packet: " + packet);
            return packet;
        }
        long deadline = System.currentTimeMillis() + timeout;
        do {
            if (this.killed || Thread.currentThread().isInterrupted()) {
                this.killed = true;
                throw new InterruptedIOException();
            }
            int receivedBytes = conn.receive(this.buffer, 0, this.buffer.length, 10);
            if (receivedBytes <= 0) continue;
            this.bufferedResponses.append(new String(this.buffer, 0, receivedBytes, "ASCII"));
            packetEnd = this.bufferedResponses.indexOf("#");
            if (packetEnd == -1 || this.bufferedResponses.length() - packetEnd <= 2) continue;
            String packet = this.bufferedResponses.substring(0, packetEnd + 3);
            this.bufferedResponses.delete(0, packetEnd + 3);
            this.debugGdb("Received packet: " + packet);
            return packet;
        } while (System.currentTimeMillis() <= deadline);
        throw new TimeoutException();
    }

    private boolean receiveGdbAck(IDeviceConnection conn) throws IOException {
        if (this.bufferedResponses.length() > 0) {
            char c = this.bufferedResponses.charAt(0);
            this.bufferedResponses.delete(0, 1);
            return c == '+';
        }
        byte[] buffer = new byte[1];
        conn.receive(buffer, 0, buffer.length, 5000);
        this.debugGdb("Received ack: " + (char)buffer[0]);
        return buffer[0] == 43;
    }

    private void sendReceivePacket(IDeviceConnection conn, String packet, String expectedResponse, boolean ackMode) throws IOException, TimeoutException {
        String response;
        this.sendGdbPacket(conn, packet);
        if (ackMode) {
            this.receiveGdbAck(conn);
        }
        if (!expectedResponse.equals(response = this.decode(this.receiveGdbPacket(conn, 5000L)))) {
            if (response.startsWith("E")) {
                throw new RuntimeException("Launch failed: " + response.substring(1));
            }
            throw new RuntimeException("Launch failed: Unexpected response '" + response + "' to command '" + this.decode(packet) + "'");
        }
    }

    private void kill(IDeviceConnection conn) throws IOException, TimeoutException {
        this.killed = false;
        Thread.interrupted();
        this.debugGdb("Sending break");
        conn.send(BREAK, 0, BREAK.length);
        this.receiveGdbPacket(conn, 5000L);
        this.sendGdbPacket(conn, this.encode("k"));
    }

    private String encodeArgs(String appPath) {
        StringBuilder sb = new StringBuilder();
        String hex = AppLauncher.toHex(appPath);
        sb.append(String.format("%d,0,%s", hex.length(), hex));
        for (int i = 0; i < this.args.size(); ++i) {
            hex = AppLauncher.toHex(this.args.get(i));
            sb.append(String.format(",%d,%d,%s", hex.length(), i + 1, hex));
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getAppPath(LockdowndClient lockdowndClient, String appId) throws IOException {
        LockdowndServiceDescriptor instService = lockdowndClient.startService("com.apple.mobile.installation_proxy");
        try (InstallationProxyClient instClient = new InstallationProxyClient(this.device, instService);){
            NSArray apps = instClient.browse();
            int i = 0;
            while (i < apps.count()) {
                NSDictionary appInfo = (NSDictionary)apps.objectAtIndex(i);
                NSString bundleId = (NSString)appInfo.objectForKey("CFBundleIdentifier");
                if (bundleId != null && appId.equals(bundleId.toString())) {
                    NSString path = (NSString)appInfo.objectForKey("Path");
                    NSDictionary entitlements = (NSDictionary)appInfo.objectForKey("Entitlements");
                    if (entitlements == null) throw new RuntimeException("App with id '" + appId + "' does not " + "have the 'get-task-allow' entitlement and cannot be debugged");
                    if (entitlements.objectForKey("get-task-allow") == null) throw new RuntimeException("App with id '" + appId + "' does not " + "have the 'get-task-allow' entitlement and cannot be debugged");
                    if (!entitlements.objectForKey("get-task-allow").equals(new NSNumber(true))) {
                        throw new RuntimeException("App with id '" + appId + "' does not " + "have the 'get-task-allow' entitlement and cannot be debugged");
                    }
                    if (path == null) {
                        throw new RuntimeException("Path for app with id '" + appId + "' not found");
                    }
                    String string = path.toString();
                    return string;
                }
                ++i;
            }
            throw new RuntimeException("No app with id '" + appId + "' found on device");
        }
    }

    public void install() throws IOException {
        if (this.localAppPath != null) {
            try (LockdowndClient lockdowndClient = new LockdowndClient(this.device, this.getClass().getSimpleName(), true);){
                this.uploadInternal();
                if (this.uploadProgressCallback == null) {
                    this.log("[ 50%%] Upload done. Installing app...", new Object[0]);
                }
                this.installInternal();
                this.localAppPath = null;
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getXcodePath() throws Exception {
        if (this.xcodePath != null) {
            return new File(this.xcodePath);
        }
        File tmpFile = File.createTempFile(this.getClass().getSimpleName(), ".tmp");
        try {
            int ret = new ProcessBuilder("xcode-select", "-print-path").redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.to(tmpFile)).start().waitFor();
            if (ret != 0) {
                throw new IOException("xcode-select failed with error code: " + ret);
            }
            File file = new File(new String(Files.readAllBytes(tmpFile.toPath()), "UTF-8").trim());
            return file;
        }
        finally {
            tmpFile.delete();
        }
    }

    static File findDeveloperImage(File dsDir, String productVersion, String buildVersion) throws FileNotFoundException {
        String[] versionParts = AppLauncher.getProductVersionParts(productVersion);
        String[] patterns = new String[]{String.format("%s\\.%s\\.%s \\(%s\\)", versionParts[0], versionParts[1], versionParts[2], buildVersion), String.format("%s\\.%s\\.%s \\(.*\\)", versionParts[0], versionParts[1], versionParts[2], buildVersion), String.format("%s\\.%s\\.%s", versionParts[0], versionParts[1], versionParts[2]), String.format("%s\\.%s \\(%s\\)", versionParts[0], versionParts[1], buildVersion), String.format("%s\\.%s \\(.*\\)", versionParts[0], versionParts[1], buildVersion), String.format("%s\\.%s", versionParts[0], versionParts[1])};
        File[] dirs = dsDir.listFiles();
        for (String pattern : patterns) {
            for (File dir : dirs) {
                if (!dir.isDirectory() || !dir.getName().matches(pattern)) continue;
                File dmg = new File(dir, "DeveloperDiskImage.dmg");
                File sig = new File(dir, dmg.getName() + ".signature");
                if (!dmg.isFile() || !sig.isFile()) continue;
                return dmg;
            }
        }
        throw new FileNotFoundException("No DeveloperDiskImage.dmg found in " + dsDir.getAbsolutePath() + " for iOS version " + productVersion + " (" + buildVersion + ")");
    }

    private static String[] getProductVersionParts(String productVersion) {
        String[] versionParts = Arrays.copyOf(productVersion.split("\\."), 3);
        for (int i = 0; i < versionParts.length; ++i) {
            if (versionParts[i] != null) continue;
            versionParts[i] = "0";
        }
        return versionParts;
    }

    private void mountDeveloperImage(LockdowndClient lockdowndClient) throws Exception {
        String productVersion = lockdowndClient.getValue(null, "ProductVersion").toString();
        String buildVersion = lockdowndClient.getValue(null, "BuildVersion").toString();
        File deviceSupport = new File(this.getXcodePath(), "Platforms/iPhoneOS.platform/DeviceSupport");
        this.log("Looking up developer disk image for iOS version %s (%s) in %s", productVersion, buildVersion, deviceSupport);
        File devImage = AppLauncher.findDeveloperImage(deviceSupport, productVersion, buildVersion);
        LockdowndServiceDescriptor mimService = lockdowndClient.startService("com.apple.mobile.mobile_image_mounter");
        try (MobileImageMounterClient mimClient = new MobileImageMounterClient(this.device, mimService);){
            this.log("Copying developer disk image %s to device", devImage);
            int majorVersion = Integer.parseInt(AppLauncher.getProductVersionParts(productVersion)[0]);
            if (majorVersion >= 7) {
                mimClient.uploadImage(devImage, null);
            } else {
                LockdowndServiceDescriptor afcService = lockdowndClient.startService("com.apple.afc");
                try (AfcClient afcClient = new AfcClient(this.device, afcService);){
                    afcClient.makeDirectory("/PublicStaging");
                    afcClient.fileCopy(devImage, "/PublicStaging/staging.dimage");
                }
            }
            this.log("Mounting developer disk image", new Object[0]);
            File devImageSig = new File(devImage.getParentFile(), devImage.getName() + ".signature");
            byte[] devImageSigBytes = Files.readAllBytes(devImageSig.toPath());
            NSDictionary result = mimClient.mountImage("/PublicStaging/staging.dimage", devImageSigBytes, null);
            NSString status = (NSString)result.objectForKey("Status");
            if (status == null || !"Complete".equals(status.toString())) {
                throw new IOException("Failed to mount " + devImage.getAbsolutePath() + " on the device.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int launchInternal() throws Exception {
        this.install();
        IDeviceConnection conn = null;
        String appPath = null;
        try (LockdowndClient lockdowndClient = new LockdowndClient(this.device, this.getClass().getSimpleName(), true);){
            appPath = this.getAppPath(lockdowndClient, this.appId);
            if (this.appPathCallback != null) {
                this.appPathCallback.setRemoteAppPath(appPath);
            }
            LockdowndServiceDescriptor debugService = null;
            try {
                debugService = lockdowndClient.startService(DEBUG_SERVER_SERVICE_NAME);
            }
            catch (LibIMobileDeviceException e) {
                if (e.getErrorCode() == -17) {
                    this.mountDeveloperImage(lockdowndClient);
                    debugService = lockdowndClient.startService(DEBUG_SERVER_SERVICE_NAME);
                }
                throw e;
            }
            conn = this.device.connect(debugService.getPort());
            this.log("Debug server port: " + debugService.getPort(), new Object[0]);
        }
        this.log("Remote app path: " + appPath, new Object[0]);
        this.log("Launching app...", new Object[0]);
        try {
            if (this.localPort == -1) {
                int n = this.pipeStdOut(conn, appPath);
                return n;
            }
            int n = this.forward(conn, appPath);
            return n;
        }
        finally {
            conn.dispose();
        }
    }

    private int pipeStdOut(IDeviceConnection conn, String appPath) throws Exception {
        this.log("App Path: %s", appPath);
        this.sendGdbPacket(conn, "+");
        this.sendReceivePacket(conn, this.encode("QStartNoAckMode"), "OK", true);
        this.sendGdbPacket(conn, "+");
        this.sendReceivePacket(conn, this.encode("QEnvironment:NSUnbufferedIO=YES"), "OK", false);
        for (Map.Entry<String, String> entry : this.env.entrySet()) {
            String cmd = String.format("QEnvironment:%s=%s", entry.getKey(), entry.getValue());
            this.sendReceivePacket(conn, this.encode(cmd), "OK", false);
        }
        this.sendReceivePacket(conn, this.encode("QListThreadsInStopReply"), "OK", false);
        this.sendReceivePacket(conn, this.encode("A" + this.encodeArgs(appPath)), "OK", false);
        this.sendReceivePacket(conn, this.encode("qLaunchSuccess"), "OK", false);
        this.sendGdbPacket(conn, this.encode("c"));
        boolean wasInterrupted = false;
        while (true) {
            String payload;
            String response;
            block12: {
                int exitCode;
                response = this.receiveGdbPacket(conn);
                payload = this.decode(response);
                if (payload.charAt(0) != 'W') break block12;
                int n = exitCode = Integer.parseInt(payload.substring(1), 16);
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                return n;
            }
            try {
                try {
                    if (payload.charAt(0) == 'O') {
                        this.stdout.write(AppLauncher.fromHex(payload.substring(1)));
                        continue;
                    }
                    if (payload.charAt(0) == 'T') {
                        String signal = payload.substring(1, 3);
                        String data = payload.substring(3);
                        String threadId = data.replaceAll(".*thread:([0-9a-fA-F]+).*", "$1");
                        String allThreadIds = data.replaceAll(".*threads:([0-9a-fA-F,]+).*", "$1");
                        TreeSet<String> ids = new TreeSet<String>(Arrays.asList(allThreadIds.split(",")));
                        ids.remove(threadId);
                        StringBuilder sb = new StringBuilder("vCont;");
                        for (String id : ids) {
                            sb.append("c:").append(id).append(';');
                        }
                        sb.append('C').append(signal).append(':').append(threadId);
                        this.sendGdbPacket(conn, this.encode(sb.toString()));
                        continue;
                    }
                    throw new RuntimeException("Unexpected response from debugserver: " + response);
                }
                catch (InterruptedIOException e) {
                    wasInterrupted = Thread.currentThread().isInterrupted();
                    this.kill(conn);
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
            break;
        }
    }

    /*
     * Exception decompiling
     */
    private int forward(IDeviceConnection conn, String appPath) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK], 6[TRYBLOCK]], but top level block is 31[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void debugForward(OutputStream fileOut, String prefix, List<byte[]> messages) throws IOException {
        if (!this.debug) {
            return;
        }
        for (byte[] message : messages) {
            String msgStr = null;
            msgStr = message.length > 256 ? "(" + message.length + ") " + new String(message, 0, 256, "ASCII") : new String(message, "ASCII");
            String msg = prefix + msgStr;
            fileOut.write(msg.getBytes("ASCII"));
            fileOut.write(10);
            System.out.println(msg);
        }
    }

    private void installInternal() throws Exception {
        try (LockdowndClient lockdowndClient = new LockdowndClient(this.device, this.getClass().getSimpleName(), true);){
            final LibIMobileDeviceException[] ex = new LibIMobileDeviceException[1];
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            LockdowndServiceDescriptor instproxyService = lockdowndClient.startService("com.apple.mobile.installation_proxy");
            try (InstallationProxyClient instClient = new InstallationProxyClient(this.device, instproxyService);){
                instClient.upgrade("/PublicStaging/" + this.localAppPath.getName(), new InstallationProxyClient.Options().packageType(this.localAppPath.isDirectory() ? InstallationProxyClient.Options.PackageType.Developer : null), new InstallationProxyClient.StatusCallback(){

                    @Override
                    public void progress(String status, int percentComplete) {
                        if (AppLauncher.this.installStatusCallback != null) {
                            AppLauncher.this.installStatusCallback.progress(status, percentComplete);
                        } else {
                            AppLauncher.this.log("[%3d%%] %s", 50 + percentComplete / 2, status);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void success() {
                        try {
                            if (AppLauncher.this.installStatusCallback != null) {
                                AppLauncher.this.installStatusCallback.success();
                            } else {
                                AppLauncher.this.log("[100%%] Installation complete", new Object[0]);
                            }
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void error(String message) {
                        try {
                            ex[0] = new LibIMobileDeviceException(message);
                            if (AppLauncher.this.installStatusCallback != null) {
                                AppLauncher.this.installStatusCallback.error(message);
                            } else {
                                AppLauncher.this.log("Error: %s", message);
                            }
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                });
                countDownLatch.await();
            }
            if (ex[0] != null) {
                throw ex[0];
            }
        }
    }

    private void uploadInternal() throws Exception {
        try (LockdowndClient lockdowndClient = new LockdowndClient(this.device, this.getClass().getSimpleName(), true);){
            LockdowndServiceDescriptor afcService = lockdowndClient.startService("com.apple.afc");
            try (AfcClient afcClient = new AfcClient(this.device, afcService);){
                afcClient.upload(this.localAppPath, "/PublicStaging", new AfcClient.UploadProgressCallback(){

                    @Override
                    public void progress(File path, int percentComplete) {
                        if (AppLauncher.this.uploadProgressCallback != null) {
                            AppLauncher.this.uploadProgressCallback.progress(path, percentComplete);
                        } else {
                            AppLauncher.this.log("[%3d%%] Uploading %s", percentComplete / 2, path);
                        }
                    }

                    @Override
                    public void success() {
                        if (AppLauncher.this.uploadProgressCallback != null) {
                            AppLauncher.this.uploadProgressCallback.success();
                        }
                    }

                    @Override
                    public void error(String message) {
                        if (AppLauncher.this.uploadProgressCallback != null) {
                            AppLauncher.this.uploadProgressCallback.error(message);
                        } else {
                            AppLauncher.this.log("Error: %s", message);
                        }
                    }
                });
            }
        }
    }

    public int launch() throws IOException {
        try {
            int n = this.launchInternal();
            return n;
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.closeOutOnExit) {
                try {
                    this.stdout.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private static void printUsageAndExit() {
        System.err.println(AppLauncher.class.getName() + " ...");
        System.err.println("  -appid    the id (CFBundleIdentifier) of the app to launch.");
        System.err.println("  -b path   to app bundle directory or IPA containing the app to launch.");
        System.err.println("  -udid     id of the device to launch on. If not specified the first device will be used.");
        System.err.println("  -debug    enable debug output.");
        System.err.println("  -f port   forwards the debug server connection to the local port after the app has launched");
        System.err.println("  -env name=value\n            adds an environment variable with the specified name and value.");
        System.err.println("  -args ... the rest of the command line will be passed on as args to the app.");
        System.exit(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] args) throws Exception {
        String appId = null;
        File localAppPath = null;
        String[] arguments = new String[]{};
        HashMap<String, String> env = new HashMap<String, String>();
        boolean debug = false;
        String deviceId = null;
        int forwardPort = -1;
        int i = 0;
        block21: while (i < args.length) {
            switch (args[i++]) {
                case "-h": 
                case "-help": {
                    AppLauncher.printUsageAndExit();
                    break;
                }
                case "-appid": {
                    appId = args[i++];
                    break;
                }
                case "-b": {
                    localAppPath = new File(args[i++]);
                    break;
                }
                case "-f": {
                    forwardPort = Integer.parseInt(args[i++]);
                    break;
                }
                case "-udid": {
                    deviceId = args[i++];
                    break;
                }
                case "-env": {
                    String[] parts = args[i++].split("=", 2);
                    env.put(parts[0], parts[1]);
                    break;
                }
                case "-debug": {
                    debug = true;
                    break;
                }
                case "-args": {
                    arguments = Arrays.copyOfRange(args, i, args.length);
                    break block21;
                }
            }
        }
        if (appId == null && localAppPath == null) {
            AppLauncher.printUsageAndExit();
        }
        if (deviceId == null) {
            String[] udids = IDevice.listUdids();
            if (udids.length == 0) {
                System.err.println("No device connected");
                return;
            }
            if (udids.length > 1) {
                System.err.println("More than 1 device connected (" + Arrays.asList(udids) + "). Using " + udids[0]);
            }
            deviceId = udids[0];
        }
        IDevice device = new IDevice(deviceId);
        AppLauncher launcher = null;
        launcher = localAppPath != null ? new AppLauncher(device, localAppPath) : new AppLauncher(device, appId);
        System.exit(launcher.args(arguments).env(env).debug(debug).forward(forwardPort).launch());
    }
}

