/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice.util;

import java.util.ArrayList;
import java.util.List;

public class GdbRemoteParser {
    int hashPosition = -1;
    int position = 0;
    boolean waitingForChecksum = false;
    byte[] buffer = new byte[4096];

    public List<byte[]> parse(byte[] bytes) {
        return this.parse(bytes, 0, bytes.length);
    }

    public List<byte[]> parse(byte[] bytes, int offset, int length) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int i = offset; i < offset + length; ++i) {
            byte[] tmp;
            byte b = bytes[i];
            if (this.buffer.length == this.position) {
                tmp = new byte[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
                this.buffer = tmp;
            }
            this.buffer[this.position++] = b;
            if (this.waitingForChecksum && this.position - this.hashPosition == 2) {
                this.waitingForChecksum = false;
                tmp = new byte[this.position];
                System.arraycopy(this.buffer, 0, tmp, 0, this.position);
                this.position = 0;
                result.add(tmp);
                continue;
            }
            if (b != 35) continue;
            this.waitingForChecksum = true;
            this.hashPosition = this.position;
        }
        return result;
    }
}

