/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm;

import java.io.File;
import java.io.UnsupportedEncodingException;
import org.robovm.llvm.Context;
import org.robovm.llvm.LlvmException;
import org.robovm.llvm.Type;
import org.robovm.llvm.binding.LLVM;
import org.robovm.llvm.binding.MemoryBufferRef;
import org.robovm.llvm.binding.ModuleRef;
import org.robovm.llvm.binding.ModuleRefOut;
import org.robovm.llvm.binding.StringOut;

public class Module {
    protected ModuleRef ref;

    private Module(ModuleRef moduleRef) {
        this.ref = moduleRef;
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LlvmException("Already disposed");
        }
    }

    public synchronized void dispose() {
        this.checkDisposed();
        LLVM.DisposeModule(this.ref);
        this.ref = null;
    }

    public Type getTypeByName(String name) {
        this.checkDisposed();
        return new Type(LLVM.GetTypeByName(this.ref, name));
    }

    public void writeBitcode(File file) {
        this.checkDisposed();
        if (LLVM.WriteBitcodeToFile(this.ref, file.getAbsolutePath()) != 0) {
            throw new LlvmException("Write failed");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Module other = (Module)obj;
        return !(this.ref == null ? other.ref != null : !this.ref.equals(other.ref));
    }

    public static Module parseIR(Context context, String ir, String filename) {
        try {
            return Module.parseIR(context, ir.getBytes("utf-8"), filename);
        }
        catch (UnsupportedEncodingException e) {
            throw new LlvmException(e);
        }
    }

    public static Module parseIR(Context context, byte[] data, String filename) {
        MemoryBufferRef memoryBufferRef = LLVM.CreateMemoryBufferWithMemoryRangeCopy(data, filename = filename == null ? "" : filename);
        if (memoryBufferRef == null) {
            throw new LlvmException("Failed to create memory buffer");
        }
        ModuleRefOut moduleRefOut = new ModuleRefOut();
        StringOut errorMessage = new StringOut();
        if (!LLVM.ParseIRInContext(context.ref, memoryBufferRef, moduleRefOut, errorMessage)) {
            return new Module(moduleRefOut.getValue());
        }
        throw new LlvmException(errorMessage.getValue().trim());
    }
}

