/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm;

import org.robovm.llvm.LlvmException;
import org.robovm.llvm.Module;
import org.robovm.llvm.binding.LLVM;
import org.robovm.llvm.binding.PassManagerRef;

public class PassManager {
    protected PassManagerRef ref = LLVM.CreatePassManager();

    public PassManager() {
        if (this.ref == null) {
            throw new LlvmException("Failed to create PassManager");
        }
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LlvmException("Already disposed");
        }
    }

    public synchronized void dispose() {
        this.checkDisposed();
        LLVM.DisposePassManager(this.ref);
        this.ref = null;
    }

    public void addAggressiveDCEPass() {
        this.checkDisposed();
        LLVM.AddAggressiveDCEPass(this.ref);
    }

    public void addAlwaysInlinerPass() {
        this.checkDisposed();
        LLVM.AddAlwaysInlinerPass(this.ref);
    }

    public void addArgumentPromotionPass() {
        this.checkDisposed();
        LLVM.AddArgumentPromotionPass(this.ref);
    }

    public void addBasicAliasAnalysisPass() {
        this.checkDisposed();
        LLVM.AddBasicAliasAnalysisPass(this.ref);
    }

    public void addBBVectorizePass() {
        this.checkDisposed();
        LLVM.AddBBVectorizePass(this.ref);
    }

    public void addCFGSimplificationPass() {
        this.checkDisposed();
        LLVM.AddCFGSimplificationPass(this.ref);
    }

    public void addConstantMergePass() {
        this.checkDisposed();
        LLVM.AddConstantMergePass(this.ref);
    }

    public void addConstantPropagationPass() {
        this.checkDisposed();
        LLVM.AddConstantPropagationPass(this.ref);
    }

    public void addCorrelatedValuePropagationPass() {
        this.checkDisposed();
        LLVM.AddCorrelatedValuePropagationPass(this.ref);
    }

    public void addDeadArgEliminationPass() {
        this.checkDisposed();
        LLVM.AddDeadArgEliminationPass(this.ref);
    }

    public void addDeadStoreEliminationPass() {
        this.checkDisposed();
        LLVM.AddDeadStoreEliminationPass(this.ref);
    }

    public void addDemoteMemoryToRegisterPass() {
        this.checkDisposed();
        LLVM.AddDemoteMemoryToRegisterPass(this.ref);
    }

    public void addEarlyCSEPass() {
        this.checkDisposed();
        LLVM.AddEarlyCSEPass(this.ref);
    }

    public void addFunctionAttrsPass() {
        this.checkDisposed();
        LLVM.AddFunctionAttrsPass(this.ref);
    }

    public void addFunctionInliningPass() {
        this.checkDisposed();
        LLVM.AddFunctionInliningPass(this.ref);
    }

    public void addGlobalDCEPass() {
        this.checkDisposed();
        LLVM.AddGlobalDCEPass(this.ref);
    }

    public void addGlobalOptimizerPass() {
        this.checkDisposed();
        LLVM.AddGlobalOptimizerPass(this.ref);
    }

    public void addGVNPass() {
        this.checkDisposed();
        LLVM.AddGVNPass(this.ref);
    }

    public void addIndVarSimplifyPass() {
        this.checkDisposed();
        LLVM.AddIndVarSimplifyPass(this.ref);
    }

    public void addInstructionCombiningPass() {
        this.checkDisposed();
        LLVM.AddInstructionCombiningPass(this.ref);
    }

    public void addInternalizePass(boolean allButMain) {
        this.checkDisposed();
        LLVM.AddInternalizePass(this.ref, allButMain ? 1 : 0);
    }

    public void addIPConstantPropagationPass() {
        this.checkDisposed();
        LLVM.AddIPConstantPropagationPass(this.ref);
    }

    public void addIPSCCPPass() {
        this.checkDisposed();
        LLVM.AddIPSCCPPass(this.ref);
    }

    public void addJumpThreadingPass() {
        this.checkDisposed();
        LLVM.AddJumpThreadingPass(this.ref);
    }

    public void addLICMPass() {
        this.checkDisposed();
        LLVM.AddLICMPass(this.ref);
    }

    public void addLoopDeletionPass() {
        this.checkDisposed();
        LLVM.AddLoopDeletionPass(this.ref);
    }

    public void addLoopIdiomPass() {
        this.checkDisposed();
        LLVM.AddLoopIdiomPass(this.ref);
    }

    public void addLoopRotatePass() {
        this.checkDisposed();
        LLVM.AddLoopRotatePass(this.ref);
    }

    public void addLoopUnrollPass() {
        this.checkDisposed();
        LLVM.AddLoopUnrollPass(this.ref);
    }

    public void addLoopUnswitchPass() {
        this.checkDisposed();
        LLVM.AddLoopUnswitchPass(this.ref);
    }

    public void addLoopVectorizePass() {
        this.checkDisposed();
        LLVM.AddLoopVectorizePass(this.ref);
    }

    public void addLowerExpectIntrinsicPass() {
        this.checkDisposed();
        LLVM.AddLowerExpectIntrinsicPass(this.ref);
    }

    public void addMemCpyOptPass() {
        this.checkDisposed();
        LLVM.AddMemCpyOptPass(this.ref);
    }

    public void addPromoteMemoryToRegisterPass() {
        this.checkDisposed();
        LLVM.AddPromoteMemoryToRegisterPass(this.ref);
    }

    public void addPruneEHPass() {
        this.checkDisposed();
        LLVM.AddPruneEHPass(this.ref);
    }

    public void addReassociatePass() {
        this.checkDisposed();
        LLVM.AddReassociatePass(this.ref);
    }

    public void addScalarReplAggregatesPass() {
        this.checkDisposed();
        LLVM.AddScalarReplAggregatesPass(this.ref);
    }

    public void addScalarReplAggregatesPassSSA() {
        this.checkDisposed();
        LLVM.AddScalarReplAggregatesPassSSA(this.ref);
    }

    public void addScalarReplAggregatesPassWithThreshold(int threshold) {
        this.checkDisposed();
        LLVM.AddScalarReplAggregatesPassWithThreshold(this.ref, threshold);
    }

    public void addSCCPPass() {
        this.checkDisposed();
        LLVM.AddSCCPPass(this.ref);
    }

    public void addSimplifyLibCallsPass() {
        this.checkDisposed();
        LLVM.AddSimplifyLibCallsPass(this.ref);
    }

    public void addSLPVectorizePass() {
        this.checkDisposed();
        LLVM.AddSLPVectorizePass(this.ref);
    }

    public void addStripDeadPrototypesPass() {
        this.checkDisposed();
        LLVM.AddStripDeadPrototypesPass(this.ref);
    }

    public void addStripSymbolsPass() {
        this.checkDisposed();
        LLVM.AddStripSymbolsPass(this.ref);
    }

    public void addTailCallEliminationPass() {
        this.checkDisposed();
        LLVM.AddTailCallEliminationPass(this.ref);
    }

    public void addTypeBasedAliasAnalysisPass() {
        this.checkDisposed();
        LLVM.AddTypeBasedAliasAnalysisPass(this.ref);
    }

    public void addVerifierPass() {
        this.checkDisposed();
        LLVM.AddVerifierPass(this.ref);
    }

    public void run(Module module) {
        this.checkDisposed();
        LLVM.RunPassManager(this.ref, module.ref);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PassManager other = (PassManager)obj;
        return !(this.ref == null ? other.ref != null : !this.ref.equals(other.ref));
    }
}

