/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm;

import java.io.OutputStream;
import org.robovm.llvm.DataLayout;
import org.robovm.llvm.LlvmException;
import org.robovm.llvm.Module;
import org.robovm.llvm.Target;
import org.robovm.llvm.TargetOptions;
import org.robovm.llvm.binding.CodeGenFileType;
import org.robovm.llvm.binding.LLVM;
import org.robovm.llvm.binding.MemoryBufferRef;
import org.robovm.llvm.binding.StringOut;
import org.robovm.llvm.binding.TargetMachineRef;

public class TargetMachine {
    protected TargetMachineRef ref;

    TargetMachine(TargetMachineRef ref) {
        this.ref = ref;
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LlvmException("Already disposed");
        }
    }

    public synchronized void dispose() {
        this.checkDisposed();
        LLVM.DisposeTargetMachine(this.ref);
        this.ref = null;
    }

    public Target getTarget() {
        this.checkDisposed();
        return new Target(LLVM.GetTargetMachineTarget(this.ref));
    }

    public DataLayout getDataLayout() {
        this.checkDisposed();
        return new DataLayout(LLVM.GetTargetMachineData(this.ref));
    }

    public TargetOptions getOptions() {
        return new TargetOptions(LLVM.GetTargetMachineTargetOptions(this.ref));
    }

    public String getTriple() {
        this.checkDisposed();
        return LLVM.GetTargetMachineTriple(this.ref);
    }

    public String getCPU() {
        this.checkDisposed();
        return LLVM.GetTargetMachineCPU(this.ref);
    }

    public String getFeatureString() {
        this.checkDisposed();
        return LLVM.GetTargetMachineFeatureString(this.ref);
    }

    public boolean hasMCRelaxAll() {
        return LLVM.TargetMachineHasMCRelaxAll(this.ref);
    }

    public void setMCRelaxAll(boolean value) {
        LLVM.TargetMachineSetMCRelaxAll(this.ref, value);
    }

    public boolean hasMCSaveTempLabels() {
        return LLVM.TargetMachineHasMCSaveTempLabels(this.ref);
    }

    public void setMCSaveTempLabels(boolean value) {
        LLVM.TargetMachineSetMCSaveTempLabels(this.ref, value);
    }

    public boolean hasMCNoExecStack() {
        return LLVM.TargetMachineHasMCNoExecStack(this.ref);
    }

    public void setMCNoExecStack(boolean value) {
        LLVM.TargetMachineSetMCNoExecStack(this.ref, value);
    }

    public boolean hasMCUseLoc() {
        return LLVM.TargetMachineHasMCUseLoc(this.ref);
    }

    public void setMCUseLoc(boolean value) {
        LLVM.TargetMachineSetMCUseLoc(this.ref, value);
    }

    public boolean hasMCUseCFI() {
        return LLVM.TargetMachineHasMCUseCFI(this.ref);
    }

    public void setMCUseCFI(boolean value) {
        LLVM.TargetMachineSetMCUseCFI(this.ref, value);
    }

    public boolean hasMCUseDwarfDirectory() {
        return LLVM.TargetMachineHasMCUseDwarfDirectory(this.ref);
    }

    public void setMCUseDwarfDirectory(boolean value) {
        LLVM.TargetMachineSetMCUseDwarfDirectory(this.ref, value);
    }

    public boolean getAsmVerbosityDefault() {
        return LLVM.TargetMachineGetAsmVerbosityDefault(this.ref);
    }

    public void setAsmVerbosityDefault(boolean value) {
        LLVM.TargetMachineSetAsmVerbosityDefault(this.ref, value);
    }

    public boolean getDataSections() {
        return LLVM.TargetMachineGetDataSections(this.ref);
    }

    public boolean getFunctionSections() {
        return LLVM.TargetMachineGetFunctionSections(this.ref);
    }

    public void setDataSections(boolean value) {
        LLVM.TargetMachineSetDataSections(this.ref, value);
    }

    public void setFunctionSections(boolean value) {
        LLVM.TargetMachineSetFunctionSections(this.ref, value);
    }

    public void emit(Module module, OutputStream out, CodeGenFileType fileType) {
        this.checkDisposed();
        module.checkDisposed();
        StringOut ErrorMessage = new StringOut();
        if (LLVM.TargetMachineEmitToOutputStream(this.ref, module.ref, out, fileType, ErrorMessage)) {
            throw new LlvmException(ErrorMessage.getValue().trim());
        }
    }

    public void assemble(byte[] asm, String filename, OutputStream out) {
        MemoryBufferRef memoryBufferRef = LLVM.CreateMemoryBufferWithMemoryRangeCopy(asm, filename);
        if (memoryBufferRef == null) {
            throw new LlvmException("Failed to create memory buffer");
        }
        filename = filename == null ? "" : filename;
        StringOut errorMessage = new StringOut();
        if (LLVM.TargetMachineAssembleToOutputStream(this.ref, memoryBufferRef, out, false, false, errorMessage) != 0) {
            String error = errorMessage.getValue() != null ? errorMessage.getValue().trim() : "Unknown error";
            throw new LlvmException(error);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TargetMachine other = (TargetMachine)obj;
        return !(this.ref == null ? other.ref != null : !this.ref.equals(other.ref));
    }
}

