/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm.binding;

import org.robovm.llvm.binding.LLVMJNI;

public class LongArray {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected LongArray(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(LongArray obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LLVMJNI.delete_LongArray(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setValue(long value) {
        LLVMJNI.LongArray_value_set(this.swigCPtr, this, value);
    }

    public long getValue() {
        return LLVMJNI.LongArray_value_get(this.swigCPtr, this);
    }

    public LongArray(int nelements) {
        this(LLVMJNI.new_LongArray(nelements), true);
    }

    public long get(int index) {
        return LLVMJNI.LongArray_get(this.swigCPtr, this, index);
    }

    public void set(int index, long value) {
        LLVMJNI.LongArray_set(this.swigCPtr, this, index, value);
    }
}

