/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm.binding;

import org.robovm.llvm.binding.LLVMJNI;
import org.robovm.llvm.binding.ValueRef;

public class ValueRefArray {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected ValueRefArray(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ValueRefArray obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LLVMJNI.delete_ValueRefArray(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setValue(ValueRef value) {
        LLVMJNI.ValueRefArray_value_set(this.swigCPtr, this, ValueRef.getCPtr(value));
    }

    public ValueRef getValue() {
        long cPtr = LLVMJNI.ValueRefArray_value_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new ValueRef(cPtr, false);
    }

    public ValueRefArray(int nelements) {
        this(LLVMJNI.new_ValueRefArray(nelements), true);
    }

    public ValueRef get(int index) {
        long cPtr = LLVMJNI.ValueRefArray_get(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new ValueRef(cPtr, false);
    }

    public void set(int index, ValueRef value) {
        LLVMJNI.ValueRefArray_set(this.swigCPtr, this, index, ValueRef.getCPtr(value));
    }
}

