/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.tagkit.AbstractHost;
import soot.util.Switch;

public abstract class AbstractUnit
extends AbstractHost
implements Unit {
    public static final List emptyList = Collections.EMPTY_LIST;
    List boxesPointingToThis = null;
    List valueBoxes = null;

    @Override
    public abstract Object clone();

    public List getUseBoxes() {
        return emptyList;
    }

    public List getDefBoxes() {
        return emptyList;
    }

    public List getUnitBoxes() {
        return emptyList;
    }

    public List getBoxesPointingToThis() {
        if (this.boxesPointingToThis == null) {
            return emptyList;
        }
        return Collections.unmodifiableList(this.boxesPointingToThis);
    }

    @Override
    public void addBoxPointingToThis(UnitBox b) {
        if (this.boxesPointingToThis == null) {
            this.boxesPointingToThis = new ArrayList();
        }
        this.boxesPointingToThis.add(b);
    }

    @Override
    public void removeBoxPointingToThis(UnitBox b) {
        if (this.boxesPointingToThis != null) {
            this.boxesPointingToThis.remove(b);
        }
    }

    @Override
    public void clearUnitBoxes() {
        for (UnitBox ub : this.getUnitBoxes()) {
            ub.setUnit(null);
        }
    }

    @Override
    public List getUseAndDefBoxes() {
        List useBoxes = this.getUseBoxes();
        List defBoxes = this.getDefBoxes();
        if (useBoxes.isEmpty()) {
            if (defBoxes.isEmpty()) {
                return emptyList;
            }
            return Collections.unmodifiableList(defBoxes);
        }
        if (defBoxes.isEmpty()) {
            return Collections.unmodifiableList(useBoxes);
        }
        this.valueBoxes = new ArrayList();
        this.valueBoxes.addAll(defBoxes);
        this.valueBoxes.addAll(useBoxes);
        this.valueBoxes = Collections.unmodifiableList(this.valueBoxes);
        return this.valueBoxes;
    }

    @Override
    public void apply(Switch sw) {
    }

    @Override
    public void redirectJumpsToThisTo(Unit newLocation) {
        Object[] boxes;
        List boxesPointing = this.getBoxesPointingToThis();
        for (Object element : boxes = boxesPointing.toArray()) {
            UnitBox box = (UnitBox)element;
            if (box.getUnit() != this) {
                throw new RuntimeException("Something weird's happening");
            }
            if (!box.isBranchTarget()) continue;
            box.setUnit(newLocation);
        }
    }
}

