/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import soot.AbstractUnitPrinter;
import soot.Body;
import soot.PatchingChain;
import soot.SootFieldRef;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnitBox;
import soot.jimple.IdentityRef;

public abstract class LabeledUnitPrinter
extends AbstractUnitPrinter {
    protected Map labels;
    protected Map<Unit, String> references;
    protected String labelIndent = "     ";

    public LabeledUnitPrinter(Body b) {
        this.createLabelMaps(b);
    }

    public Map labels() {
        return this.labels;
    }

    public Map<Unit, String> references() {
        return this.references;
    }

    @Override
    public abstract void literal(String var1);

    @Override
    public abstract void methodRef(SootMethodRef var1);

    @Override
    public abstract void fieldRef(SootFieldRef var1);

    @Override
    public abstract void identityRef(IdentityRef var1);

    @Override
    public abstract void type(Type var1);

    @Override
    public void unitRef(Unit u, boolean branchTarget) {
        String oldIndent = this.getIndent();
        if (branchTarget) {
            this.setIndent(this.labelIndent);
            this.handleIndent();
            this.setIndent(oldIndent);
            String label = (String)this.labels.get(u);
            if (label == null || label.equals("<unnamed>")) {
                label = "[?= " + u + "]";
            }
            this.output.append(label);
        } else {
            String ref = this.references.get(u);
            if (this.startOfLine) {
                String newIndent = "(" + ref + ")" + this.indent.substring(ref.length() + 2);
                this.setIndent(newIndent);
                this.handleIndent();
                this.setIndent(oldIndent);
            } else {
                this.output.append(ref);
            }
        }
    }

    private void createLabelMaps(Body body) {
        PatchingChain<Unit> units = body.getUnits();
        this.labels = new HashMap(units.size() * 2 + 1, 0.7f);
        this.references = new HashMap<Unit, String>(units.size() * 2 + 1, 0.7f);
        Iterator<UnitBox> boxIt = body.getAllUnitBoxes().iterator();
        HashSet<Unit> labelStmts = new HashSet<Unit>();
        HashSet<Unit> refStmts = new HashSet<Unit>();
        while (boxIt.hasNext()) {
            UnitBox box = boxIt.next();
            Unit stmt = box.getUnit();
            if (box.isBranchTarget()) {
                labelStmts.add(stmt);
                continue;
            }
            refStmts.add(stmt);
        }
        int labelCount = 0;
        int refCount = 0;
        for (Unit s : units) {
            if (labelStmts.contains(s)) {
                this.labels.put(s, "label" + labelCount++);
            }
            if (!refStmts.contains(s)) continue;
            this.references.put(s, Integer.toString(refCount++));
        }
    }
}

