/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LocalVariable;
import soot.LongType;
import soot.Modifier;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.StmtAddressType;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.Value;
import soot.VoidType;
import soot.coffi.BBQ;
import soot.coffi.BasicBlock;
import soot.coffi.BootstrapMethods_attribute;
import soot.coffi.CONSTANT_Class_info;
import soot.coffi.CONSTANT_Double_info;
import soot.coffi.CONSTANT_Fieldref_info;
import soot.coffi.CONSTANT_Float_info;
import soot.coffi.CONSTANT_Integer_info;
import soot.coffi.CONSTANT_InterfaceMethodref_info;
import soot.coffi.CONSTANT_InvokeDynamic_info;
import soot.coffi.CONSTANT_Long_info;
import soot.coffi.CONSTANT_MethodHandle_info;
import soot.coffi.CONSTANT_NameAndType_info;
import soot.coffi.CONSTANT_String_info;
import soot.coffi.CONSTANT_Utf8_info;
import soot.coffi.Code_attribute;
import soot.coffi.Double2ndHalfType;
import soot.coffi.FutureStmt;
import soot.coffi.ICONSTANT_Methodref_info;
import soot.coffi.Instruction;
import soot.coffi.Instruction_Anewarray;
import soot.coffi.Instruction_Athrow;
import soot.coffi.Instruction_Bipush;
import soot.coffi.Instruction_Checkcast;
import soot.coffi.Instruction_Getfield;
import soot.coffi.Instruction_Getstatic;
import soot.coffi.Instruction_Goto;
import soot.coffi.Instruction_Iinc;
import soot.coffi.Instruction_Instanceof;
import soot.coffi.Instruction_Invokedynamic;
import soot.coffi.Instruction_Invokeinterface;
import soot.coffi.Instruction_Invokenonvirtual;
import soot.coffi.Instruction_Invokestatic;
import soot.coffi.Instruction_Invokevirtual;
import soot.coffi.Instruction_Jsr;
import soot.coffi.Instruction_Jsr_w;
import soot.coffi.Instruction_Ldc1;
import soot.coffi.Instruction_Lookupswitch;
import soot.coffi.Instruction_Multianewarray;
import soot.coffi.Instruction_New;
import soot.coffi.Instruction_Newarray;
import soot.coffi.Instruction_Nop;
import soot.coffi.Instruction_Putfield;
import soot.coffi.Instruction_Putstatic;
import soot.coffi.Instruction_Ret;
import soot.coffi.Instruction_Ret_w;
import soot.coffi.Instruction_Sipush;
import soot.coffi.Instruction_Tableswitch;
import soot.coffi.Instruction_branch;
import soot.coffi.Instruction_bytevar;
import soot.coffi.Instruction_intindex;
import soot.coffi.Interface_Astore;
import soot.coffi.Interface_OneIntArg;
import soot.coffi.LineNumberTable_attribute;
import soot.coffi.LocalVariableTable_attribute;
import soot.coffi.LocalVariableTypeTable_attribute;
import soot.coffi.Long2ndHalfType;
import soot.coffi.OutFlow;
import soot.coffi.TypeStack;
import soot.coffi.Util;
import soot.coffi.attribute_info;
import soot.coffi.cp_info;
import soot.coffi.exception_table_entry;
import soot.coffi.line_number_table_entry;
import soot.coffi.local_variable_table_entry;
import soot.coffi.method_info;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.ClassConstant;
import soot.jimple.ConditionExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.Expr;
import soot.jimple.FloatConstant;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.TableSwitchStmt;
import soot.jimple.VirtualInvokeExpr;
import soot.options.Options;
import soot.tagkit.BytecodeOffsetTag;
import soot.tagkit.LineNumberTag;
import soot.tagkit.Tag;
import soot.util.ArraySet;
import soot.util.Chain;

public class CFG {
    private method_info method;
    BasicBlock cfg;
    Chain units;
    JimpleBody listBody;
    Map<Instruction, Stmt> instructionToFirstStmt;
    Map<Instruction, Stmt> instructionToLastStmt;
    SootMethod jmethod;
    Scene cm;
    Instruction firstInstruction;
    Instruction lastInstruction;
    private Instruction sentinel;
    private Hashtable<Instruction, BasicBlock> h2bb;
    private Hashtable<Instruction, BasicBlock> t2bb;
    public static HashMap<SootMethod, int[]> methodsToVEM = new HashMap();
    Map<Instruction, Instruction> jsr2astore = new HashMap<Instruction, Instruction>();
    Map<Instruction, Instruction> astore2ret = new HashMap<Instruction, Instruction>();
    LinkedList<Instruction> jsrorder = new LinkedList();
    private final Hashtable<Instruction, Instruction_Goto> replacedInsns = new Hashtable();
    private BootstrapMethods_attribute bootstrap_methods_attribute;

    public CFG(method_info m) {
        this.method = m;
        this.sentinel = new Instruction_Nop();
        this.sentinel.next = m.instructions;
        m.instructions.prev = this.sentinel;
        this.eliminateJsrRets();
        this.buildBBCFG();
        this.cfg.beginCode = true;
        m.cfg = this;
        this.firstInstruction = this.cfg != null ? this.cfg.head : null;
    }

    private void complexity() {
        int tmp;
        if (!this.method.jmethod.getDeclaringClass().isApplicationClass()) {
            return;
        }
        BasicBlock b = this.cfg;
        HashMap<BasicBlock, Integer> block2exc = new HashMap<BasicBlock, Integer>();
        int nodes = 0;
        int edges = 0;
        int highest = 0;
        while (b != null) {
            tmp = 0;
            for (exception_table_entry element : this.method.code_attr.exception_table) {
                Instruction start = element.start_inst;
                Instruction end = element.start_inst;
                if ((start.label < b.head.label || start.label > b.tail.label) && (end.label <= b.head.label || b.tail.next != null && end.label > b.tail.next.label)) continue;
                ++tmp;
            }
            block2exc.put(b, new Integer(tmp));
            b = b.next;
        }
        b = this.cfg;
        while (b != null) {
            ++nodes;
            tmp = b.succ.size() + (Integer)block2exc.get(b);
            int deg = b.pred.size() + tmp + (b.beginException ? 1 : 0);
            if (deg > highest) {
                highest = deg;
            }
            edges += tmp;
            b = b.next;
        }
        methodsToVEM.put(this.method.jmethod, new int[]{nodes, edges, highest});
    }

    private void buildBBCFG() {
        Instruction tail;
        Code_attribute ca = this.method.locate_code_attribute();
        this.h2bb = new Hashtable(100, 25.0f);
        this.t2bb = new Hashtable(100, 25.0f);
        Instruction insn = this.sentinel.next;
        BasicBlock blast = null;
        if (insn != null) {
            tail = CFG.buildBasicBlock(insn);
            this.cfg = new BasicBlock(insn, tail);
            this.h2bb.put(insn, this.cfg);
            this.t2bb.put(tail, this.cfg);
            insn = tail.next;
            blast = this.cfg;
        }
        while (insn != null) {
            BasicBlock block;
            tail = CFG.buildBasicBlock(insn);
            blast.next = block = new BasicBlock(insn, tail);
            blast = block;
            this.h2bb.put(insn, block);
            this.t2bb.put(tail, block);
            insn = tail.next;
        }
        BasicBlock block = this.cfg;
        while (block != null) {
            Instruction insn2 = block.tail;
            if (insn2.branches) {
                Object[] branches;
                if (insn2 instanceof Instruction_Athrow) {
                    HashSet<Instruction> ethandlers = new HashSet<Instruction>();
                    for (int i = 0; i < ca.exception_table_length; ++i) {
                        exception_table_entry etentry = ca.exception_table[i];
                        if (insn2.label < etentry.start_inst.label || etentry.end_inst != null && insn2.label >= etentry.end_inst.label) continue;
                        ethandlers.add(etentry.handler_inst);
                    }
                    branches = ethandlers.toArray();
                } else {
                    branches = insn2.branchpoints(insn2.next);
                }
                if (branches != null) {
                    block.succ.ensureCapacity(block.succ.size() + branches.length);
                    for (Object element : branches) {
                        if (element == null) continue;
                        BasicBlock bb = this.h2bb.get(element);
                        if (bb == null) {
                            G.v().out.println("Warning: target of a branch is null");
                            G.v().out.println(insn2);
                            continue;
                        }
                        block.succ.addElement(bb);
                        bb.pred.addElement(block);
                    }
                }
            } else if (block.next != null) {
                block.succ.addElement(block.next);
                block.next.pred.addElement(block);
            }
            block = block.next;
        }
        for (int i = 0; i < ca.exception_table_length; ++i) {
            BasicBlock bb = this.h2bb.get(ca.exception_table[i].handler_inst);
            if (bb == null) {
                G.v().out.println("Warning: No basic block found for start of exception handler code.");
                continue;
            }
            bb.beginException = true;
            ca.exception_table[i].b = bb;
        }
    }

    private static Instruction buildBasicBlock(Instruction head) {
        Instruction insn = head;
        Instruction next = insn.next;
        if (next == null) {
            return insn;
        }
        while (!insn.branches && !next.labelled) {
            insn = next;
            next = insn.next;
            if (next != null) continue;
        }
        return insn;
    }

    private boolean eliminateJsrRets() {
        Instruction insn = this.sentinel;
        while (insn.next != null) {
            insn = insn.next;
        }
        this.lastInstruction = insn;
        HashMap<Instruction, Instruction> todoBlocks = new HashMap<Instruction, Instruction>();
        todoBlocks.put(this.sentinel.next, this.lastInstruction);
        LinkedList<Instruction> todoList = new LinkedList<Instruction>();
        todoList.add(this.sentinel.next);
        while (!todoList.isEmpty()) {
            Instruction firstInsn = (Instruction)todoList.removeFirst();
            Instruction lastInsn = (Instruction)todoBlocks.get(firstInsn);
            this.jsrorder.clear();
            this.jsr2astore.clear();
            this.astore2ret.clear();
            if (!this.findOutmostJsrs(firstInsn, lastInsn)) continue;
            HashMap<Instruction, Instruction> newblocks = this.inliningJsrTargets();
            todoBlocks.putAll(newblocks);
            todoList.addAll(newblocks.keySet());
        }
        this.method.instructions = this.sentinel.next;
        this.adjustExceptionTable();
        this.adjustLineNumberTable();
        this.adjustBranchTargets();
        this.adjustLocalVariableTable();
        return true;
    }

    private boolean findOutmostJsrs(Instruction start, Instruction end) {
        HashSet<Instruction> innerJsrs = new HashSet<Instruction>();
        boolean unusual = false;
        Instruction insn = start;
        do {
            if (insn instanceof Instruction_Jsr || insn instanceof Instruction_Jsr_w) {
                if (innerJsrs.contains(insn)) {
                    insn = insn.next;
                    continue;
                }
                Instruction astore = ((Instruction_branch)insn).target;
                if (!(astore instanceof Interface_Astore)) {
                    unusual = true;
                    break;
                }
                Instruction ret = this.findMatchingRet(astore, insn, innerJsrs);
                this.jsrorder.addLast(insn);
                this.jsr2astore.put(insn, astore);
                this.astore2ret.put(astore, ret);
            }
            insn = insn.next;
        } while (insn != end.next);
        if (unusual) {
            G.v().out.println("Sorry, I cannot handle this method.");
            return false;
        }
        return true;
    }

    private Instruction findMatchingRet(Instruction astore, Instruction jsr, HashSet<Instruction> innerJsrs) {
        int astorenum = ((Interface_Astore)((Object)astore)).getLocalNumber();
        Instruction insn = astore.next;
        while (insn != null) {
            if (insn instanceof Instruction_Ret || insn instanceof Instruction_Ret_w) {
                int retnum = ((Interface_OneIntArg)((Object)insn)).getIntArg();
                if (astorenum == retnum) {
                    return insn;
                }
            } else if (insn instanceof Instruction_Jsr || insn instanceof Instruction_Jsr_w) {
                innerJsrs.add(insn);
            }
            insn = insn.next;
        }
        return null;
    }

    private HashMap<Instruction, Instruction> inliningJsrTargets() {
        HashMap<Instruction, Instruction> newblocks = new HashMap<Instruction, Instruction>();
        while (!this.jsrorder.isEmpty()) {
            Instruction jsr = this.jsrorder.removeFirst();
            Instruction astore = this.jsr2astore.get(jsr);
            Instruction ret = this.astore2ret.get(astore);
            Instruction newhead = this.makeCopyOf(astore, ret, jsr.next);
            Instruction_Goto togo = new Instruction_Goto();
            togo.target = newhead;
            newhead.labelled = true;
            togo.label = jsr.label;
            togo.labelled = jsr.labelled;
            togo.prev = jsr.prev;
            togo.next = jsr.next;
            togo.prev.next = togo;
            togo.next.prev = togo;
            this.replacedInsns.put(jsr, togo);
            if (ret == null) continue;
            newblocks.put(newhead, this.lastInstruction);
        }
        return newblocks;
    }

    private Instruction makeCopyOf(Instruction astore, Instruction ret, Instruction target) {
        Instruction last;
        if (ret == null) {
            return astore.next;
        }
        Instruction headbefore = last = this.lastInstruction;
        int curlabel = this.lastInstruction.label;
        HashMap<Instruction, Instruction> insnmap = new HashMap<Instruction, Instruction>();
        Instruction insn = astore.next;
        while (insn != ret && insn != null) {
            try {
                Instruction newone = (Instruction)insn.clone();
                newone.label = ++curlabel;
                newone.prev = last;
                last.next = newone;
                last = newone;
                insnmap.put(insn, newone);
            }
            catch (CloneNotSupportedException e) {
                G.v().out.println("Error !");
            }
            insn = insn.next;
        }
        Instruction_Goto togo = new Instruction_Goto();
        togo.target = target;
        target.labelled = true;
        togo.label = ++curlabel;
        last.next = togo;
        togo.prev = last;
        this.lastInstruction = last = togo;
        insnmap.put(astore, headbefore.next);
        insnmap.put(ret, togo);
        insn = headbefore.next;
        while (insn != last) {
            Instruction newtgt;
            int i;
            Instruction newdefault;
            Instruction switchinsn;
            if (insn instanceof Instruction_branch) {
                Instruction oldtgt = ((Instruction_branch)insn).target;
                Instruction newtgt2 = (Instruction)insnmap.get(oldtgt);
                if (newtgt2 != null) {
                    ((Instruction_branch)insn).target = newtgt2;
                    newtgt2.labelled = true;
                }
            } else if (insn instanceof Instruction_Lookupswitch) {
                switchinsn = (Instruction_Lookupswitch)insn;
                newdefault = (Instruction)insnmap.get(switchinsn.default_inst);
                if (newdefault != null) {
                    switchinsn.default_inst = newdefault;
                    newdefault.labelled = true;
                }
                for (i = 0; i < switchinsn.match_insts.length; ++i) {
                    newtgt = (Instruction)insnmap.get(switchinsn.match_insts[i]);
                    if (newtgt == null) continue;
                    switchinsn.match_insts[i] = newtgt;
                    newtgt.labelled = true;
                }
            } else if (insn instanceof Instruction_Tableswitch) {
                switchinsn = (Instruction_Tableswitch)insn;
                newdefault = (Instruction)insnmap.get(((Instruction_Tableswitch)switchinsn).default_inst);
                if (newdefault != null) {
                    ((Instruction_Tableswitch)switchinsn).default_inst = newdefault;
                    newdefault.labelled = true;
                }
                for (i = 0; i < ((Instruction_Tableswitch)switchinsn).jump_insts.length; ++i) {
                    newtgt = (Instruction)insnmap.get(((Instruction_Tableswitch)switchinsn).jump_insts[i]);
                    if (newtgt == null) continue;
                    ((Instruction_Tableswitch)switchinsn).jump_insts[i] = newtgt;
                    newtgt.labelled = true;
                }
            }
            insn = insn.next;
        }
        Code_attribute ca = this.method.locate_code_attribute();
        LinkedList<exception_table_entry> newentries = new LinkedList<exception_table_entry>();
        int orig_start_of_subr = astore.next.originalIndex;
        int orig_end_of_subr = ret.originalIndex;
        for (int i = 0; i < ca.exception_table_length; ++i) {
            exception_table_entry etentry = ca.exception_table[i];
            int orig_start_of_trap = etentry.start_pc;
            int orig_end_of_trap = etentry.end_pc;
            if (orig_start_of_trap < orig_end_of_subr && orig_end_of_trap > orig_start_of_subr) {
                Instruction ins;
                exception_table_entry newone = new exception_table_entry();
                newone.start_inst = orig_start_of_trap <= orig_start_of_subr ? headbefore.next : ((ins = (Instruction)insnmap.get(etentry.start_inst)) != null ? (Instruction)insnmap.get(etentry.start_inst) : etentry.start_inst);
                newone.end_inst = orig_end_of_trap > orig_end_of_subr ? null : (Instruction)insnmap.get(etentry.end_inst);
                newone.handler_inst = (Instruction)insnmap.get(etentry.handler_inst);
                if (newone.handler_inst == null) {
                    newone.handler_inst = etentry.handler_inst;
                }
                newentries.add(newone);
            }
            if (etentry.end_inst != null) continue;
            etentry.end_inst = headbefore.next;
        }
        if (newentries.size() > 0) {
            ca.exception_table_length += newentries.size();
            exception_table_entry[] newtable = new exception_table_entry[ca.exception_table_length];
            System.arraycopy(ca.exception_table, 0, newtable, 0, ca.exception_table.length);
            int i = 0;
            int j = ca.exception_table.length;
            while (i < newentries.size()) {
                newtable[j] = (exception_table_entry)newentries.get(i);
                ++i;
                ++j;
            }
            ca.exception_table = newtable;
        }
        return headbefore.next;
    }

    private void adjustBranchTargets() {
        Instruction insn = this.sentinel.next;
        while (insn != null) {
            Instruction newtgt;
            int i;
            Instruction newdefault;
            Instruction switchinsn;
            if (insn instanceof Instruction_branch) {
                Instruction_branch binsn = (Instruction_branch)insn;
                Instruction newtgt2 = this.replacedInsns.get(binsn.target);
                if (newtgt2 != null) {
                    binsn.target = newtgt2;
                    newtgt2.labelled = true;
                }
            } else if (insn instanceof Instruction_Lookupswitch) {
                switchinsn = (Instruction_Lookupswitch)insn;
                newdefault = this.replacedInsns.get(switchinsn.default_inst);
                if (newdefault != null) {
                    switchinsn.default_inst = newdefault;
                    newdefault.labelled = true;
                }
                for (i = 0; i < switchinsn.npairs; ++i) {
                    newtgt = this.replacedInsns.get(switchinsn.match_insts[i]);
                    if (newtgt == null) continue;
                    switchinsn.match_insts[i] = newtgt;
                    newtgt.labelled = true;
                }
            } else if (insn instanceof Instruction_Tableswitch) {
                switchinsn = (Instruction_Tableswitch)insn;
                newdefault = this.replacedInsns.get(((Instruction_Tableswitch)switchinsn).default_inst);
                if (newdefault != null) {
                    ((Instruction_Tableswitch)switchinsn).default_inst = newdefault;
                    newdefault.labelled = true;
                }
                for (i = 0; i <= ((Instruction_Tableswitch)switchinsn).high - ((Instruction_Tableswitch)switchinsn).low; ++i) {
                    newtgt = this.replacedInsns.get(((Instruction_Tableswitch)switchinsn).jump_insts[i]);
                    if (newtgt == null) continue;
                    ((Instruction_Tableswitch)switchinsn).jump_insts[i] = newtgt;
                    newtgt.labelled = true;
                }
            }
            insn = insn.next;
        }
    }

    private void adjustExceptionTable() {
        Code_attribute codeAttribute = this.method.locate_code_attribute();
        for (int i = 0; i < codeAttribute.exception_table_length; ++i) {
            exception_table_entry entry = codeAttribute.exception_table[i];
            Instruction oldinsn = entry.start_inst;
            Instruction newinsn = this.replacedInsns.get(oldinsn);
            if (newinsn != null) {
                entry.start_inst = newinsn;
            }
            oldinsn = entry.end_inst;
            if (entry.end_inst != null && (newinsn = (Instruction)this.replacedInsns.get(oldinsn)) != null) {
                entry.end_inst = newinsn;
            }
            if ((newinsn = (Instruction)this.replacedInsns.get(oldinsn = entry.handler_inst)) == null) continue;
            entry.handler_inst = newinsn;
        }
    }

    private void adjustLineNumberTable() {
        attribute_info[] attributes;
        if (!Options.v().keep_line_number()) {
            return;
        }
        if (this.method.code_attr == null) {
            return;
        }
        for (attribute_info element : attributes = this.method.code_attr.attributes) {
            if (!(element instanceof LineNumberTable_attribute)) continue;
            LineNumberTable_attribute lntattr = (LineNumberTable_attribute)element;
            for (line_number_table_entry element0 : lntattr.line_number_table) {
                Instruction oldinst = element0.start_inst;
                Instruction newinst = this.replacedInsns.get(oldinst);
                if (newinst == null) continue;
                element0.start_inst = newinst;
            }
        }
    }

    private void adjustLocalVariableTable() {
        Code_attribute ca = this.method.locate_code_attribute();
        LocalVariableTable_attribute la = ca.findLocalVariableTable();
        if (la == null) {
            return;
        }
        for (local_variable_table_entry element0 : la.local_variable_table) {
            Instruction oldinst = element0.start_inst;
            Instruction newinst = this.replacedInsns.get(oldinst);
            if (newinst != null) {
                element0.start_inst = newinst;
            }
            if (element0.end_inst == null || (newinst = (Instruction)this.replacedInsns.get(oldinst = element0.end_inst)) == null) continue;
            element0.end_inst = newinst;
        }
    }

    public Instruction reconstructInstructions() {
        if (this.cfg != null) {
            return this.cfg.head;
        }
        return null;
    }

    public boolean jimplify(cp_info[] constant_pool, int this_class, BootstrapMethods_attribute bootstrap_methods_attribute, JimpleBody listBody) {
        this.bootstrap_methods_attribute = bootstrap_methods_attribute;
        Util.v().setClassNameToAbbreviation(new HashMap());
        PatchingChain<Unit> units = listBody.getUnits();
        this.listBody = listBody;
        this.units = units;
        this.instructionToFirstStmt = new HashMap<Instruction, Stmt>();
        this.instructionToLastStmt = new HashMap<Instruction, Stmt>();
        this.jmethod = listBody.getMethod();
        this.cm = Scene.v();
        ArraySet<Local> initialLocals = new ArraySet<Local>();
        List parameterTypes = this.jmethod.getParameterTypes();
        Code_attribute ca = this.method.locate_code_attribute();
        LocalVariableTable_attribute la = ca.findLocalVariableTable();
        LocalVariableTypeTable_attribute lt = ca.findLocalVariableTypeTable();
        Util.v().activeVariableTable = la;
        Util.v().activeVariableTypeTable = lt;
        Util.v().activeConstantPool = constant_pool;
        RefType thisType = RefType.v(this.jmethod.getDeclaringClass().getName());
        boolean isStatic = Modifier.isStatic(this.jmethod.getModifiers());
        int currentLocalIndex = 0;
        if (!isStatic) {
            String name;
            if (!Util.v().useFaithfulNaming || la == null) {
                name = "l0";
            } else {
                name = la.getLocalVariableName(constant_pool, currentLocalIndex);
                if (!Util.v().isValidJimpleName(name)) {
                    name = "l0";
                }
            }
            Local local = Jimple.v().newLocal(name, UnknownType.v());
            local.setIndex(0);
            listBody.getLocals().add(local);
            ++currentLocalIndex;
            units.add(Jimple.v().newIdentityStmt(local, Jimple.v().newThisRef(this.jmethod.getDeclaringClass().getType())));
        }
        Iterator typeIt = parameterTypes.iterator();
        int argCount = 0;
        while (typeIt.hasNext()) {
            String name;
            Type type = (Type)typeIt.next();
            if (!Util.v().useFaithfulNaming || la == null) {
                name = "l" + currentLocalIndex;
            } else {
                name = la.getLocalVariableName(constant_pool, currentLocalIndex);
                if (!Util.v().isValidJimpleName(name)) {
                    name = "l" + currentLocalIndex;
                }
            }
            Local local = Jimple.v().newLocal(name, UnknownType.v());
            local.setIndex(currentLocalIndex);
            initialLocals.add(local);
            listBody.getLocals().add(local);
            units.add(Jimple.v().newIdentityStmt(local, Jimple.v().newParameterRef(type, argCount)));
            currentLocalIndex = type.equals(DoubleType.v()) || type.equals(LongType.v()) ? (currentLocalIndex += 2) : ++currentLocalIndex;
            ++argCount;
        }
        Util.v().resetEasyNames();
        this.jimplify(constant_pool, this_class);
        return true;
    }

    private void buildInsnCFGfromBBCFG() {
        BasicBlock block = this.cfg;
        while (block != null) {
            Instruction insn = block.head;
            while (insn != block.tail) {
                Instruction[] succs = new Instruction[]{insn.next};
                insn.succs = succs;
                insn = insn.next;
            }
            Vector<BasicBlock> bsucc = block.succ;
            int size = bsucc.size();
            Instruction[] succs = new Instruction[size];
            for (int i = 0; i < size; ++i) {
                succs[i] = bsucc.elementAt((int)i).head;
            }
            insn.succs = succs;
            block = block.next;
        }
    }

    void jimplify(cp_info[] constant_pool, int this_class) {
        Code_attribute ca;
        LocalVariableTable_attribute la;
        Instruction ins;
        Instruction ins2;
        String name;
        Code_attribute codeAttribute = this.method.locate_code_attribute();
        ArraySet<Instruction> handlerInstructions = new ArraySet<Instruction>();
        HashMap<Instruction, SootClass> handlerInstructionToException = new HashMap<Instruction, SootClass>();
        this.buildInsnCFGfromBBCFG();
        for (int i = 0; i < codeAttribute.exception_table_length; ++i) {
            SootClass exception;
            Instruction startIns = codeAttribute.exception_table[i].start_inst;
            Instruction endIns = codeAttribute.exception_table[i].end_inst;
            Instruction handlerIns = codeAttribute.exception_table[i].handler_inst;
            handlerInstructions.add(handlerIns);
            int catchType = codeAttribute.exception_table[i].catch_type;
            if (catchType != 0) {
                CONSTANT_Class_info classinfo = (CONSTANT_Class_info)constant_pool[catchType];
                name = ((CONSTANT_Utf8_info)constant_pool[classinfo.name_index]).convert();
                name = name.replace('/', '.');
                exception = this.cm.getSootClass(name);
            } else {
                exception = this.cm.getSootClass("java.lang.Throwable");
            }
            handlerInstructionToException.put(handlerIns, exception);
            if (startIns == endIns) {
                throw new RuntimeException("Empty catch range for exception handler");
            }
            ins2 = startIns;
            do {
                Instruction[] succs = ins2.succs;
                Instruction[] newsuccs = new Instruction[succs.length + 1];
                System.arraycopy(succs, 0, newsuccs, 0, succs.length);
                newsuccs[succs.length] = handlerIns;
                ins2.succs = newsuccs;
            } while ((ins2 = ins2.next) != endIns && ins2 != null);
        }
        HashSet<Instruction> reachableInstructions = new HashSet<Instruction>();
        LinkedList<Instruction> instructionsToVisit = new LinkedList<Instruction>();
        reachableInstructions.add(this.firstInstruction);
        instructionsToVisit.addLast(this.firstInstruction);
        while (!instructionsToVisit.isEmpty()) {
            ins = (Instruction)instructionsToVisit.removeFirst();
            Instruction[] succs = ins.succs;
            for (Instruction succ : succs) {
                if (reachableInstructions.contains(succ)) continue;
                reachableInstructions.add(succ);
                instructionsToVisit.addLast(succ);
            }
        }
        HashMap<Instruction, TypeStack> instructionToTypeStack = new HashMap<Instruction, TypeStack>();
        HashMap<Instruction, TypeStack> instructionToPostTypeStack = new HashMap<Instruction, TypeStack>();
        HashSet<Instruction> visitedInstructions = new HashSet<Instruction>();
        ArrayList<Instruction> changedInstructions = new ArrayList<Instruction>();
        TypeStack initialTypeStack = TypeStack.v();
        instructionToTypeStack.put(this.firstInstruction, initialTypeStack);
        visitedInstructions.add(this.firstInstruction);
        changedInstructions.add(this.firstInstruction);
        while (!changedInstructions.isEmpty()) {
            Instruction[] successors;
            ins2 = (Instruction)changedInstructions.get(0);
            changedInstructions.remove(0);
            OutFlow ret = this.processFlow(ins2, (TypeStack)instructionToTypeStack.get(ins2), constant_pool);
            instructionToPostTypeStack.put(ins2, ret.typeStack);
            for (Instruction s : successors = ins2.succs) {
                TypeStack newTypeStack;
                if (!visitedInstructions.contains(s)) {
                    if (handlerInstructions.contains(s)) {
                        TypeStack exceptionTypeStack = TypeStack.v().push(RefType.v(((SootClass)handlerInstructionToException.get(s)).getName()));
                        instructionToTypeStack.put(s, exceptionTypeStack);
                    } else {
                        instructionToTypeStack.put(s, ret.typeStack);
                    }
                    visitedInstructions.add(s);
                    changedInstructions.add(s);
                    continue;
                }
                TypeStack oldTypeStack = (TypeStack)instructionToTypeStack.get(s);
                if (handlerInstructions.contains(s)) {
                    TypeStack exceptionTypeStack;
                    newTypeStack = exceptionTypeStack = TypeStack.v().push(RefType.v(((SootClass)handlerInstructionToException.get(s)).getName()));
                } else {
                    try {
                        newTypeStack = ret.typeStack.merge(oldTypeStack);
                    }
                    catch (RuntimeException re) {
                        G.v().out.println("Considering " + s);
                        throw re;
                    }
                }
                if (!newTypeStack.equals(oldTypeStack)) {
                    changedInstructions.add(s);
                }
                instructionToTypeStack.put(s, newTypeStack);
            }
        }
        Instruction ins3 = this.firstInstruction;
        while (ins3 != null) {
            TypeStack typeStack = (TypeStack)instructionToTypeStack.get(ins3);
            ins3 = ins3.next;
        }
        BasicBlock b = this.cfg;
        while (b != null) {
            ins = b.head;
            List<Stmt> blockStatements = b.statements = new ArrayList<Stmt>();
            while (true) {
                ArrayList<Stmt> statementsForIns = new ArrayList<Stmt>();
                if (reachableInstructions.contains(ins)) {
                    this.generateJimple(ins, (TypeStack)instructionToTypeStack.get(ins), (TypeStack)instructionToPostTypeStack.get(ins), constant_pool, statementsForIns, b);
                } else {
                    statementsForIns.add(Jimple.v().newNopStmt());
                }
                if (!statementsForIns.isEmpty()) {
                    for (int i = 0; i < statementsForIns.size(); ++i) {
                        this.units.add(statementsForIns.get(i));
                        blockStatements.add((Stmt)statementsForIns.get(i));
                    }
                    this.instructionToFirstStmt.put(ins, (Stmt)statementsForIns.get(0));
                    this.instructionToLastStmt.put(ins, (Stmt)statementsForIns.get(statementsForIns.size() - 1));
                }
                if (ins == b.tail) break;
                ins = ins.next;
            }
            b = b.next;
        }
        this.jimpleTargetFixup();
        HashMap<Stmt, Stmt> targetToHandler = new HashMap<Stmt, Stmt>();
        for (int i = 0; i < codeAttribute.exception_table_length; ++i) {
            Stmt afterEndStmt;
            Stmt newTarget;
            SootClass exception;
            Instruction startIns = codeAttribute.exception_table[i].start_inst;
            Instruction endIns = codeAttribute.exception_table[i].end_inst;
            Instruction targetIns = codeAttribute.exception_table[i].handler_inst;
            if (!this.instructionToFirstStmt.containsKey(startIns) || endIns != null && !this.instructionToLastStmt.containsKey(endIns)) {
                throw new RuntimeException("Exception range does not coincide with jimple instructions");
            }
            if (!this.instructionToFirstStmt.containsKey(targetIns)) {
                throw new RuntimeException("Exception handler does not coincide with jimple instruction");
            }
            int catchType = codeAttribute.exception_table[i].catch_type;
            if (catchType != 0) {
                CONSTANT_Class_info classinfo = (CONSTANT_Class_info)constant_pool[catchType];
                String name2 = ((CONSTANT_Utf8_info)constant_pool[classinfo.name_index]).convert();
                name2 = name2.replace('/', '.');
                exception = this.cm.getSootClass(name2);
            } else {
                exception = this.cm.getSootClass("java.lang.Throwable");
            }
            Stmt firstTargetStmt = this.instructionToFirstStmt.get(targetIns);
            if (targetToHandler.containsKey(firstTargetStmt)) {
                newTarget = (Stmt)targetToHandler.get(firstTargetStmt);
            } else {
                Unit prev;
                Local local = Util.v().getLocalCreatingIfNecessary(this.listBody, "$stack0", UnknownType.v());
                newTarget = Jimple.v().newIdentityStmt(local, Jimple.v().newCaughtExceptionRef());
                ((PatchingChain)this.units).insertBeforeNoRedirect(newTarget, firstTargetStmt);
                targetToHandler.put(firstTargetStmt, newTarget);
                if (this.units.getFirst() != newTarget && (prev = (Unit)this.units.getPredOf(newTarget)) != null && prev.fallsThrough()) {
                    this.units.insertAfter(Jimple.v().newGotoStmt(firstTargetStmt), prev);
                }
            }
            Stmt firstStmt = this.instructionToFirstStmt.get(startIns);
            if (endIns == null) {
                afterEndStmt = (Stmt)this.units.getLast();
            } else {
                afterEndStmt = this.instructionToLastStmt.get(endIns);
                IdentityStmt catchStart = (IdentityStmt)targetToHandler.get(afterEndStmt);
                if (catchStart != null) {
                    if (catchStart != this.units.getPredOf(afterEndStmt)) {
                        throw new IllegalStateException("Assertion failure: catchStart != pred of afterEndStmt");
                    }
                    afterEndStmt = catchStart;
                }
            }
            Trap trap = Jimple.v().newTrap(exception, firstStmt, afterEndStmt, newTarget);
            this.listBody.getTraps().add(trap);
        }
        if (Options.v().keep_line_number()) {
            HashMap<Stmt, Tag> stmtstags = new HashMap<Stmt, Tag>();
            LinkedList<Stmt> startstmts = new LinkedList<Stmt>();
            attribute_info[] attrs = codeAttribute.attributes;
            for (attribute_info element : attrs) {
                if (!(element instanceof LineNumberTable_attribute)) continue;
                LineNumberTable_attribute lntattr = (LineNumberTable_attribute)element;
                for (line_number_table_entry element0 : lntattr.line_number_table) {
                    Stmt start_stmt = this.instructionToFirstStmt.get(element0.start_inst);
                    if (start_stmt == null) continue;
                    LineNumberTag lntag = new LineNumberTag(element0.line_number);
                    stmtstags.put(start_stmt, lntag);
                    startstmts.add(start_stmt);
                }
            }
            Iterator stmtIt = new ArrayList(stmtstags.keySet()).iterator();
            while (stmtIt.hasNext()) {
                Stmt stmt;
                Stmt pred = stmt = (Stmt)stmtIt.next();
                Tag tag = (Tag)stmtstags.get(stmt);
                while ((pred = this.units.getPredOf(pred)) != null && pred instanceof IdentityStmt) {
                    stmtstags.put(pred, tag);
                    pred.addTag(tag);
                }
            }
            for (int i = 0; i < startstmts.size(); ++i) {
                Stmt stmt = (Stmt)startstmts.get(i);
                Tag tag = (Tag)stmtstags.get(stmt);
                stmt.addTag(tag);
                stmt = this.units.getSuccOf(stmt);
                while (stmt != null && !stmtstags.containsKey(stmt)) {
                    stmt.addTag(tag);
                    stmt = this.units.getSuccOf(stmt);
                }
            }
        }
        if ((la = (ca = this.method.locate_code_attribute()).findLocalVariableTable()) != null) {
            for (local_variable_table_entry entry : la.local_variable_table) {
                if (!(constant_pool[entry.name_index] instanceof CONSTANT_Utf8_info)) {
                    throw new RuntimeException("What? A local variable table name_index isn't a UTF8 entry?");
                }
                name = ((CONSTANT_Utf8_info)constant_pool[entry.name_index]).convert();
                Stmt startStmt = this.instructionToFirstStmt.get(entry.start_inst);
                Stmt endStmt = null;
                if (entry.end_inst != null) {
                    endStmt = this.instructionToFirstStmt.get(entry.end_inst);
                }
                LocalVariable lv = new LocalVariable(name, entry.index, startStmt, endStmt, ((CONSTANT_Utf8_info)constant_pool[entry.descriptor_index]).convert());
                this.listBody.getLocalVariables().add(lv);
            }
        }
    }

    private Type byteCodeTypeOf(Type type) {
        if (type.equals(ShortType.v()) || type.equals(CharType.v()) || type.equals(ByteType.v()) || type.equals(BooleanType.v())) {
            return IntType.v();
        }
        return type;
    }

    OutFlow processFlow(Instruction ins, TypeStack typeStack, cp_info[] constant_pool) {
        int x = ins.code & 0xFF;
        switch (x) {
            case 16: {
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 17: {
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 18: {
                return this.processCPEntry(constant_pool, ((Instruction_Ldc1)ins).arg_b, typeStack, this.jmethod);
            }
            case 19: 
            case 20: {
                return this.processCPEntry(constant_pool, ((Instruction_intindex)ins).arg_i, typeStack, this.jmethod);
            }
            case 1: {
                typeStack = typeStack.push(RefType.v("java.lang.Object"));
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 9: 
            case 10: {
                typeStack = typeStack.push(LongType.v());
                typeStack = typeStack.push(Long2ndHalfType.v());
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                typeStack = typeStack.push(FloatType.v());
                break;
            }
            case 14: 
            case 15: {
                typeStack = typeStack.push(DoubleType.v());
                typeStack = typeStack.push(Double2ndHalfType.v());
                break;
            }
            case 21: {
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 23: {
                typeStack = typeStack.push(FloatType.v());
                break;
            }
            case 25: {
                typeStack = typeStack.push(RefType.v("java.lang.Object"));
                break;
            }
            case 24: {
                typeStack = typeStack.push(DoubleType.v());
                typeStack = typeStack.push(Double2ndHalfType.v());
                break;
            }
            case 22: {
                typeStack = typeStack.push(LongType.v());
                typeStack = typeStack.push(Long2ndHalfType.v());
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                typeStack = typeStack.push(FloatType.v());
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                typeStack = typeStack.push(RefType.v("java.lang.Object"));
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                typeStack = typeStack.push(LongType.v());
                typeStack = typeStack.push(Long2ndHalfType.v());
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                typeStack = typeStack.push(DoubleType.v());
                typeStack = typeStack.push(Double2ndHalfType.v());
                break;
            }
            case 54: {
                typeStack = this.popSafe(typeStack, IntType.v());
                break;
            }
            case 56: {
                typeStack = this.popSafe(typeStack, FloatType.v());
                break;
            }
            case 58: {
                typeStack = typeStack.pop();
                break;
            }
            case 55: {
                typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                typeStack = this.popSafe(typeStack, LongType.v());
                break;
            }
            case 57: {
                typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                typeStack = this.popSafe(typeStack, DoubleType.v());
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                typeStack = this.popSafe(typeStack, IntType.v());
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                typeStack = this.popSafe(typeStack, FloatType.v());
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                if (!(typeStack.top() instanceof StmtAddressType || typeStack.top() instanceof RefType || typeStack.top() instanceof ArrayType)) {
                    throw new RuntimeException("Astore failed, invalid stack type: " + typeStack.top());
                }
                typeStack = typeStack.pop();
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                typeStack = this.popSafe(typeStack, LongType.v());
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                typeStack = this.popSafe(typeStack, DoubleType.v());
                break;
            }
            case 132: {
                break;
            }
            case 196: {
                throw new RuntimeException("Wide instruction should not be encountered");
            }
            case 188: {
                typeStack = this.popSafe(typeStack, IntType.v());
                Type baseType = this.jimpleTypeOfAtype(((Instruction_Newarray)ins).atype);
                typeStack = typeStack.push(ArrayType.v(baseType, 1));
                break;
            }
            case 189: {
                Type baseType;
                CONSTANT_Class_info c = (CONSTANT_Class_info)constant_pool[((Instruction_Anewarray)ins).arg_i];
                String name = ((CONSTANT_Utf8_info)constant_pool[c.name_index]).convert();
                name = name.replace('/', '.');
                if (name.startsWith("[")) {
                    String baseName = this.getClassName(constant_pool, ((Instruction_Anewarray)ins).arg_i);
                    baseType = Util.v().jimpleTypeOfFieldDescriptor(baseName);
                } else {
                    baseType = RefType.v(name);
                }
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = typeStack.push(baseType.makeArrayType());
                break;
            }
            case 197: {
                int bdims = ((Instruction_Multianewarray)ins).dims;
                CONSTANT_Class_info c = (CONSTANT_Class_info)constant_pool[((Instruction_Multianewarray)ins).arg_i];
                String arrayDescriptor = ((CONSTANT_Utf8_info)constant_pool[c.name_index]).convert();
                ArrayType arrayType = (ArrayType)Util.v().jimpleTypeOfFieldDescriptor(arrayDescriptor);
                for (int j = 0; j < bdims; ++j) {
                    typeStack = this.popSafe(typeStack, IntType.v());
                }
                typeStack = typeStack.push(arrayType);
                break;
            }
            case 190: {
                typeStack = this.popSafeRefType(typeStack);
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = this.popSafeRefType(typeStack);
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 48: {
                typeStack = this.popSafe(typeStack, FloatType.v());
                typeStack = this.popSafeRefType(typeStack);
                typeStack = typeStack.push(FloatType.v());
                break;
            }
            case 50: {
                typeStack = this.popSafe(typeStack, IntType.v());
                if (typeStack.top() instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)typeStack.top();
                    typeStack = this.popSafeRefType(typeStack);
                    if (arrayType.numDimensions == 1) {
                        typeStack = typeStack.push(arrayType.baseType);
                        break;
                    }
                    typeStack = typeStack.push(ArrayType.v(arrayType.baseType, arrayType.numDimensions - 1));
                    break;
                }
                typeStack = this.popSafeRefType(typeStack);
                typeStack = typeStack.push(RefType.v("java.lang.Object"));
                break;
            }
            case 47: {
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = this.popSafeRefType(typeStack);
                typeStack = typeStack.push(LongType.v());
                typeStack = typeStack.push(Long2ndHalfType.v());
                break;
            }
            case 49: {
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = this.popSafeRefType(typeStack);
                typeStack = typeStack.push(DoubleType.v());
                typeStack = typeStack.push(Double2ndHalfType.v());
                break;
            }
            case 79: 
            case 84: 
            case 85: 
            case 86: {
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = this.popSafeRefType(typeStack);
                break;
            }
            case 83: {
                typeStack = this.popSafeRefType(typeStack);
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = this.popSafeRefType(typeStack);
                break;
            }
            case 81: {
                typeStack = this.popSafe(typeStack, FloatType.v());
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = this.popSafeRefType(typeStack);
                break;
            }
            case 80: {
                typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                typeStack = this.popSafe(typeStack, LongType.v());
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = this.popSafeRefType(typeStack);
                break;
            }
            case 82: {
                typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                typeStack = this.popSafe(typeStack, DoubleType.v());
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = this.popSafeRefType(typeStack);
                break;
            }
            case 0: {
                break;
            }
            case 87: {
                typeStack = typeStack.pop();
                break;
            }
            case 88: {
                typeStack = typeStack.pop();
                typeStack = typeStack.pop();
                break;
            }
            case 89: {
                typeStack = typeStack.push(typeStack.top());
                break;
            }
            case 92: {
                Type topType = typeStack.get(typeStack.topIndex());
                Type secondType = typeStack.get(typeStack.topIndex() - 1);
                typeStack = typeStack.push(secondType).push(topType);
                break;
            }
            case 90: {
                Type topType = typeStack.get(typeStack.topIndex());
                Type secondType = typeStack.get(typeStack.topIndex() - 1);
                typeStack = typeStack.pop().pop();
                typeStack = typeStack.push(topType).push(secondType).push(topType);
                break;
            }
            case 91: {
                Type topType = typeStack.get(typeStack.topIndex());
                Type secondType = typeStack.get(typeStack.topIndex() - 1);
                Type thirdType = typeStack.get(typeStack.topIndex() - 2);
                typeStack = typeStack.pop().pop().pop();
                typeStack = typeStack.push(topType).push(thirdType).push(secondType).push(topType);
                break;
            }
            case 93: {
                Type topType = typeStack.get(typeStack.topIndex());
                Type secondType = typeStack.get(typeStack.topIndex() - 1);
                Type thirdType = typeStack.get(typeStack.topIndex() - 2);
                typeStack = typeStack.pop().pop().pop();
                typeStack = typeStack.push(secondType).push(topType).push(thirdType).push(secondType).push(topType);
                break;
            }
            case 94: {
                Type topType = typeStack.get(typeStack.topIndex());
                Type secondType = typeStack.get(typeStack.topIndex() - 1);
                Type thirdType = typeStack.get(typeStack.topIndex() - 2);
                Type fourthType = typeStack.get(typeStack.topIndex() - 3);
                typeStack = typeStack.pop().pop().pop().pop();
                typeStack = typeStack.push(secondType).push(topType).push(fourthType).push(thirdType).push(secondType).push(topType);
                break;
            }
            case 95: {
                Type topType = typeStack.top();
                typeStack = typeStack.pop();
                Type secondType = typeStack.top();
                typeStack = typeStack.pop();
                typeStack = typeStack.push(topType);
                typeStack = typeStack.push(secondType);
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                typeStack = this.popSafe(typeStack, LongType.v());
                typeStack = typeStack.push(LongType.v());
                typeStack = typeStack.push(Long2ndHalfType.v());
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                typeStack = this.popSafe(typeStack, LongType.v());
                typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                typeStack = this.popSafe(typeStack, LongType.v());
                typeStack = typeStack.push(LongType.v());
                typeStack = typeStack.push(Long2ndHalfType.v());
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                typeStack = this.popSafe(typeStack, FloatType.v());
                typeStack = this.popSafe(typeStack, FloatType.v());
                typeStack = typeStack.push(FloatType.v());
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                typeStack = this.popSafe(typeStack, DoubleType.v());
                typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                typeStack = this.popSafe(typeStack, DoubleType.v());
                typeStack = typeStack.push(DoubleType.v());
                typeStack = typeStack.push(Double2ndHalfType.v());
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                break;
            }
            case 133: {
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = typeStack.push(LongType.v());
                typeStack = typeStack.push(Long2ndHalfType.v());
                break;
            }
            case 134: {
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = typeStack.push(FloatType.v());
                break;
            }
            case 135: {
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = typeStack.push(DoubleType.v());
                typeStack = typeStack.push(Double2ndHalfType.v());
                break;
            }
            case 136: {
                typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                typeStack = this.popSafe(typeStack, LongType.v());
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 137: {
                typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                typeStack = this.popSafe(typeStack, LongType.v());
                typeStack = typeStack.push(FloatType.v());
                break;
            }
            case 138: {
                typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                typeStack = this.popSafe(typeStack, LongType.v());
                typeStack = typeStack.push(DoubleType.v());
                typeStack = typeStack.push(Double2ndHalfType.v());
                break;
            }
            case 139: {
                typeStack = this.popSafe(typeStack, FloatType.v());
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 140: {
                typeStack = this.popSafe(typeStack, FloatType.v());
                typeStack = typeStack.push(LongType.v());
                typeStack = typeStack.push(Long2ndHalfType.v());
                break;
            }
            case 141: {
                typeStack = this.popSafe(typeStack, FloatType.v());
                typeStack = typeStack.push(DoubleType.v());
                typeStack = typeStack.push(Double2ndHalfType.v());
                break;
            }
            case 142: {
                typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                typeStack = this.popSafe(typeStack, DoubleType.v());
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 143: {
                typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                typeStack = this.popSafe(typeStack, DoubleType.v());
                typeStack = typeStack.push(LongType.v());
                typeStack = typeStack.push(Long2ndHalfType.v());
                break;
            }
            case 144: {
                typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                typeStack = this.popSafe(typeStack, DoubleType.v());
                typeStack = typeStack.push(FloatType.v());
                break;
            }
            case 145: {
                break;
            }
            case 146: {
                break;
            }
            case 147: {
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                typeStack = this.popSafe(typeStack, IntType.v());
                break;
            }
            case 198: 
            case 199: {
                typeStack = this.popSafeRefType(typeStack);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                typeStack = this.popSafe(typeStack, IntType.v());
                typeStack = this.popSafe(typeStack, IntType.v());
                break;
            }
            case 148: {
                typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                typeStack = this.popSafe(typeStack, LongType.v());
                typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                typeStack = this.popSafe(typeStack, LongType.v());
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 149: 
            case 150: {
                typeStack = this.popSafe(typeStack, FloatType.v());
                typeStack = this.popSafe(typeStack, FloatType.v());
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 151: 
            case 152: {
                typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                typeStack = this.popSafe(typeStack, DoubleType.v());
                typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                typeStack = this.popSafe(typeStack, DoubleType.v());
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 165: 
            case 166: {
                typeStack = this.popSafeRefType(typeStack);
                typeStack = this.popSafeRefType(typeStack);
                break;
            }
            case 167: 
            case 200: {
                break;
            }
            case 168: 
            case 201: {
                typeStack = typeStack.push(StmtAddressType.v());
                break;
            }
            case 169: {
                break;
            }
            case 209: {
                break;
            }
            case 177: {
                break;
            }
            case 172: {
                typeStack = this.popSafe(typeStack, IntType.v());
                break;
            }
            case 174: {
                typeStack = this.popSafe(typeStack, FloatType.v());
                break;
            }
            case 176: {
                typeStack = this.popSafeRefType(typeStack);
                break;
            }
            case 175: {
                typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                typeStack = this.popSafe(typeStack, DoubleType.v());
                break;
            }
            case 173: {
                typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                typeStack = this.popSafe(typeStack, LongType.v());
                break;
            }
            case 202: {
                break;
            }
            case 170: {
                typeStack = this.popSafe(typeStack, IntType.v());
                break;
            }
            case 171: {
                typeStack = this.popSafe(typeStack, IntType.v());
                break;
            }
            case 181: {
                Type type = this.byteCodeTypeOf(this.jimpleTypeOfFieldInFieldRef(this.cm, constant_pool, ((Instruction_Putfield)ins).arg_i));
                if (type.equals(DoubleType.v())) {
                    typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                    typeStack = this.popSafe(typeStack, DoubleType.v());
                } else if (type.equals(LongType.v())) {
                    typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                    typeStack = this.popSafe(typeStack, LongType.v());
                } else {
                    typeStack = type instanceof RefType ? this.popSafeRefType(typeStack) : this.popSafe(typeStack, type);
                }
                typeStack = this.popSafeRefType(typeStack);
                break;
            }
            case 180: {
                Type type = this.byteCodeTypeOf(this.jimpleTypeOfFieldInFieldRef(this.cm, constant_pool, ((Instruction_Getfield)ins).arg_i));
                typeStack = this.popSafeRefType(typeStack);
                if (type.equals(DoubleType.v())) {
                    typeStack = typeStack.push(DoubleType.v());
                    typeStack = typeStack.push(Double2ndHalfType.v());
                    break;
                }
                if (type.equals(LongType.v())) {
                    typeStack = typeStack.push(LongType.v());
                    typeStack = typeStack.push(Long2ndHalfType.v());
                    break;
                }
                typeStack = typeStack.push(type);
                break;
            }
            case 179: {
                Type type = this.byteCodeTypeOf(this.jimpleTypeOfFieldInFieldRef(this.cm, constant_pool, ((Instruction_Putstatic)ins).arg_i));
                if (type.equals(DoubleType.v())) {
                    typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                    typeStack = this.popSafe(typeStack, DoubleType.v());
                    break;
                }
                if (type.equals(LongType.v())) {
                    typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                    typeStack = this.popSafe(typeStack, LongType.v());
                    break;
                }
                if (type instanceof RefType) {
                    typeStack = this.popSafeRefType(typeStack);
                    break;
                }
                typeStack = this.popSafe(typeStack, type);
                break;
            }
            case 178: {
                Type type = this.byteCodeTypeOf(this.jimpleTypeOfFieldInFieldRef(this.cm, constant_pool, ((Instruction_Getstatic)ins).arg_i));
                if (type.equals(DoubleType.v())) {
                    typeStack = typeStack.push(DoubleType.v());
                    typeStack = typeStack.push(Double2ndHalfType.v());
                    break;
                }
                if (type.equals(LongType.v())) {
                    typeStack = typeStack.push(LongType.v());
                    typeStack = typeStack.push(Long2ndHalfType.v());
                    break;
                }
                typeStack = typeStack.push(type);
                break;
            }
            case 186: {
                Instruction_Invokedynamic iv = (Instruction_Invokedynamic)ins;
                CONSTANT_InvokeDynamic_info iv_info = (CONSTANT_InvokeDynamic_info)constant_pool[iv.invoke_dynamic_index];
                int args = cp_info.countParams(constant_pool, iv_info.name_and_type_index);
                Type returnType = this.byteCodeTypeOf(this.jimpleReturnTypeOfNameAndType(this.cm, constant_pool, iv_info.name_and_type_index));
                for (int j = args - 1; j >= 0; --j) {
                    if (typeStack.top().equals(Long2ndHalfType.v())) {
                        typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                        typeStack = this.popSafe(typeStack, LongType.v());
                        continue;
                    }
                    if (typeStack.top().equals(Double2ndHalfType.v())) {
                        typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                        typeStack = this.popSafe(typeStack, DoubleType.v());
                        continue;
                    }
                    typeStack = this.popSafe(typeStack, typeStack.top());
                }
                if (returnType.equals(VoidType.v())) break;
                typeStack = this.smartPush(typeStack, returnType);
                break;
            }
            case 182: {
                Instruction_Invokevirtual iv = (Instruction_Invokevirtual)ins;
                int args = cp_info.countParams(constant_pool, iv.arg_i);
                Type returnType = this.byteCodeTypeOf(this.jimpleReturnTypeOfMethodRef(this.cm, constant_pool, iv.arg_i));
                for (int j = args - 1; j >= 0; --j) {
                    if (typeStack.top().equals(Long2ndHalfType.v())) {
                        typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                        typeStack = this.popSafe(typeStack, LongType.v());
                        continue;
                    }
                    if (typeStack.top().equals(Double2ndHalfType.v())) {
                        typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                        typeStack = this.popSafe(typeStack, DoubleType.v());
                        continue;
                    }
                    typeStack = this.popSafe(typeStack, typeStack.top());
                }
                typeStack = this.popSafeRefType(typeStack);
                if (returnType.equals(VoidType.v())) break;
                typeStack = this.smartPush(typeStack, returnType);
                break;
            }
            case 183: {
                Instruction_Invokenonvirtual iv = (Instruction_Invokenonvirtual)ins;
                int args = cp_info.countParams(constant_pool, iv.arg_i);
                Type returnType = this.byteCodeTypeOf(this.jimpleReturnTypeOfMethodRef(this.cm, constant_pool, iv.arg_i));
                for (int j = args - 1; j >= 0; --j) {
                    if (typeStack.top().equals(Long2ndHalfType.v())) {
                        typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                        typeStack = this.popSafe(typeStack, LongType.v());
                        continue;
                    }
                    if (typeStack.top().equals(Double2ndHalfType.v())) {
                        typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                        typeStack = this.popSafe(typeStack, DoubleType.v());
                        continue;
                    }
                    typeStack = this.popSafe(typeStack, typeStack.top());
                }
                typeStack = this.popSafeRefType(typeStack);
                if (returnType.equals(VoidType.v())) break;
                typeStack = this.smartPush(typeStack, returnType);
                break;
            }
            case 184: {
                Instruction_Invokestatic iv = (Instruction_Invokestatic)ins;
                int args = cp_info.countParams(constant_pool, iv.arg_i);
                Type returnType = this.byteCodeTypeOf(this.jimpleReturnTypeOfMethodRef(this.cm, constant_pool, iv.arg_i));
                for (int j = args - 1; j >= 0; --j) {
                    if (typeStack.top().equals(Long2ndHalfType.v())) {
                        typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                        typeStack = this.popSafe(typeStack, LongType.v());
                        continue;
                    }
                    if (typeStack.top().equals(Double2ndHalfType.v())) {
                        typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                        typeStack = this.popSafe(typeStack, DoubleType.v());
                        continue;
                    }
                    typeStack = this.popSafe(typeStack, typeStack.top());
                }
                if (returnType.equals(VoidType.v())) break;
                typeStack = this.smartPush(typeStack, returnType);
                break;
            }
            case 185: {
                Instruction_Invokeinterface iv = (Instruction_Invokeinterface)ins;
                int args = cp_info.countParams(constant_pool, iv.arg_i);
                Type returnType = this.byteCodeTypeOf(this.jimpleReturnTypeOfInterfaceMethodRef(this.cm, constant_pool, iv.arg_i));
                for (int j = args - 1; j >= 0; --j) {
                    if (typeStack.top().equals(Long2ndHalfType.v())) {
                        typeStack = this.popSafe(typeStack, Long2ndHalfType.v());
                        typeStack = this.popSafe(typeStack, LongType.v());
                        continue;
                    }
                    if (typeStack.top().equals(Double2ndHalfType.v())) {
                        typeStack = this.popSafe(typeStack, Double2ndHalfType.v());
                        typeStack = this.popSafe(typeStack, DoubleType.v());
                        continue;
                    }
                    typeStack = this.popSafe(typeStack, typeStack.top());
                }
                typeStack = this.popSafeRefType(typeStack);
                if (returnType.equals(VoidType.v())) break;
                typeStack = this.smartPush(typeStack, returnType);
                break;
            }
            case 191: {
                break;
            }
            case 187: {
                RefType type = RefType.v(this.getClassName(constant_pool, ((Instruction_New)ins).arg_i));
                typeStack = typeStack.push(type);
                break;
            }
            case 192: {
                String className = this.getClassName(constant_pool, ((Instruction_Checkcast)ins).arg_i);
                Type castType = className.startsWith("[") ? Util.v().jimpleTypeOfFieldDescriptor(this.getClassName(constant_pool, ((Instruction_Checkcast)ins).arg_i)) : RefType.v(className);
                typeStack = this.popSafeRefType(typeStack);
                typeStack = typeStack.push(castType);
                break;
            }
            case 193: {
                typeStack = this.popSafeRefType(typeStack);
                typeStack = typeStack.push(IntType.v());
                break;
            }
            case 194: {
                typeStack = this.popSafeRefType(typeStack);
                break;
            }
            case 195: {
                typeStack = this.popSafeRefType(typeStack);
                break;
            }
            default: {
                throw new RuntimeException("processFlow failed: Unknown bytecode instruction: " + x);
            }
        }
        return new OutFlow(typeStack);
    }

    private Type jimpleTypeOfFieldInFieldRef(Scene cm, cp_info[] constant_pool, int index) {
        CONSTANT_Fieldref_info fr = (CONSTANT_Fieldref_info)constant_pool[index];
        CONSTANT_NameAndType_info nat = (CONSTANT_NameAndType_info)constant_pool[fr.name_and_type_index];
        String fieldDescriptor = ((CONSTANT_Utf8_info)constant_pool[nat.descriptor_index]).convert();
        return Util.v().jimpleTypeOfFieldDescriptor(fieldDescriptor);
    }

    private Type jimpleReturnTypeOfNameAndType(Scene cm, cp_info[] constant_pool, int index) {
        CONSTANT_NameAndType_info nat = (CONSTANT_NameAndType_info)constant_pool[index];
        String methodDescriptor = ((CONSTANT_Utf8_info)constant_pool[nat.descriptor_index]).convert();
        return Util.v().jimpleReturnTypeOfMethodDescriptor(methodDescriptor);
    }

    private Type jimpleReturnTypeOfMethodRef(Scene cm, cp_info[] constant_pool, int index) {
        ICONSTANT_Methodref_info mr = (ICONSTANT_Methodref_info)((Object)constant_pool[index]);
        CONSTANT_NameAndType_info nat = (CONSTANT_NameAndType_info)constant_pool[mr.getNameAndTypeIndex()];
        String methodDescriptor = ((CONSTANT_Utf8_info)constant_pool[nat.descriptor_index]).convert();
        return Util.v().jimpleReturnTypeOfMethodDescriptor(methodDescriptor);
    }

    private Type jimpleReturnTypeOfInterfaceMethodRef(Scene cm, cp_info[] constant_pool, int index) {
        CONSTANT_InterfaceMethodref_info mr = (CONSTANT_InterfaceMethodref_info)constant_pool[index];
        CONSTANT_NameAndType_info nat = (CONSTANT_NameAndType_info)constant_pool[mr.name_and_type_index];
        String methodDescriptor = ((CONSTANT_Utf8_info)constant_pool[nat.descriptor_index]).convert();
        return Util.v().jimpleReturnTypeOfMethodDescriptor(methodDescriptor);
    }

    private OutFlow processCPEntry(cp_info[] constant_pool, int i, TypeStack typeStack, SootMethod jmethod) {
        cp_info c = constant_pool[i];
        if (c instanceof CONSTANT_Integer_info) {
            typeStack = typeStack.push(IntType.v());
        } else if (c instanceof CONSTANT_Float_info) {
            typeStack = typeStack.push(FloatType.v());
        } else if (c instanceof CONSTANT_Long_info) {
            typeStack = typeStack.push(LongType.v());
            typeStack = typeStack.push(Long2ndHalfType.v());
        } else if (c instanceof CONSTANT_Double_info) {
            typeStack = typeStack.push(DoubleType.v());
            typeStack = typeStack.push(Double2ndHalfType.v());
        } else if (c instanceof CONSTANT_String_info) {
            typeStack = typeStack.push(RefType.v("java.lang.String"));
        } else if (c instanceof CONSTANT_Utf8_info) {
            typeStack = typeStack.push(RefType.v("java.lang.String"));
        } else if (c instanceof CONSTANT_Class_info) {
            CONSTANT_Class_info info = (CONSTANT_Class_info)c;
            String name = ((CONSTANT_Utf8_info)constant_pool[info.name_index]).convert();
            if ((name = name.replace('/', '.')).charAt(0) == '[') {
                int dim = 0;
                while (name.charAt(dim) == '[') {
                    ++dim;
                }
                Type baseType = null;
                char typeIndicator = name.charAt(dim);
                switch (typeIndicator) {
                    case 'I': {
                        baseType = IntType.v();
                        break;
                    }
                    case 'C': {
                        baseType = CharType.v();
                        break;
                    }
                    case 'F': {
                        baseType = FloatType.v();
                        break;
                    }
                    case 'D': {
                        baseType = DoubleType.v();
                        break;
                    }
                    case 'B': {
                        baseType = ByteType.v();
                        break;
                    }
                    case 'S': {
                        baseType = ShortType.v();
                        break;
                    }
                    case 'Z': {
                        baseType = BooleanType.v();
                        break;
                    }
                    case 'J': {
                        baseType = LongType.v();
                        break;
                    }
                    case 'L': {
                        baseType = RefType.v(name.substring(dim + 1, name.length() - 1));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown Array Base Type in Class Constant");
                    }
                }
                typeStack = typeStack.push(ArrayType.v(baseType, dim));
            } else {
                typeStack = typeStack.push(RefType.v(name));
            }
        } else {
            throw new RuntimeException("Attempting to push a non-constant cp entry" + c.getClass());
        }
        return new OutFlow(typeStack);
    }

    TypeStack smartPush(TypeStack typeStack, Type type) {
        if (type.equals(LongType.v())) {
            typeStack = typeStack.push(LongType.v());
            typeStack = typeStack.push(Long2ndHalfType.v());
        } else if (type.equals(DoubleType.v())) {
            typeStack = typeStack.push(DoubleType.v());
            typeStack = typeStack.push(Double2ndHalfType.v());
        } else {
            typeStack = typeStack.push(type);
        }
        return typeStack;
    }

    TypeStack popSafeRefType(TypeStack typeStack) {
        return typeStack.pop();
    }

    TypeStack popSafeArrayType(TypeStack typeStack) {
        return typeStack.pop();
    }

    TypeStack popSafe(TypeStack typeStack, Type requiredType) {
        return typeStack.pop();
    }

    void confirmType(Type actualType, Type requiredType) {
    }

    String getClassName(cp_info[] constant_pool, int index) {
        CONSTANT_Class_info c = (CONSTANT_Class_info)constant_pool[index];
        String name = ((CONSTANT_Utf8_info)constant_pool[c.name_index]).convert();
        return name.replace('/', '.');
    }

    void confirmRefType(Type actualType) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTargetFixup(BBQ bbq) {
        block2: while (true) {
            BasicBlock p;
            BasicBlock b;
            block17: {
                BasicBlock basicBlock;
                LookupSwitchStmt sls;
                int count;
                Iterator<BasicBlock> i$;
                block21: {
                    TableSwitchStmt sts;
                    int count2;
                    block20: {
                        Stmt s;
                        block19: {
                            block18: {
                                if (bbq.isEmpty()) return;
                                try {
                                    b = bbq.pull();
                                }
                                catch (NoSuchElementException e) {
                                    return;
                                }
                                s = b.getTailJStmt();
                                if (s instanceof GotoStmt) {
                                    if (b.succ.size() == 1) {
                                        ((GotoStmt)s).setTarget(b.succ.firstElement().getHeadJStmt());
                                        break block17;
                                    } else {
                                        G.v().out.println("Error :");
                                        int i = 0;
                                        while (i < b.statements.size()) {
                                            G.v().out.println(b.statements.get(i));
                                            ++i;
                                        }
                                        throw new RuntimeException(b + " has " + b.succ.size() + " successors.");
                                    }
                                }
                                if (!(s instanceof IfStmt)) break block18;
                                if (b.succ.size() != 2) {
                                    G.v().out.println("How can an if not have 2 successors?");
                                }
                                if (b.succ.firstElement() == b.next) {
                                    ((IfStmt)s).setTarget(b.succ.elementAt(1).getHeadJStmt());
                                    break block17;
                                } else {
                                    ((IfStmt)s).setTarget(b.succ.firstElement().getHeadJStmt());
                                }
                                break block17;
                            }
                            if (!(s instanceof TableSwitchStmt)) break block19;
                            count2 = 0;
                            sts = (TableSwitchStmt)s;
                            i$ = b.succ.iterator();
                            break block20;
                        }
                        if (!(s instanceof LookupSwitchStmt)) break block17;
                        count = 0;
                        sls = (LookupSwitchStmt)s;
                        i$ = b.succ.iterator();
                        break block21;
                    }
                    while (i$.hasNext()) {
                        p = basicBlock = i$.next();
                        if (count2 == 0) {
                            sts.setDefaultTarget(p.getHeadJStmt());
                        } else {
                            sts.setTarget(count2 - 1, p.getHeadJStmt());
                        }
                        ++count2;
                    }
                    break block17;
                }
                while (i$.hasNext()) {
                    p = basicBlock = i$.next();
                    if (count == 0) {
                        sls.setDefaultTarget(p.getHeadJStmt());
                    } else {
                        sls.setTarget(count - 1, p.getHeadJStmt());
                    }
                    ++count;
                }
            }
            b.done = false;
            Iterator<BasicBlock> i$ = b.succ.iterator();
            while (true) {
                BasicBlock basicBlock;
                if (!i$.hasNext()) continue block2;
                p = basicBlock = i$.next();
                if (!p.done) continue;
                bbq.push(p);
            }
            break;
        }
    }

    void jimpleTargetFixup() {
        BBQ bbq = new BBQ();
        Code_attribute c = this.method.locate_code_attribute();
        if (c == null) {
            return;
        }
        BasicBlock bb = this.cfg;
        while (bb != null) {
            bb.done = true;
            bb = bb.next;
        }
        bbq.push(this.cfg);
        this.processTargetFixup(bbq);
        if (bbq.isEmpty()) {
            for (int i = 0; i < c.exception_table_length; ++i) {
                BasicBlock b = c.exception_table[i].b;
                if (b == null || !b.done) continue;
                bbq.push(b);
                this.processTargetFixup(bbq);
                if (bbq.isEmpty()) continue;
                G.v().out.println("Error 2nd processing exception block.");
                break;
            }
        }
    }

    private void generateJimpleForCPEntry(cp_info[] constant_pool, int i, TypeStack typeStack, TypeStack postTypeStack, SootMethod jmethod, List<Stmt> statements) {
        AssignStmt stmt;
        cp_info c = constant_pool[i];
        if (c instanceof CONSTANT_Integer_info) {
            CONSTANT_Integer_info ci = (CONSTANT_Integer_info)c;
            IntConstant rvalue = IntConstant.v((int)ci.bytes);
            stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
        } else if (c instanceof CONSTANT_Float_info) {
            CONSTANT_Float_info cf = (CONSTANT_Float_info)c;
            FloatConstant rvalue = FloatConstant.v(cf.convert());
            stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
        } else if (c instanceof CONSTANT_Long_info) {
            CONSTANT_Long_info cl = (CONSTANT_Long_info)c;
            LongConstant rvalue = LongConstant.v(cl.convert());
            stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
        } else if (c instanceof CONSTANT_Double_info) {
            CONSTANT_Double_info cd = (CONSTANT_Double_info)c;
            DoubleConstant rvalue = DoubleConstant.v(cd.convert());
            stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
        } else if (c instanceof CONSTANT_String_info) {
            CONSTANT_String_info cs = (CONSTANT_String_info)c;
            String constant = cs.toString(constant_pool);
            if (constant.startsWith("\"") && constant.endsWith("\"")) {
                constant = constant.substring(1, constant.length() - 1);
            }
            StringConstant rvalue = StringConstant.v(constant);
            stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
        } else if (c instanceof CONSTANT_Utf8_info) {
            CONSTANT_Utf8_info cu = (CONSTANT_Utf8_info)c;
            String constant = cu.convert();
            if (constant.startsWith("\"") && constant.endsWith("\"")) {
                constant = constant.substring(1, constant.length() - 1);
            }
            StringConstant rvalue = StringConstant.v(constant);
            stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
        } else if (c instanceof CONSTANT_Class_info) {
            String className = ((CONSTANT_Utf8_info)constant_pool[((CONSTANT_Class_info)c).name_index]).convert();
            ClassConstant rvalue = ClassConstant.v(className);
            stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
        } else {
            throw new RuntimeException("Attempting to push a non-constant cp entry" + c);
        }
        statements.add(stmt);
    }

    void generateJimple(Instruction ins, TypeStack typeStack, TypeStack postTypeStack, cp_info[] constant_pool, List<Stmt> statements, BasicBlock basicBlock) {
        Local l1 = null;
        Local l2 = null;
        Local l3 = null;
        Local l4 = null;
        Expr rhs = null;
        ConditionExpr co = null;
        ArrayRef a = null;
        Stmt stmt = null;
        int x = ins.code & 0xFF;
        Util.v().activeOriginalIndex = ins.originalIndex;
        Util.v().isLocalStore = false;
        Util.v().isWideLocalStore = false;
        switch (x) {
            case 16: {
                IntConstant rvalue = IntConstant.v(((Instruction_Bipush)ins).arg_b);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
                break;
            }
            case 17: {
                IntConstant rvalue = IntConstant.v(((Instruction_Sipush)ins).arg_i);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
                break;
            }
            case 18: {
                this.generateJimpleForCPEntry(constant_pool, ((Instruction_Ldc1)ins).arg_b, typeStack, postTypeStack, this.jmethod, statements);
                break;
            }
            case 19: 
            case 20: {
                this.generateJimpleForCPEntry(constant_pool, ((Instruction_intindex)ins).arg_i, typeStack, postTypeStack, this.jmethod, statements);
                break;
            }
            case 1: {
                NullConstant rvalue = NullConstant.v();
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                IntConstant rvalue = IntConstant.v(x - 3);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
                break;
            }
            case 9: 
            case 10: {
                LongConstant rvalue = LongConstant.v(x - 9);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                FloatConstant rvalue = FloatConstant.v(x - 11);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
                break;
            }
            case 14: 
            case 15: {
                DoubleConstant rvalue = DoubleConstant.v(x - 14);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
                break;
            }
            case 21: {
                Local local = Util.v().getLocalForIndex(this.listBody, ((Instruction_bytevar)ins).arg_b);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), local);
                break;
            }
            case 23: {
                Local local = Util.v().getLocalForIndex(this.listBody, ((Instruction_bytevar)ins).arg_b);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), local);
                break;
            }
            case 25: {
                Local local = Util.v().getLocalForIndex(this.listBody, ((Instruction_bytevar)ins).arg_b);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), local);
                break;
            }
            case 24: {
                Local local = Util.v().getLocalForIndex(this.listBody, ((Instruction_bytevar)ins).arg_b);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), local);
                break;
            }
            case 22: {
                Local local = Util.v().getLocalForIndex(this.listBody, ((Instruction_bytevar)ins).arg_b);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), local);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                Local local = Util.v().getLocalForIndex(this.listBody, x - 26);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), local);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                Local local = Util.v().getLocalForIndex(this.listBody, x - 34);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), local);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                Local local = Util.v().getLocalForIndex(this.listBody, x - 42);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), local);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                Local local = Util.v().getLocalForIndex(this.listBody, x - 30);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), local);
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                Local local = Util.v().getLocalForIndex(this.listBody, x - 38);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), local);
                break;
            }
            case 54: {
                Util.v().isLocalStore = true;
                Util.v().isWideLocalStore = true;
                Local local = Util.v().getLocalForIndex(this.listBody, ((Instruction_bytevar)ins).arg_b);
                stmt = Jimple.v().newAssignStmt(local, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 56: {
                Util.v().isLocalStore = true;
                Util.v().isWideLocalStore = true;
                Local local = Util.v().getLocalForIndex(this.listBody, ((Instruction_bytevar)ins).arg_b);
                stmt = Jimple.v().newAssignStmt(local, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 58: {
                Util.v().isLocalStore = true;
                Util.v().isWideLocalStore = true;
                Local local = Util.v().getLocalForIndex(this.listBody, ((Instruction_bytevar)ins).arg_b);
                stmt = Jimple.v().newAssignStmt(local, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 55: {
                Util.v().isLocalStore = true;
                Util.v().isWideLocalStore = true;
                Local local = Util.v().getLocalForIndex(this.listBody, ((Instruction_bytevar)ins).arg_b);
                stmt = Jimple.v().newAssignStmt(local, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 57: {
                Util.v().isLocalStore = true;
                Util.v().isWideLocalStore = true;
                Local local = Util.v().getLocalForIndex(this.listBody, ((Instruction_bytevar)ins).arg_b);
                stmt = Jimple.v().newAssignStmt(local, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                Util.v().isLocalStore = true;
                Local local = Util.v().getLocalForIndex(this.listBody, x - 59);
                stmt = Jimple.v().newAssignStmt(local, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                Util.v().isLocalStore = true;
                Local local = Util.v().getLocalForIndex(this.listBody, x - 67);
                stmt = Jimple.v().newAssignStmt(local, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                Util.v().isLocalStore = true;
                Local local = Util.v().getLocalForIndex(this.listBody, x - 75);
                stmt = Jimple.v().newAssignStmt(local, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                Util.v().isLocalStore = true;
                Local local = Util.v().getLocalForIndex(this.listBody, x - 63);
                stmt = Jimple.v().newAssignStmt(local, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                Util.v().isLocalStore = true;
                Local local = Util.v().getLocalForIndex(this.listBody, x - 71);
                stmt = Jimple.v().newAssignStmt(local, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 132: {
                Local local = Util.v().getLocalForIndex(this.listBody, ((Instruction_Iinc)ins).arg_b);
                int amt = ((Instruction_Iinc)ins).arg_c;
                rhs = Jimple.v().newAddExpr(local, IntConstant.v(amt));
                stmt = Jimple.v().newAssignStmt(local, rhs);
                break;
            }
            case 196: {
                throw new RuntimeException("WIDE instruction should not be encountered anymore");
            }
            case 188: {
                Type baseType = this.jimpleTypeOfAtype(((Instruction_Newarray)ins).atype);
                rhs = Jimple.v().newNewArrayExpr(baseType, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 189: {
                String baseName = this.getClassName(constant_pool, ((Instruction_Anewarray)ins).arg_i);
                Type baseType = baseName.startsWith("[") ? Util.v().jimpleTypeOfFieldDescriptor(this.getClassName(constant_pool, ((Instruction_Anewarray)ins).arg_i)) : RefType.v(baseName);
                rhs = Jimple.v().newNewArrayExpr(baseType, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 197: {
                int bdims = ((Instruction_Multianewarray)ins).dims;
                ArrayList<Local> dims = new ArrayList<Local>();
                for (int j = 0; j < bdims; ++j) {
                    dims.add(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - bdims + j + 1));
                }
                String mstype = constant_pool[((Instruction_Multianewarray)ins).arg_i].toString(constant_pool);
                ArrayType jimpleType = (ArrayType)Util.v().jimpleTypeOfFieldDescriptor(mstype);
                rhs = Jimple.v().newNewMultiArrayExpr(jimpleType, dims);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 190: {
                rhs = Jimple.v().newLengthExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                a = Jimple.v().newArrayRef(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), a);
                break;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                a = Jimple.v().newArrayRef(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 2), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1));
                stmt = Jimple.v().newAssignStmt(a, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 80: 
            case 82: {
                a = Jimple.v().newArrayRef(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 3), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 2));
                stmt = Jimple.v().newAssignStmt(a, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 0: {
                stmt = Jimple.v().newNopStmt();
                break;
            }
            case 87: 
            case 88: {
                stmt = Jimple.v().newNopStmt();
                break;
            }
            case 89: {
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 92: {
                if (this.typeSize(typeStack.top()) == 2) {
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1));
                    break;
                }
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1));
                statements.add(stmt);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                statements.add(stmt);
                stmt = null;
                break;
            }
            case 90: {
                l1 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex());
                l2 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), l1);
                statements.add(stmt);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 1), l2);
                statements.add(stmt);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 2), Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()));
                statements.add(stmt);
                stmt = null;
                break;
            }
            case 91: {
                if (this.typeSize(typeStack.get(typeStack.topIndex() - 2)) == 2) {
                    l3 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 2);
                    l1 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex());
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 2), l3);
                    statements.add(stmt);
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 3), l1);
                    statements.add(stmt);
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), l1);
                    statements.add(stmt);
                    stmt = null;
                    break;
                }
                l3 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 2);
                l2 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1);
                l1 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex());
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), l1);
                statements.add(stmt);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 1), l2);
                statements.add(stmt);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 2), l3);
                statements.add(stmt);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 3), Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()));
                statements.add(stmt);
                stmt = null;
                break;
            }
            case 93: {
                if (this.typeSize(typeStack.get(typeStack.topIndex() - 1)) == 2) {
                    l2 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1);
                    l3 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 2);
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 1), l2);
                    statements.add(stmt);
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 2), l3);
                    statements.add(stmt);
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 4), Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 1));
                    statements.add(stmt);
                    stmt = null;
                    break;
                }
                l3 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 2);
                l2 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1);
                l1 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex());
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), l1);
                statements.add(stmt);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 1), l2);
                statements.add(stmt);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 2), l3);
                statements.add(stmt);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 3), Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()));
                statements.add(stmt);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 4), Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 1));
                statements.add(stmt);
                stmt = null;
                break;
            }
            case 94: {
                if (this.typeSize(typeStack.get(typeStack.topIndex() - 1)) == 2) {
                    l2 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1);
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 1), l2);
                    statements.add(stmt);
                } else {
                    l1 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex());
                    l2 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1);
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 1), l2);
                    statements.add(stmt);
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), l1);
                    statements.add(stmt);
                }
                if (this.typeSize(typeStack.get(typeStack.topIndex() - 3)) == 2) {
                    l4 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 3);
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 3), l4);
                    statements.add(stmt);
                } else {
                    l4 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 3);
                    l3 = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 2);
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 3), l4);
                    statements.add(stmt);
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 2), l3);
                    statements.add(stmt);
                }
                if (this.typeSize(typeStack.get(typeStack.topIndex() - 1)) == 2) {
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 5), Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 1));
                    statements.add(stmt);
                } else {
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 5), Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 1));
                    statements.add(stmt);
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 4), Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()));
                    statements.add(stmt);
                }
                stmt = null;
                break;
            }
            case 95: {
                typeStack = typeStack.push(typeStack.top());
                Local first = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex());
                typeStack = typeStack.pop();
                Local second = Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex());
                Local third = Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex() - 1);
                stmt = Jimple.v().newAssignStmt(first, second);
                statements.add(stmt);
                stmt = Jimple.v().newAssignStmt(second, third);
                statements.add(stmt);
                stmt = Jimple.v().newAssignStmt(third, first);
                statements.add(stmt);
                stmt = null;
                break;
            }
            case 96: 
            case 98: {
                rhs = Jimple.v().newAddExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 97: 
            case 99: {
                rhs = Jimple.v().newAddExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 3), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 100: 
            case 102: {
                rhs = Jimple.v().newSubExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 101: 
            case 103: {
                rhs = Jimple.v().newSubExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 3), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 104: 
            case 106: {
                rhs = Jimple.v().newMulExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 105: 
            case 107: {
                rhs = Jimple.v().newMulExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 3), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 108: 
            case 110: {
                rhs = Jimple.v().newDivExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 109: 
            case 111: {
                rhs = Jimple.v().newDivExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 3), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 112: 
            case 114: {
                rhs = Jimple.v().newRemExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 113: 
            case 115: {
                rhs = Jimple.v().newRemExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 3), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                rhs = Jimple.v().newNegExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 120: {
                rhs = Jimple.v().newShlExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 122: {
                rhs = Jimple.v().newShrExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 124: {
                rhs = Jimple.v().newUshrExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 121: {
                rhs = Jimple.v().newShlExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 2), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 123: {
                rhs = Jimple.v().newShrExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 2), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 125: {
                rhs = Jimple.v().newUshrExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 2), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 126: {
                rhs = Jimple.v().newAndExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 127: {
                rhs = Jimple.v().newAndExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 3), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 128: {
                rhs = Jimple.v().newOrExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 129: {
                rhs = Jimple.v().newOrExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 3), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 130: {
                rhs = Jimple.v().newXorExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 131: {
                rhs = Jimple.v().newXorExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 3), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 133: 
            case 140: 
            case 143: {
                rhs = Jimple.v().newCastExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), LongType.v());
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 134: 
            case 137: 
            case 144: {
                rhs = Jimple.v().newCastExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), FloatType.v());
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 135: 
            case 138: 
            case 141: {
                rhs = Jimple.v().newCastExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), DoubleType.v());
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 136: 
            case 139: 
            case 142: {
                rhs = Jimple.v().newCastExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), IntType.v());
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 145: {
                rhs = Jimple.v().newCastExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), ByteType.v());
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 146: {
                rhs = Jimple.v().newCastExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), CharType.v());
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 147: {
                rhs = Jimple.v().newCastExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), ShortType.v());
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 153: {
                co = Jimple.v().newEqExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), IntConstant.v(0));
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 198: {
                co = Jimple.v().newEqExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), NullConstant.v());
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 155: {
                co = Jimple.v().newLtExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), IntConstant.v(0));
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 158: {
                co = Jimple.v().newLeExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), IntConstant.v(0));
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 154: {
                co = Jimple.v().newNeExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), IntConstant.v(0));
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 199: {
                co = Jimple.v().newNeExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), NullConstant.v());
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 157: {
                co = Jimple.v().newGtExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), IntConstant.v(0));
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 156: {
                co = Jimple.v().newGeExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), IntConstant.v(0));
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 159: {
                co = Jimple.v().newEqExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 161: {
                co = Jimple.v().newLtExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 164: {
                co = Jimple.v().newLeExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 160: {
                co = Jimple.v().newNeExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 163: {
                co = Jimple.v().newGtExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 162: {
                co = Jimple.v().newGeExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 148: {
                rhs = Jimple.v().newCmpExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 3), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 149: {
                rhs = Jimple.v().newCmplExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 150: {
                rhs = Jimple.v().newCmpgExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 151: {
                rhs = Jimple.v().newCmplExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 3), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 152: {
                rhs = Jimple.v().newCmpgExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 3), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 165: {
                co = Jimple.v().newEqExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 166: {
                co = Jimple.v().newNeExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - 1), Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                stmt = Jimple.v().newIfStmt((Value)co, new FutureStmt());
                break;
            }
            case 167: {
                stmt = Jimple.v().newGotoStmt(new FutureStmt());
                break;
            }
            case 200: {
                stmt = Jimple.v().newGotoStmt(new FutureStmt());
                break;
            }
            case 169: {
                Local local = Util.v().getLocalForIndex(this.listBody, ((Instruction_Ret)ins).arg_b);
                stmt = Jimple.v().newRetStmt(local);
                break;
            }
            case 209: {
                Local local = Util.v().getLocalForIndex(this.listBody, ((Instruction_Ret_w)ins).arg_i);
                stmt = Jimple.v().newRetStmt(local);
                break;
            }
            case 177: {
                stmt = Jimple.v().newReturnVoidStmt();
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                stmt = Jimple.v().newReturnStmt(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 202: {
                stmt = Jimple.v().newBreakpointStmt();
                break;
            }
            case 170: {
                int lowIndex = ((Instruction_Tableswitch)ins).low;
                int highIndex = ((Instruction_Tableswitch)ins).high;
                stmt = Jimple.v().newTableSwitchStmt((Value)Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), lowIndex, highIndex, Arrays.asList(new FutureStmt[highIndex - lowIndex + 1]), new FutureStmt());
                break;
            }
            case 171: {
                ArrayList<IntConstant> matches = new ArrayList<IntConstant>();
                int npairs = ((Instruction_Lookupswitch)ins).npairs;
                for (int j = 0; j < npairs; ++j) {
                    matches.add(IntConstant.v(((Instruction_Lookupswitch)ins).match_offsets[j * 2]));
                }
                stmt = Jimple.v().newLookupSwitchStmt((Value)Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), matches, Arrays.asList(new FutureStmt[npairs]), new FutureStmt());
                break;
            }
            case 181: {
                CONSTANT_Fieldref_info fieldInfo = (CONSTANT_Fieldref_info)constant_pool[((Instruction_Putfield)ins).arg_i];
                CONSTANT_Class_info c = (CONSTANT_Class_info)constant_pool[fieldInfo.class_index];
                String className = ((CONSTANT_Utf8_info)constant_pool[c.name_index]).convert();
                className = className.replace('/', '.');
                CONSTANT_NameAndType_info i = (CONSTANT_NameAndType_info)constant_pool[fieldInfo.name_and_type_index];
                String fieldName = ((CONSTANT_Utf8_info)constant_pool[i.name_index]).convert();
                String fieldDescriptor = ((CONSTANT_Utf8_info)constant_pool[i.descriptor_index]).convert();
                Type fieldType = Util.v().jimpleTypeOfFieldDescriptor(fieldDescriptor);
                SootClass bclass = this.cm.getSootClass(className);
                SootFieldRef fieldRef = Scene.v().makeFieldRef(bclass, fieldName, fieldType, false);
                InstanceFieldRef fr = Jimple.v().newInstanceFieldRef(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex() - this.typeSize(typeStack.top())), fieldRef);
                Local rvalue = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex());
                stmt = Jimple.v().newAssignStmt(fr, rvalue);
                break;
            }
            case 180: {
                InstanceFieldRef fr = null;
                CONSTANT_Fieldref_info fieldInfo = (CONSTANT_Fieldref_info)constant_pool[((Instruction_Getfield)ins).arg_i];
                CONSTANT_Class_info c = (CONSTANT_Class_info)constant_pool[fieldInfo.class_index];
                String className = ((CONSTANT_Utf8_info)constant_pool[c.name_index]).convert();
                className = className.replace('/', '.');
                CONSTANT_NameAndType_info i = (CONSTANT_NameAndType_info)constant_pool[fieldInfo.name_and_type_index];
                String fieldName = ((CONSTANT_Utf8_info)constant_pool[i.name_index]).convert();
                String fieldDescriptor = ((CONSTANT_Utf8_info)constant_pool[i.descriptor_index]).convert();
                if (className.charAt(0) == '[') {
                    className = "java.lang.Object";
                }
                SootClass bclass = this.cm.getSootClass(className);
                Type fieldType = Util.v().jimpleTypeOfFieldDescriptor(fieldDescriptor);
                SootFieldRef fieldRef = Scene.v().makeFieldRef(bclass, fieldName, fieldType, false);
                fr = Jimple.v().newInstanceFieldRef(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), fieldRef);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), fr);
                break;
            }
            case 179: {
                StaticFieldRef fr = null;
                CONSTANT_Fieldref_info fieldInfo = (CONSTANT_Fieldref_info)constant_pool[((Instruction_Putstatic)ins).arg_i];
                CONSTANT_Class_info c = (CONSTANT_Class_info)constant_pool[fieldInfo.class_index];
                String className = ((CONSTANT_Utf8_info)constant_pool[c.name_index]).convert();
                className = className.replace('/', '.');
                CONSTANT_NameAndType_info i = (CONSTANT_NameAndType_info)constant_pool[fieldInfo.name_and_type_index];
                String fieldName = ((CONSTANT_Utf8_info)constant_pool[i.name_index]).convert();
                String fieldDescriptor = ((CONSTANT_Utf8_info)constant_pool[i.descriptor_index]).convert();
                Type fieldType = Util.v().jimpleTypeOfFieldDescriptor(fieldDescriptor);
                SootClass bclass = this.cm.getSootClass(className);
                SootFieldRef fieldRef = Scene.v().makeFieldRef(bclass, fieldName, fieldType, true);
                fr = Jimple.v().newStaticFieldRef(fieldRef);
                stmt = Jimple.v().newAssignStmt(fr, Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 178: {
                StaticFieldRef fr = null;
                CONSTANT_Fieldref_info fieldInfo = (CONSTANT_Fieldref_info)constant_pool[((Instruction_Getstatic)ins).arg_i];
                CONSTANT_Class_info c = (CONSTANT_Class_info)constant_pool[fieldInfo.class_index];
                String className = ((CONSTANT_Utf8_info)constant_pool[c.name_index]).convert();
                className = className.replace('/', '.');
                CONSTANT_NameAndType_info i = (CONSTANT_NameAndType_info)constant_pool[fieldInfo.name_and_type_index];
                String fieldName = ((CONSTANT_Utf8_info)constant_pool[i.name_index]).convert();
                String fieldDescriptor = ((CONSTANT_Utf8_info)constant_pool[i.descriptor_index]).convert();
                Type fieldType = Util.v().jimpleTypeOfFieldDescriptor(fieldDescriptor);
                SootClass bclass = this.cm.getSootClass(className);
                SootFieldRef fieldRef = Scene.v().makeFieldRef(bclass, fieldName, fieldType, true);
                fr = Jimple.v().newStaticFieldRef(fieldRef);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), fr);
                break;
            }
            case 186: {
                Instruction_Invokedynamic iv = (Instruction_Invokedynamic)ins;
                CONSTANT_InvokeDynamic_info iv_info = (CONSTANT_InvokeDynamic_info)constant_pool[iv.invoke_dynamic_index];
                int args = cp_info.countParams(constant_pool, iv_info.name_and_type_index);
                LinkedList<Value> bootstrapArgs = new LinkedList<Value>();
                short[] bootstrapMethodTable = this.bootstrap_methods_attribute.method_handles;
                short methodSigIndex = bootstrapMethodTable[iv_info.bootstrap_method_index];
                CONSTANT_MethodHandle_info mhInfo = (CONSTANT_MethodHandle_info)constant_pool[methodSigIndex];
                ICONSTANT_Methodref_info bsmInfo = (ICONSTANT_Methodref_info)((Object)constant_pool[mhInfo.target_index]);
                SootMethodRef bootstrapMethodRef = this.createMethodRef(constant_pool, bsmInfo, false);
                short[] bsmArgIndices = this.bootstrap_methods_attribute.arg_indices[iv_info.bootstrap_method_index];
                if (bsmArgIndices.length > 0) {
                    for (short bsmArgIndex : bsmArgIndices) {
                        cp_info cpEntry = constant_pool[bsmArgIndex];
                        Value val = cpEntry.createJimpleConstantValue(constant_pool);
                        bootstrapArgs.add(val);
                    }
                }
                SootMethodRef methodRef = null;
                CONSTANT_NameAndType_info nameAndTypeInfo = (CONSTANT_NameAndType_info)constant_pool[iv_info.name_and_type_index];
                String methodName = ((CONSTANT_Utf8_info)constant_pool[nameAndTypeInfo.name_index]).convert();
                String methodDescriptor = ((CONSTANT_Utf8_info)constant_pool[nameAndTypeInfo.descriptor_index]).convert();
                SootClass bclass = this.cm.getSootClass("soot.dummy.InvokeDynamic");
                Type[] types = Util.v().jimpleTypesOfFieldOrMethodDescriptor(methodDescriptor);
                ArrayList<Type> parameterTypes = new ArrayList<Type>();
                for (int k = 0; k < types.length - 1; ++k) {
                    parameterTypes.add(types[k]);
                }
                Type returnType = types[types.length - 1];
                methodRef = Scene.v().makeMethodRef(bclass, methodName, parameterTypes, returnType, true);
                Value[] params = new Value[args];
                for (int j = args - 1; j >= 0; --j) {
                    params[j] = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex());
                    if (this.typeSize(typeStack.top()) == 2) {
                        typeStack = typeStack.pop();
                        typeStack = typeStack.pop();
                        continue;
                    }
                    typeStack = typeStack.pop();
                }
                DynamicInvokeExpr rvalue = Jimple.v().newDynamicInvokeExpr(bootstrapMethodRef, bootstrapArgs, methodRef, Arrays.asList(params));
                if (!returnType.equals(VoidType.v())) {
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
                    break;
                }
                stmt = Jimple.v().newInvokeStmt(rvalue);
                break;
            }
            case 182: {
                Instruction_Invokevirtual iv = (Instruction_Invokevirtual)ins;
                int args = cp_info.countParams(constant_pool, iv.arg_i);
                ICONSTANT_Methodref_info methodInfo = (ICONSTANT_Methodref_info)((Object)constant_pool[iv.arg_i]);
                SootMethodRef methodRef = this.createMethodRef(constant_pool, methodInfo, false);
                Type returnType = methodRef.returnType();
                Value[] params = new Value[args];
                for (int j = args - 1; j >= 0; --j) {
                    params[j] = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex());
                    if (this.typeSize(typeStack.top()) == 2) {
                        typeStack = typeStack.pop();
                        typeStack = typeStack.pop();
                        continue;
                    }
                    typeStack = typeStack.pop();
                }
                VirtualInvokeExpr rvalue = Jimple.v().newVirtualInvokeExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), methodRef, Arrays.asList(params));
                if (!returnType.equals(VoidType.v())) {
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
                    break;
                }
                stmt = Jimple.v().newInvokeStmt(rvalue);
                break;
            }
            case 183: {
                Instruction_Invokenonvirtual iv = (Instruction_Invokenonvirtual)ins;
                int args = cp_info.countParams(constant_pool, iv.arg_i);
                ICONSTANT_Methodref_info methodInfo = (ICONSTANT_Methodref_info)((Object)constant_pool[iv.arg_i]);
                SootMethodRef methodRef = this.createMethodRef(constant_pool, methodInfo, false);
                Type returnType = methodRef.returnType();
                Value[] params = new Value[args];
                for (int j = args - 1; j >= 0; --j) {
                    params[j] = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex());
                    if (this.typeSize(typeStack.top()) == 2) {
                        typeStack = typeStack.pop();
                        typeStack = typeStack.pop();
                        continue;
                    }
                    typeStack = typeStack.pop();
                }
                SpecialInvokeExpr rvalue = Jimple.v().newSpecialInvokeExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), methodRef, Arrays.asList(params));
                if (!returnType.equals(VoidType.v())) {
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
                    break;
                }
                stmt = Jimple.v().newInvokeStmt(rvalue);
                break;
            }
            case 184: {
                Instruction_Invokestatic is = (Instruction_Invokestatic)ins;
                int args = cp_info.countParams(constant_pool, is.arg_i);
                ICONSTANT_Methodref_info methodInfo = (ICONSTANT_Methodref_info)((Object)constant_pool[is.arg_i]);
                SootMethodRef methodRef = this.createMethodRef(constant_pool, methodInfo, true);
                Type returnType = methodRef.returnType();
                Value[] params = new Value[args];
                for (int j = args - 1; j >= 0; --j) {
                    params[j] = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex());
                    if (this.typeSize(typeStack.top()) == 2) {
                        typeStack = typeStack.pop();
                        typeStack = typeStack.pop();
                        continue;
                    }
                    typeStack = typeStack.pop();
                }
                StaticInvokeExpr rvalue = Jimple.v().newStaticInvokeExpr(methodRef, Arrays.asList(params));
                if (!returnType.equals(VoidType.v())) {
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
                    break;
                }
                stmt = Jimple.v().newInvokeStmt(rvalue);
                break;
            }
            case 185: {
                Instruction_Invokeinterface ii = (Instruction_Invokeinterface)ins;
                int args = cp_info.countParams(constant_pool, ii.arg_i);
                CONSTANT_InterfaceMethodref_info methodInfo = (CONSTANT_InterfaceMethodref_info)constant_pool[ii.arg_i];
                SootMethodRef methodRef = this.createMethodRef(constant_pool, methodInfo, false);
                Type returnType = methodRef.returnType();
                Value[] params = new Value[args];
                for (int j = args - 1; j >= 0; --j) {
                    params[j] = Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex());
                    if (this.typeSize(typeStack.top()) == 2) {
                        typeStack = typeStack.pop();
                        typeStack = typeStack.pop();
                        continue;
                    }
                    typeStack = typeStack.pop();
                }
                InterfaceInvokeExpr rvalue = Jimple.v().newInterfaceInvokeExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), methodRef, Arrays.asList(params));
                if (!returnType.equals(VoidType.v())) {
                    stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rvalue);
                    break;
                }
                stmt = Jimple.v().newInvokeStmt(rvalue);
                break;
            }
            case 191: {
                stmt = Jimple.v().newThrowStmt(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 187: {
                SootClass bclass = this.cm.getSootClass(this.getClassName(constant_pool, ((Instruction_New)ins).arg_i));
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), Jimple.v().newNewExpr(RefType.v(bclass.getName())));
                break;
            }
            case 192: {
                String className = this.getClassName(constant_pool, ((Instruction_Checkcast)ins).arg_i);
                Type castType = className.startsWith("[") ? Util.v().jimpleTypeOfFieldDescriptor(this.getClassName(constant_pool, ((Instruction_Checkcast)ins).arg_i)) : RefType.v(className);
                rhs = Jimple.v().newCastExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), castType);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 193: {
                String className = this.getClassName(constant_pool, ((Instruction_Instanceof)ins).arg_i);
                Type checkType = className.startsWith("[") ? Util.v().jimpleTypeOfFieldDescriptor(this.getClassName(constant_pool, ((Instruction_Instanceof)ins).arg_i)) : RefType.v(className);
                rhs = Jimple.v().newInstanceOfExpr(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()), checkType);
                stmt = Jimple.v().newAssignStmt(Util.v().getLocalForStackOp(this.listBody, postTypeStack, postTypeStack.topIndex()), rhs);
                break;
            }
            case 194: {
                stmt = Jimple.v().newEnterMonitorStmt(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            case 195: {
                stmt = Jimple.v().newExitMonitorStmt(Util.v().getLocalForStackOp(this.listBody, typeStack, typeStack.topIndex()));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized bytecode instruction: " + x);
            }
        }
        if (stmt != null) {
            if (Options.v().keep_offset()) {
                stmt.addTag(new BytecodeOffsetTag(ins.label));
            }
            statements.add(stmt);
        }
    }

    private SootMethodRef createMethodRef(cp_info[] constant_pool, ICONSTANT_Methodref_info methodInfo, boolean isStatic) {
        CONSTANT_Class_info c = (CONSTANT_Class_info)constant_pool[methodInfo.getClassIndex()];
        String className = ((CONSTANT_Utf8_info)constant_pool[c.name_index]).convert();
        className = className.replace('/', '.');
        CONSTANT_NameAndType_info i = (CONSTANT_NameAndType_info)constant_pool[methodInfo.getNameAndTypeIndex()];
        String methodName = ((CONSTANT_Utf8_info)constant_pool[i.name_index]).convert();
        String methodDescriptor = ((CONSTANT_Utf8_info)constant_pool[i.descriptor_index]).convert();
        if (className.charAt(0) == '[') {
            className = "java.lang.Object";
        }
        SootClass bclass = this.cm.getSootClass(className);
        Type[] types = Util.v().jimpleTypesOfFieldOrMethodDescriptor(methodDescriptor);
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        for (int k = 0; k < types.length - 1; ++k) {
            parameterTypes.add(types[k]);
        }
        Type returnType = types[types.length - 1];
        SootMethodRef methodRef = Scene.v().makeMethodRef(bclass, methodName, parameterTypes, returnType, isStatic);
        return methodRef;
    }

    Type jimpleTypeOfAtype(int atype) {
        switch (atype) {
            case 4: {
                return BooleanType.v();
            }
            case 5: {
                return CharType.v();
            }
            case 6: {
                return FloatType.v();
            }
            case 7: {
                return DoubleType.v();
            }
            case 8: {
                return ByteType.v();
            }
            case 9: {
                return ShortType.v();
            }
            case 10: {
                return IntType.v();
            }
            case 11: {
                return LongType.v();
            }
        }
        throw new RuntimeException("Undefined 'atype' in NEWARRAY byte instruction");
    }

    int typeSize(Type type) {
        if (type.equals(LongType.v()) || type.equals(DoubleType.v()) || type.equals(Long2ndHalfType.v()) || type.equals(Double2ndHalfType.v())) {
            return 2;
        }
        return 1;
    }
}

