/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import java.util.ArrayList;
import soot.RefType;
import soot.SootMethodHandle;
import soot.SootMethodRef;
import soot.SootMethodType;
import soot.Type;
import soot.jimple.Constant;
import soot.jimple.ConstantSwitch;
import soot.jimple.JMethodType;
import soot.util.Switch;

class JMethodHandle
extends Constant
implements SootMethodHandle {
    private static final long serialVersionUID = 1L;
    private final int referenceKind;
    private final SootMethodRef methodRef;

    public JMethodHandle(int referenceKind, SootMethodRef methodRef) {
        this.referenceKind = referenceKind;
        this.methodRef = methodRef;
    }

    @Override
    public int getReferenceKind() {
        return this.referenceKind;
    }

    @Override
    public SootMethodRef getMethodRef() {
        return this.methodRef;
    }

    @Override
    public SootMethodType getMethodType() {
        switch (this.referenceKind) {
            case 2: 
            case 6: 
            case 8: {
                return new JMethodType(this.methodRef.returnType(), this.methodRef.parameterTypes());
            }
        }
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        parameterTypes.add(this.methodRef.declaringClass().getType());
        parameterTypes.addAll(this.methodRef.parameterTypes());
        return new JMethodType(this.methodRef.returnType(), parameterTypes);
    }

    @Override
    public Type getType() {
        return RefType.v("java.lang.invoke.MethodHandle");
    }

    @Override
    public void apply(Switch sw) {
        ((ConstantSwitch)sw).defaultCase(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.referenceKind) {
            case 1: {
                sb.append("GetField");
                break;
            }
            case 2: {
                sb.append("GetStatic");
                break;
            }
            case 3: {
                sb.append("PutField");
                break;
            }
            case 4: {
                sb.append("PutStatic");
                break;
            }
            case 5: {
                sb.append("InvokeVirtual");
                break;
            }
            case 6: {
                sb.append("InvokeStatic");
                break;
            }
            case 7: {
                sb.append("InvokeSpecial");
                break;
            }
            case 8: {
                sb.append("NewInvokeSpecial");
                break;
            }
            case 9: {
                sb.append("InvokeInterface");
            }
        }
        sb.append('(').append(this.methodRef).append(')');
        return sb.toString();
    }
}

