/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import soot.LongType;
import soot.Type;
import soot.jimple.ArithmeticConstant;
import soot.jimple.ConstantSwitch;
import soot.jimple.IntConstant;
import soot.jimple.NumericConstant;
import soot.util.Switch;

public class LongConstant
extends ArithmeticConstant {
    public final long value;

    private LongConstant(long value) {
        this.value = value;
    }

    public static LongConstant v(long value) {
        return new LongConstant(value);
    }

    public boolean equals(Object c) {
        return c instanceof LongConstant && ((LongConstant)c).value == this.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public NumericConstant add(NumericConstant c) {
        if (!(c instanceof LongConstant)) {
            throw new IllegalArgumentException("LongConstant expected");
        }
        return LongConstant.v(this.value + ((LongConstant)c).value);
    }

    @Override
    public NumericConstant subtract(NumericConstant c) {
        if (!(c instanceof LongConstant)) {
            throw new IllegalArgumentException("LongConstant expected");
        }
        return LongConstant.v(this.value - ((LongConstant)c).value);
    }

    @Override
    public NumericConstant multiply(NumericConstant c) {
        if (!(c instanceof LongConstant)) {
            throw new IllegalArgumentException("LongConstant expected");
        }
        return LongConstant.v(this.value * ((LongConstant)c).value);
    }

    @Override
    public NumericConstant divide(NumericConstant c) {
        if (!(c instanceof LongConstant)) {
            throw new IllegalArgumentException("LongConstant expected");
        }
        return LongConstant.v(this.value / ((LongConstant)c).value);
    }

    @Override
    public NumericConstant remainder(NumericConstant c) {
        if (!(c instanceof LongConstant)) {
            throw new IllegalArgumentException("LongConstant expected");
        }
        return LongConstant.v(this.value % ((LongConstant)c).value);
    }

    @Override
    public NumericConstant equalEqual(NumericConstant c) {
        if (!(c instanceof LongConstant)) {
            throw new IllegalArgumentException("LongConstant expected");
        }
        return IntConstant.v(this.value == ((LongConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant notEqual(NumericConstant c) {
        if (!(c instanceof LongConstant)) {
            throw new IllegalArgumentException("LongConstant expected");
        }
        return IntConstant.v(this.value != ((LongConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant lessThan(NumericConstant c) {
        if (!(c instanceof LongConstant)) {
            throw new IllegalArgumentException("LongConstant expected");
        }
        return IntConstant.v(this.value < ((LongConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant lessThanOrEqual(NumericConstant c) {
        if (!(c instanceof LongConstant)) {
            throw new IllegalArgumentException("LongConstant expected");
        }
        return IntConstant.v(this.value <= ((LongConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant greaterThan(NumericConstant c) {
        if (!(c instanceof LongConstant)) {
            throw new IllegalArgumentException("LongConstant expected");
        }
        return IntConstant.v(this.value > ((LongConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant greaterThanOrEqual(NumericConstant c) {
        if (!(c instanceof LongConstant)) {
            throw new IllegalArgumentException("LongConstant expected");
        }
        return IntConstant.v(this.value >= ((LongConstant)c).value ? 1 : 0);
    }

    public IntConstant cmp(LongConstant c) {
        if (this.value > c.value) {
            return IntConstant.v(1);
        }
        if (this.value == c.value) {
            return IntConstant.v(0);
        }
        return IntConstant.v(-1);
    }

    @Override
    public NumericConstant negate() {
        return LongConstant.v(-this.value);
    }

    @Override
    public ArithmeticConstant and(ArithmeticConstant c) {
        if (!(c instanceof LongConstant)) {
            throw new IllegalArgumentException("LongConstant expected");
        }
        return LongConstant.v(this.value & ((LongConstant)c).value);
    }

    @Override
    public ArithmeticConstant or(ArithmeticConstant c) {
        if (!(c instanceof LongConstant)) {
            throw new IllegalArgumentException("LongConstant expected");
        }
        return LongConstant.v(this.value | ((LongConstant)c).value);
    }

    @Override
    public ArithmeticConstant xor(ArithmeticConstant c) {
        if (!(c instanceof LongConstant)) {
            throw new IllegalArgumentException("LongConstant expected");
        }
        return LongConstant.v(this.value ^ ((LongConstant)c).value);
    }

    @Override
    public ArithmeticConstant shiftLeft(ArithmeticConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return LongConstant.v(this.value << ((IntConstant)c).value);
    }

    @Override
    public ArithmeticConstant shiftRight(ArithmeticConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return LongConstant.v(this.value >> ((IntConstant)c).value);
    }

    @Override
    public ArithmeticConstant unsignedShiftRight(ArithmeticConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return LongConstant.v(this.value >>> ((IntConstant)c).value);
    }

    public String toString() {
        return new Long(this.value).toString() + "L";
    }

    @Override
    public Type getType() {
        return LongType.v();
    }

    @Override
    public void apply(Switch sw) {
        ((ConstantSwitch)sw).caseLongConstant(this);
    }
}

