/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.jimple.IfStmt;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.StmtSwitch;
import soot.jimple.internal.AbstractStmt;
import soot.util.Switch;

public class JIfStmt
extends AbstractStmt
implements IfStmt {
    ValueBox conditionBox;
    UnitBox targetBox;
    List targetBoxes;

    public JIfStmt(Value condition, Unit target) {
        this(Jimple.v().newConditionExprBox(condition), Jimple.v().newStmtBox(target));
    }

    public JIfStmt(Value condition, UnitBox target) {
        this(Jimple.v().newConditionExprBox(condition), target);
    }

    protected JIfStmt(ValueBox conditionBox, UnitBox targetBox) {
        this.conditionBox = conditionBox;
        this.targetBox = targetBox;
        this.targetBoxes = Collections.singletonList(targetBox);
    }

    @Override
    public Object clone() {
        return new JIfStmt(Jimple.cloneIfNecessary(this.getCondition()), this.getTarget());
    }

    public String toString() {
        Stmt t = this.getTarget();
        String target = "(branch)";
        if (!t.branches()) {
            target = t.toString();
        }
        return "if " + this.getCondition().toString() + " " + "goto" + " " + target;
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("if");
        up.literal(" ");
        this.conditionBox.toString(up);
        up.literal(" ");
        up.literal("goto");
        up.literal(" ");
        this.targetBox.toString(up);
    }

    @Override
    public Value getCondition() {
        return this.conditionBox.getValue();
    }

    @Override
    public void setCondition(Value condition) {
        this.conditionBox.setValue(condition);
    }

    @Override
    public ValueBox getConditionBox() {
        return this.conditionBox;
    }

    @Override
    public Stmt getTarget() {
        return (Stmt)this.targetBox.getUnit();
    }

    @Override
    public void setTarget(Unit target) {
        this.targetBox.setUnit(target);
    }

    @Override
    public UnitBox getTargetBox() {
        return this.targetBox;
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> useBoxes = new ArrayList<ValueBox>();
        useBoxes.addAll(this.conditionBox.getValue().getUseBoxes());
        useBoxes.add(this.conditionBox);
        return useBoxes;
    }

    @Override
    public List getUnitBoxes() {
        return this.targetBoxes;
    }

    @Override
    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseIfStmt(this);
    }

    @Override
    public boolean fallsThrough() {
        return true;
    }

    @Override
    public boolean branches() {
        return true;
    }
}

