/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.arraycheck;

import java.util.List;
import soot.toolkits.graph.HashMutableDirectedGraph;

class ExtendedHashMutableDirectedGraph
extends HashMutableDirectedGraph {
    @Override
    public void addEdge(Object from, Object to) {
        if (!super.containsNode(from)) {
            super.addNode(from);
        }
        if (!super.containsNode(to)) {
            super.addNode(to);
        }
        super.addEdge(from, to);
    }

    public void addMutualEdge(Object from, Object to) {
        if (!super.containsNode(from)) {
            super.addNode(from);
        }
        if (!super.containsNode(to)) {
            super.addNode(to);
        }
        super.addEdge(from, to);
        super.addEdge(to, from);
    }

    public void skipNode(Object node) {
        if (!super.containsNode(node)) {
            return;
        }
        Object[] preds = this.getPredsOf(node).toArray();
        Object[] succs = this.getSuccsOf(node).toArray();
        for (Object element : preds) {
            for (Object element0 : succs) {
                if (element == element0) continue;
                super.addEdge(element, element0);
            }
        }
        for (Object element : preds) {
            super.removeEdge(element, node);
        }
        for (Object element : succs) {
            super.removeEdge(node, element);
        }
        super.removeNode(node);
    }

    public void mergeWith(ExtendedHashMutableDirectedGraph other) {
        List<Object> nodes = other.getNodes();
        for (Object node : nodes) {
            List succs = other.getSuccsOf(node);
            for (Object succ : succs) {
                this.addEdge(node, succ);
            }
        }
    }

    public String toString() {
        String rtn = "Graph:\n";
        List<Object> nodes = super.getNodes();
        for (Object node : nodes) {
            List succs = super.getSuccsOf(node);
            for (Object succ : succs) {
                rtn = rtn + node + "\t --- \t" + succ + "\n";
            }
        }
        return rtn;
    }
}

