/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.infoflow;

import java.util.ArrayList;
import java.util.List;
import soot.EquivalentValue;
import soot.RefLikeType;
import soot.jimple.InstanceFieldRef;
import soot.jimple.ParameterRef;
import soot.jimple.Ref;
import soot.jimple.StaticFieldRef;
import soot.jimple.ThisRef;

public class CallLocalityContext {
    List<Object> nodes = new ArrayList<Object>();
    List<Boolean> isNodeLocal;

    public CallLocalityContext(List<Object> nodes) {
        this.nodes.addAll(nodes);
        this.isNodeLocal = new ArrayList<Boolean>(nodes.size());
        for (int i = 0; i < nodes.size(); ++i) {
            this.isNodeLocal.add(i, Boolean.FALSE);
        }
    }

    public void setFieldLocal(EquivalentValue fieldRef) {
        ArrayList ret = new ArrayList();
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!fieldRef.equals(this.nodes.get(i))) continue;
            this.isNodeLocal.remove(i);
            this.isNodeLocal.add(i, Boolean.TRUE);
            return;
        }
        this.nodes.add(fieldRef);
        this.isNodeLocal.add(Boolean.TRUE);
    }

    public void setFieldShared(EquivalentValue fieldRef) {
        ArrayList ret = new ArrayList();
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!fieldRef.equals(this.nodes.get(i))) continue;
            this.isNodeLocal.remove(i);
            this.isNodeLocal.add(i, Boolean.FALSE);
            return;
        }
        this.nodes.add(fieldRef);
        this.isNodeLocal.add(Boolean.FALSE);
    }

    public void setAllFieldsLocal() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            Ref r = (Ref)((EquivalentValue)this.nodes.get(i)).getValue();
            if (!(r instanceof InstanceFieldRef)) continue;
            this.isNodeLocal.remove(i);
            this.isNodeLocal.add(i, Boolean.TRUE);
        }
    }

    public void setAllFieldsShared() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            Ref r = (Ref)((EquivalentValue)this.nodes.get(i)).getValue();
            if (!(r instanceof InstanceFieldRef)) continue;
            this.isNodeLocal.remove(i);
            this.isNodeLocal.add(i, Boolean.FALSE);
        }
    }

    public void setParamLocal(int index) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            ParameterRef pr;
            Ref r = (Ref)((EquivalentValue)this.nodes.get(i)).getValue();
            if (!(r instanceof ParameterRef) || (pr = (ParameterRef)r).getIndex() != index) continue;
            this.isNodeLocal.remove(i);
            this.isNodeLocal.add(i, Boolean.TRUE);
        }
    }

    public void setParamShared(int index) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            ParameterRef pr;
            Ref r = (Ref)((EquivalentValue)this.nodes.get(i)).getValue();
            if (!(r instanceof ParameterRef) || (pr = (ParameterRef)r).getIndex() != index) continue;
            this.isNodeLocal.remove(i);
            this.isNodeLocal.add(i, Boolean.FALSE);
        }
    }

    public void setAllParamsLocal() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            ParameterRef pr;
            Ref r = (Ref)((EquivalentValue)this.nodes.get(i)).getValue();
            if (!(r instanceof ParameterRef) || (pr = (ParameterRef)r).getIndex() == -1) continue;
            this.isNodeLocal.remove(i);
            this.isNodeLocal.add(i, Boolean.TRUE);
        }
    }

    public void setAllParamsShared() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            ParameterRef pr;
            Ref r = (Ref)((EquivalentValue)this.nodes.get(i)).getValue();
            if (!(r instanceof ParameterRef) || (pr = (ParameterRef)r).getIndex() == -1) continue;
            this.isNodeLocal.remove(i);
            this.isNodeLocal.add(i, Boolean.FALSE);
        }
    }

    public void setThisLocal() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            Ref r = (Ref)((EquivalentValue)this.nodes.get(i)).getValue();
            if (!(r instanceof ThisRef)) continue;
            this.isNodeLocal.remove(i);
            this.isNodeLocal.add(i, Boolean.TRUE);
        }
    }

    public void setThisShared() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            Ref r = (Ref)((EquivalentValue)this.nodes.get(i)).getValue();
            if (!(r instanceof ThisRef)) continue;
            this.isNodeLocal.remove(i);
            this.isNodeLocal.add(i, Boolean.FALSE);
        }
    }

    public void setReturnLocal() {
        this.setParamLocal(-1);
    }

    public void setReturnShared() {
        this.setParamShared(-1);
    }

    public List<Object> getLocalRefs() {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!this.isNodeLocal.get(i).booleanValue()) continue;
            ret.add(this.nodes.get(i));
        }
        return ret;
    }

    public List<Object> getSharedRefs() {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (this.isNodeLocal.get(i).booleanValue()) continue;
            ret.add(this.nodes.get(i));
        }
        return ret;
    }

    public boolean isFieldLocal(EquivalentValue fieldRef) {
        ArrayList ret = new ArrayList();
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!fieldRef.equals(this.nodes.get(i))) continue;
            return this.isNodeLocal.get(i);
        }
        return false;
    }

    public boolean containsField(EquivalentValue fieldRef) {
        ArrayList ret = new ArrayList();
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!fieldRef.equals(this.nodes.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean merge(CallLocalityContext other) {
        int i;
        boolean isChanged = false;
        if (other.nodes.size() > this.nodes.size()) {
            isChanged = true;
            for (i = this.nodes.size(); i < other.nodes.size(); ++i) {
                this.nodes.add(other.nodes.get(i));
                this.isNodeLocal.add(other.isNodeLocal.get(i));
            }
        }
        for (i = 0; i < other.nodes.size(); ++i) {
            Boolean temp = new Boolean(this.isNodeLocal.get(i) != false && other.isNodeLocal.get(i) != false);
            if (!temp.equals(this.isNodeLocal.get(i))) {
                isChanged = true;
            }
            this.isNodeLocal.remove(i);
            this.isNodeLocal.add(i, temp);
        }
        return isChanged;
    }

    public boolean equals(Object o) {
        if (o instanceof CallLocalityContext) {
            CallLocalityContext other = (CallLocalityContext)o;
            return this.isNodeLocal.equals(other.isNodeLocal);
        }
        return false;
    }

    public int hashCode() {
        return this.isNodeLocal.hashCode();
    }

    public boolean isAllShared(boolean refsOnly) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!refsOnly && this.isNodeLocal.get(i).booleanValue()) {
                return false;
            }
            if (!(((EquivalentValue)this.nodes.get(i)).getValue().getType() instanceof RefLikeType) || !this.isNodeLocal.get(i).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String fieldrefs = "";
        String staticrefs = "";
        String paramrefs = "";
        String thisref = "";
        if (this.nodes.size() == 0) {
            return "Call Locality Context: NO NODES\n";
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            Ref r = (Ref)((EquivalentValue)this.nodes.get(i)).getValue();
            if (r instanceof InstanceFieldRef) {
                fieldrefs = fieldrefs + r + ": " + (this.isNodeLocal.get(i) != false ? "local" : "shared") + "\n";
                continue;
            }
            if (r instanceof StaticFieldRef) {
                staticrefs = staticrefs + r + ": " + (this.isNodeLocal.get(i) != false ? "local" : "shared") + "\n";
                continue;
            }
            if (r instanceof ParameterRef) {
                paramrefs = paramrefs + r + ": " + (this.isNodeLocal.get(i) != false ? "local" : "shared") + "\n";
                continue;
            }
            if (r instanceof ThisRef) {
                thisref = thisref + r + ": " + (this.isNodeLocal.get(i) != false ? "local" : "shared") + "\n";
                continue;
            }
            return "Call Locality Context: HAS STRANGE NODE " + r + "\n";
        }
        return "Call Locality Context: \n" + fieldrefs + paramrefs + thisref + staticrefs;
    }

    public String toShortString() {
        String ret = "[";
        for (int i = 0; i < this.nodes.size(); ++i) {
            ret = ret + (this.isNodeLocal.get(i) != false ? "L" : "S");
        }
        return ret + "]";
    }
}

