/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.G;
import soot.IntType;
import soot.NullType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.Type;
import soot.TypeSwitch;
import soot.jimple.toolkits.typing.InternalTypingException;
import soot.jimple.toolkits.typing.TypeNode;
import soot.options.Options;

public class ClassHierarchy {
    public final TypeNode OBJECT;
    public final TypeNode CLONEABLE;
    public final TypeNode SERIALIZABLE;
    public final TypeNode NULL;
    public final TypeNode INT;
    private final List<TypeNode> typeNodeList = new ArrayList<TypeNode>();
    private final HashMap<Type, TypeNode> typeNodeMap = new HashMap();
    private final ToInt transform = new ToInt();
    private final ConstructorChooser make = new ConstructorChooser();

    private ClassHierarchy(Scene scene) {
        if (scene == null) {
            throw new InternalTypingException();
        }
        G.v().ClassHierarchy_classHierarchyMap.put(scene, this);
        this.NULL = this.typeNode(NullType.v());
        this.OBJECT = this.typeNode(RefType.v("java.lang.Object"));
        if (!Options.v().j2me()) {
            this.CLONEABLE = this.typeNode(RefType.v("java.lang.Cloneable"));
            this.SERIALIZABLE = this.typeNode(RefType.v("java.io.Serializable"));
        } else {
            this.CLONEABLE = null;
            this.SERIALIZABLE = null;
        }
        this.INT = this.typeNode(IntType.v());
    }

    public static ClassHierarchy classHierarchy(Scene scene) {
        if (scene == null) {
            throw new InternalTypingException();
        }
        ClassHierarchy classHierarchy = G.v().ClassHierarchy_classHierarchyMap.get(scene);
        if (classHierarchy == null) {
            classHierarchy = new ClassHierarchy(scene);
        }
        return classHierarchy;
    }

    public TypeNode typeNode(Type type) {
        if (type == null) {
            throw new InternalTypingException();
        }
        TypeNode typeNode = this.typeNodeMap.get(type = this.transform.toInt(type));
        if (typeNode == null) {
            int id = this.typeNodeList.size();
            this.typeNodeList.add(null);
            typeNode = this.make.typeNode(id, type, this);
            this.typeNodeList.set(id, typeNode);
            this.typeNodeMap.put(type, typeNode);
        }
        return typeNode;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        boolean colon = false;
        s.append("ClassHierarchy:{");
        for (TypeNode typeNode : this.typeNodeList) {
            if (colon) {
                s.append(",");
            } else {
                colon = true;
            }
            s.append(typeNode);
        }
        s.append("}");
        return s.toString();
    }

    private static class ConstructorChooser
    extends TypeSwitch {
        private int id;
        private ClassHierarchy hierarchy;
        private TypeNode result;

        ConstructorChooser() {
        }

        TypeNode typeNode(int id, Type type, ClassHierarchy hierarchy) {
            if (type == null || hierarchy == null) {
                throw new InternalTypingException();
            }
            this.id = id;
            this.hierarchy = hierarchy;
            type.apply(this);
            return this.result;
        }

        @Override
        public void caseRefType(RefType type) {
            this.result = new TypeNode(this.id, type, this.hierarchy);
        }

        @Override
        public void caseArrayType(ArrayType type) {
            this.result = new TypeNode(this.id, type, this.hierarchy);
        }

        @Override
        public void defaultCase(Type type) {
            this.result = new TypeNode(this.id, type, this.hierarchy);
        }
    }

    private static class ToInt
    extends TypeSwitch {
        private Type result;
        private final Type intType = IntType.v();

        private ToInt() {
        }

        Type toInt(Type type) {
            type.apply(this);
            return this.result;
        }

        @Override
        public void caseBooleanType(BooleanType type) {
            this.result = this.intType;
        }

        @Override
        public void caseByteType(ByteType type) {
            this.result = this.intType;
        }

        @Override
        public void caseShortType(ShortType type) {
            this.result = this.intType;
        }

        @Override
        public void caseCharType(CharType type) {
            this.result = this.intType;
        }

        @Override
        public void defaultCase(Type type) {
            this.result = type;
        }
    }
}

