/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.ArrayType;
import soot.G;
import soot.NullType;
import soot.PrimType;
import soot.RefType;
import soot.SootClass;
import soot.Type;
import soot.jimple.toolkits.typing.ClassHierarchy;
import soot.jimple.toolkits.typing.InternalTypingException;
import soot.jimple.toolkits.typing.TypeException;
import soot.jimple.toolkits.typing.TypeVariable;
import soot.options.Options;
import soot.util.BitVector;

class TypeNode {
    private static final boolean DEBUG = false;
    private final int id;
    private final Type type;
    private final ClassHierarchy hierarchy;
    private TypeNode parentClass;
    private TypeNode element;
    private TypeNode array;
    private List parents = Collections.EMPTY_LIST;
    private final BitVector ancestors = new BitVector(0);
    private final BitVector descendants = new BitVector(0);

    public TypeNode(int id, Type type, ClassHierarchy hierarchy) {
        if (type == null || hierarchy == null) {
            throw new InternalTypingException();
        }
        if (!(type instanceof PrimType || type instanceof RefType || type instanceof ArrayType || type instanceof NullType)) {
            G.v().out.println("Unhandled type: " + type);
            throw new InternalTypingException();
        }
        this.id = id;
        this.type = type;
        this.hierarchy = hierarchy;
    }

    public TypeNode(int id, RefType type, ClassHierarchy hierarchy) {
        this(id, (Type)type, hierarchy);
        SootClass sClass = type.getSootClass();
        if (sClass == null) {
            throw new RuntimeException("Oops, forgot to load " + type);
        }
        if (sClass.isPhantomClass()) {
            throw new RuntimeException("Jimplification requires " + sClass + ", but it is a phantom ref.");
        }
        LinkedList<TypeNode> plist = new LinkedList<TypeNode>();
        if (sClass.hasSuperclass() && !sClass.getName().equals("java.lang.Object")) {
            TypeNode parent = hierarchy.typeNode(RefType.v(sClass.getSuperclass().getName()));
            plist.add(parent);
            this.parentClass = parent;
        }
        Iterator<SootClass> i = sClass.getInterfaces().iterator();
        while (i.hasNext()) {
            TypeNode parent = hierarchy.typeNode(RefType.v(i.next().getName()));
            plist.add(parent);
        }
        this.parents = Collections.unmodifiableList(plist);
        this.descendants.set(hierarchy.NULL.id);
        hierarchy.NULL.ancestors.set(id);
        for (TypeNode parent : this.parents) {
            this.ancestors.set(parent.id);
            this.ancestors.or(parent.ancestors);
            parent.fixDescendants(id);
        }
    }

    public TypeNode(int id, ArrayType type, ClassHierarchy hierarchy) {
        this(id, (Type)type, hierarchy);
        if (type.numDimensions < 1) {
            throw new InternalTypingException();
        }
        this.element = type.numDimensions == 1 ? hierarchy.typeNode(type.baseType) : hierarchy.typeNode(ArrayType.v(type.baseType, type.numDimensions - 1));
        if (this.element != hierarchy.INT) {
            if (this.element.array != null) {
                throw new InternalTypingException();
            }
            this.element.array = this;
        }
        LinkedList<TypeNode> plist = new LinkedList<TypeNode>();
        if (type.baseType instanceof RefType) {
            RefType baseType = (RefType)type.baseType;
            SootClass sClass = baseType.getSootClass();
            if (sClass.hasSuperclass() && !sClass.getName().equals("java.lang.Object")) {
                TypeNode parent = hierarchy.typeNode(ArrayType.v(RefType.v(sClass.getSuperclass().getName()), type.numDimensions));
                plist.add(parent);
                this.parentClass = parent;
            } else if (type.numDimensions == 1) {
                plist.add(hierarchy.OBJECT);
                if (!Options.v().j2me()) {
                    plist.add(hierarchy.CLONEABLE);
                    plist.add(hierarchy.SERIALIZABLE);
                }
                this.parentClass = hierarchy.OBJECT;
            } else {
                plist.add(hierarchy.typeNode(ArrayType.v(hierarchy.OBJECT.type(), type.numDimensions - 1)));
                if (!Options.v().j2me()) {
                    plist.add(hierarchy.typeNode(ArrayType.v(hierarchy.CLONEABLE.type(), type.numDimensions - 1)));
                    plist.add(hierarchy.typeNode(ArrayType.v(hierarchy.SERIALIZABLE.type(), type.numDimensions - 1)));
                }
                this.parentClass = hierarchy.typeNode(ArrayType.v(hierarchy.OBJECT.type(), type.numDimensions - 1));
            }
            Iterator<SootClass> i = sClass.getInterfaces().iterator();
            while (i.hasNext()) {
                TypeNode parent = hierarchy.typeNode(ArrayType.v(RefType.v(i.next().getName()), type.numDimensions));
                plist.add(parent);
            }
        } else if (type.numDimensions == 1) {
            plist.add(hierarchy.OBJECT);
            if (!Options.v().j2me()) {
                plist.add(hierarchy.CLONEABLE);
                plist.add(hierarchy.SERIALIZABLE);
            }
            this.parentClass = hierarchy.OBJECT;
        } else {
            plist.add(hierarchy.typeNode(ArrayType.v(hierarchy.OBJECT.type(), type.numDimensions - 1)));
            if (!Options.v().j2me()) {
                plist.add(hierarchy.typeNode(ArrayType.v(hierarchy.CLONEABLE.type(), type.numDimensions - 1)));
                plist.add(hierarchy.typeNode(ArrayType.v(hierarchy.SERIALIZABLE.type(), type.numDimensions - 1)));
            }
            this.parentClass = hierarchy.typeNode(ArrayType.v(hierarchy.OBJECT.type(), type.numDimensions - 1));
        }
        this.parents = Collections.unmodifiableList(plist);
        this.descendants.set(hierarchy.NULL.id);
        hierarchy.NULL.ancestors.set(id);
        for (TypeNode parent : this.parents) {
            this.ancestors.set(parent.id);
            this.ancestors.or(parent.ancestors);
            parent.fixDescendants(id);
        }
    }

    private void fixDescendants(int id) {
        if (this.descendants.get(id)) {
            return;
        }
        for (TypeNode parent : this.parents) {
            parent.fixDescendants(id);
        }
        this.descendants.set(id);
    }

    public int id() {
        return this.id;
    }

    public Type type() {
        return this.type;
    }

    public boolean hasAncestor(TypeNode typeNode) {
        return this.ancestors.get(typeNode.id);
    }

    public boolean hasAncestorOrSelf(TypeNode typeNode) {
        if (typeNode == this) {
            return true;
        }
        return this.ancestors.get(typeNode.id);
    }

    public boolean hasDescendant(TypeNode typeNode) {
        return this.descendants.get(typeNode.id);
    }

    public boolean hasDescendantOrSelf(TypeNode typeNode) {
        if (typeNode == this) {
            return true;
        }
        return this.descendants.get(typeNode.id);
    }

    public List parents() {
        return this.parents;
    }

    public TypeNode parentClass() {
        return this.parentClass;
    }

    public String toString() {
        return this.type.toString() + "(" + this.id + ")";
    }

    public TypeNode lca(TypeNode type) throws TypeException {
        if (type == null) {
            throw new InternalTypingException();
        }
        if (type == this) {
            return this;
        }
        if (this.hasAncestor(type)) {
            return type;
        }
        if (this.hasDescendant(type)) {
            return this;
        }
        do {
            if ((type = type.parentClass) != null) continue;
            TypeVariable.error("Type Error(12)");
        } while (!this.hasAncestor(type));
        return type;
    }

    public TypeNode lcaIfUnique(TypeNode type) throws TypeException {
        TypeNode initial = type;
        if (type == null) {
            throw new InternalTypingException();
        }
        if (type == this) {
            return this;
        }
        if (this.hasAncestor(type)) {
            return type;
        }
        if (this.hasDescendant(type)) {
            return this;
        }
        do {
            if (type.parents.size() != 1) {
                return null;
            }
            type = (TypeNode)type.parents.get(0);
        } while (!this.hasAncestor(type));
        return type;
    }

    public boolean hasElement() {
        return this.element != null;
    }

    public TypeNode element() {
        if (this.element == null) {
            throw new InternalTypingException();
        }
        return this.element;
    }

    public TypeNode array() {
        if (this.array != null) {
            return this.array;
        }
        if (this.type instanceof ArrayType) {
            ArrayType atype = (ArrayType)this.type;
            this.array = this.hierarchy.typeNode(ArrayType.v(atype.baseType, atype.numDimensions + 1));
            return this.array;
        }
        if (this.type instanceof PrimType || this.type instanceof RefType) {
            this.array = this.hierarchy.typeNode(ArrayType.v(this.type, 1));
            return this.array;
        }
        throw new InternalTypingException();
    }

    public boolean isNull() {
        return this.type instanceof NullType;
    }

    public boolean isClass() {
        return this.type instanceof ArrayType || this.type instanceof NullType || this.type instanceof RefType && !((RefType)this.type).getSootClass().isInterface();
    }

    public boolean isClassOrInterface() {
        return this.type instanceof ArrayType || this.type instanceof NullType || this.type instanceof RefType;
    }

    public boolean isArray() {
        return this.type instanceof ArrayType || this.type instanceof NullType;
    }
}

