/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.fast;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import soot.Local;
import soot.Type;
import soot.jimple.toolkits.typing.fast.BottomType;
import soot.jimple.toolkits.typing.fast.IHierarchy;
import soot.jimple.toolkits.typing.fast.TypeResolver;

public class Typing {
    private HashMap<Local, Type> map;

    public Typing(Collection<Local> vs) {
        this.map = new HashMap();
        for (Local v : vs) {
            this.map.put(v, BottomType.v());
        }
    }

    public Typing(Typing tg) {
        this.map = new HashMap<Local, Type>(tg.map);
    }

    public Type get(Local v) {
        return this.map.get(v);
    }

    public Type set(Local v, Type t) {
        return this.map.put(v, t);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        for (Local v : this.map.keySet()) {
            sb.append(v);
            sb.append(':');
            sb.append(this.get(v));
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    public static void minimize(List<Typing> tgs, IHierarchy h) {
        ListIterator<Typing> i = tgs.listIterator();
        block0: while (i.hasNext()) {
            Typing tgi = i.next();
            ListIterator<Typing> j = tgs.listIterator();
            while (j.hasNext()) {
                Typing tgj = j.next();
                if (tgi == tgj || Typing.compare(tgi, tgj, h) != 1) continue;
                i.remove();
                continue block0;
            }
        }
    }

    public static int compare(Typing a, Typing b, IHierarchy h) {
        int r = 0;
        for (Local v : a.map.keySet()) {
            int cmp;
            Type tb;
            Type ta = a.get(v);
            if (TypeResolver.typesEqual(ta, tb = b.get(v))) {
                boolean bl = false;
            }
            if (h.ancestor(ta, tb)) {
                cmp = 1;
            } else if (h.ancestor(tb, ta)) {
                cmp = -1;
            } else {
                return -2;
            }
            if (cmp == 1 && r == -1 || cmp == -1 && r == 1) {
                return 2;
            }
            if (r != 0) continue;
            r = cmp;
        }
        return r;
    }
}

