/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.fast;

import java.util.Iterator;
import soot.ArrayType;
import soot.BooleanType;
import soot.IntType;
import soot.IntegerType;
import soot.Local;
import soot.RefType;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.DivExpr;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FieldRef;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.JimpleBody;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.OrExpr;
import soot.jimple.RemExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.Stmt;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.UshrExpr;
import soot.jimple.XorExpr;
import soot.jimple.toolkits.typing.fast.AugEvalFunction;
import soot.jimple.toolkits.typing.fast.IUseVisitor;
import soot.jimple.toolkits.typing.fast.Integer1Type;
import soot.jimple.toolkits.typing.fast.Typing;

public class UseChecker
extends AbstractStmtSwitch {
    private JimpleBody jb;
    private Typing tg;
    private IUseVisitor uv;

    public UseChecker(JimpleBody jb) {
        this.jb = jb;
    }

    public void check(Typing tg, IUseVisitor uv) {
        try {
            this.tg = tg;
            this.uv = uv;
            if (this.tg == null) {
                throw new Exception("null typing passed to useChecker");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        Iterator<Unit> i = this.jb.getUnits().snapshotIterator();
        while (i.hasNext()) {
            if (uv.finish()) {
                return;
            }
            ((Stmt)i.next()).apply(this);
        }
    }

    private void handleInvokeExpr(InvokeExpr ie, Stmt stmt) {
        SootMethodRef m = ie.getMethodRef();
        if (ie instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
            iie.setBase(this.uv.visit(iie.getBase(), m.declaringClass().getType(), stmt));
        }
        for (int i = 0; i < ie.getArgCount(); ++i) {
            ie.setArg(i, this.uv.visit(ie.getArg(i), m.parameterType(i), stmt));
        }
    }

    private void handleBinopExpr(BinopExpr be, Stmt stmt, Type tlhs) {
        Value opl = be.getOp1();
        Value opr = be.getOp2();
        Type tl = AugEvalFunction.eval_(this.tg, opl, stmt, this.jb);
        Type tr = AugEvalFunction.eval_(this.tg, opr, stmt, this.jb);
        if (be instanceof AddExpr || be instanceof SubExpr || be instanceof MulExpr || be instanceof DivExpr || be instanceof RemExpr || be instanceof GeExpr || be instanceof GtExpr || be instanceof LeExpr || be instanceof LtExpr || be instanceof ShlExpr || be instanceof ShrExpr || be instanceof UshrExpr) {
            if (tlhs instanceof IntegerType) {
                be.setOp1(this.uv.visit(opl, IntType.v(), stmt));
                be.setOp2(this.uv.visit(opr, IntType.v(), stmt));
            }
        } else if (!(be instanceof CmpExpr || be instanceof CmpgExpr || be instanceof CmplExpr)) {
            if (be instanceof AndExpr || be instanceof OrExpr || be instanceof XorExpr) {
                be.setOp1(this.uv.visit(opl, tlhs, stmt));
                be.setOp2(this.uv.visit(opr, tlhs, stmt));
            } else if (!(!(be instanceof EqExpr) && !(be instanceof NeExpr) || tl instanceof BooleanType && tr instanceof BooleanType || tl instanceof Integer1Type || tr instanceof Integer1Type || !(tl instanceof IntegerType))) {
                be.setOp1(this.uv.visit(opl, IntType.v(), stmt));
                be.setOp2(this.uv.visit(opr, IntType.v(), stmt));
            }
        }
    }

    private void handleArrayRef(ArrayRef ar, Stmt stmt) {
        ar.setIndex(this.uv.visit(ar.getIndex(), IntType.v(), stmt));
    }

    private void handleInstanceFieldRef(InstanceFieldRef ifr, Stmt stmt) {
        ifr.setBase(this.uv.visit(ifr.getBase(), ifr.getFieldRef().declaringClass().getType(), stmt));
    }

    @Override
    public void caseBreakpointStmt(BreakpointStmt stmt) {
    }

    @Override
    public void caseInvokeStmt(InvokeStmt stmt) {
        this.handleInvokeExpr(stmt.getInvokeExpr(), stmt);
    }

    @Override
    public void caseAssignStmt(AssignStmt stmt) {
        Value lhs = stmt.getLeftOp();
        Type tlhs = null;
        if (lhs instanceof Local) {
            tlhs = this.tg.get((Local)lhs);
        } else if (lhs instanceof ArrayRef) {
            Local base = (Local)((ArrayRef)lhs).getBase();
            ArrayType at = this.tg.get(base) instanceof ArrayType ? (ArrayType)this.tg.get(base) : this.tg.get(base).makeArrayType();
            tlhs = at.getElementType();
            this.handleArrayRef((ArrayRef)lhs, stmt);
        } else if (lhs instanceof FieldRef) {
            tlhs = ((FieldRef)lhs).getField().getType();
            if (lhs instanceof InstanceFieldRef) {
                this.handleInstanceFieldRef((InstanceFieldRef)lhs, stmt);
            }
        }
        Value rhs = stmt.getRightOp();
        if (rhs instanceof Local) {
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof ArrayRef) {
            this.handleArrayRef((ArrayRef)rhs, stmt);
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof InstanceFieldRef) {
            this.handleInstanceFieldRef((InstanceFieldRef)rhs, stmt);
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof BinopExpr) {
            this.handleBinopExpr((BinopExpr)rhs, stmt, tlhs);
        } else if (rhs instanceof InvokeExpr) {
            this.handleInvokeExpr((InvokeExpr)rhs, stmt);
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof CastExpr) {
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof InstanceOfExpr) {
            InstanceOfExpr ioe = (InstanceOfExpr)rhs;
            ioe.setOp(this.uv.visit(ioe.getOp(), RefType.v("java.lang.Object"), stmt));
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof NewArrayExpr) {
            NewArrayExpr nae = (NewArrayExpr)rhs;
            nae.setSize(this.uv.visit(nae.getSize(), IntType.v(), stmt));
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof NewMultiArrayExpr) {
            NewMultiArrayExpr nmae = (NewMultiArrayExpr)rhs;
            for (int i = 0; i < nmae.getSizeCount(); ++i) {
                nmae.setSize(i, this.uv.visit(nmae.getSize(i), IntType.v(), stmt));
            }
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof LengthExpr) {
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof NegExpr) {
            ((NegExpr)rhs).setOp(this.uv.visit(((NegExpr)rhs).getOp(), tlhs, stmt));
        }
    }

    @Override
    public void caseIdentityStmt(IdentityStmt stmt) {
    }

    @Override
    public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
        stmt.setOp(this.uv.visit(stmt.getOp(), RefType.v("java.lang.Object"), stmt));
    }

    @Override
    public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
        stmt.setOp(this.uv.visit(stmt.getOp(), RefType.v("java.lang.Object"), stmt));
    }

    @Override
    public void caseGotoStmt(GotoStmt stmt) {
    }

    @Override
    public void caseIfStmt(IfStmt stmt) {
        this.handleBinopExpr((BinopExpr)stmt.getCondition(), stmt, BooleanType.v());
    }

    @Override
    public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
        stmt.setKey(this.uv.visit(stmt.getKey(), IntType.v(), stmt));
    }

    @Override
    public void caseNopStmt(NopStmt stmt) {
    }

    @Override
    public void caseReturnStmt(ReturnStmt stmt) {
        stmt.setOp(this.uv.visit(stmt.getOp(), this.jb.getMethod().getReturnType(), stmt));
    }

    @Override
    public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
    }

    @Override
    public void caseTableSwitchStmt(TableSwitchStmt stmt) {
        stmt.setKey(this.uv.visit(stmt.getKey(), IntType.v(), stmt));
    }

    @Override
    public void caseThrowStmt(ThrowStmt stmt) {
        stmt.setOp(this.uv.visit(stmt.getOp(), RefType.v("java.lang.Throwable"), stmt));
    }

    public void defaultCase(Stmt stmt) {
        throw new RuntimeException("Unhandled stgtement type: " + stmt.getClass());
    }
}

