/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.integer;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import soot.jimple.toolkits.typing.integer.TypeException;
import soot.jimple.toolkits.typing.integer.TypeVariable;

class StronglyConnectedComponents {
    List<TypeVariable> variables;
    Set<TypeVariable> black;
    LinkedList<TypeVariable> finished;
    LinkedList<LinkedList<TypeVariable>> forest = new LinkedList();
    LinkedList<TypeVariable> current_tree;
    private static final boolean DEBUG = false;

    public static void merge(List<TypeVariable> typeVariableList) throws TypeException {
        new StronglyConnectedComponents(typeVariableList);
    }

    private StronglyConnectedComponents(List<TypeVariable> typeVariableList) throws TypeException {
        this.variables = typeVariableList;
        this.black = new TreeSet<TypeVariable>();
        this.finished = new LinkedList();
        for (TypeVariable typeVariable : this.variables) {
            if (this.black.contains(typeVariable)) continue;
            this.black.add(typeVariable);
            this.dfsg_visit(typeVariable);
        }
        this.black = new TreeSet<TypeVariable>();
        for (TypeVariable typeVariable : this.finished) {
            if (this.black.contains(typeVariable)) continue;
            this.current_tree = new LinkedList();
            this.forest.add(this.current_tree);
            this.black.add(typeVariable);
            this.dfsgt_visit(typeVariable);
        }
        for (LinkedList linkedList : this.forest) {
            TypeVariable previous = null;
            Object s = null;
            for (TypeVariable current : linkedList) {
                if (previous == null) {
                    previous = current;
                    continue;
                }
                previous = previous.union(current);
            }
        }
    }

    private void dfsg_visit(TypeVariable var) {
        List<TypeVariable> parents = var.parents();
        for (TypeVariable parent : parents) {
            if (this.black.contains(parent)) continue;
            this.black.add(parent);
            this.dfsg_visit(parent);
        }
        this.finished.add(0, var);
    }

    private void dfsgt_visit(TypeVariable var) {
        this.current_tree.add(var);
        List<TypeVariable> children = var.children();
        for (TypeVariable child : children) {
            if (this.black.contains(child)) continue;
            this.black.add(child);
            this.dfsgt_visit(child);
        }
    }
}

