/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.exceptions;

import java.util.Collection;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.PatchingChain;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.util.Chain;

public final class TrapTightener
extends BodyTransformer {
    public TrapTightener(Singletons.Global g) {
    }

    public static TrapTightener v() {
        return G.v().soot_toolkits_exceptions_TrapTightener();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map options) {
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Tightening trap boundaries...");
        }
        Chain<Trap> trapChain = body.getTraps();
        PatchingChain<Unit> unitChain = body.getUnits();
        if (trapChain.size() > 0) {
            ExceptionalUnitGraph graph = new ExceptionalUnitGraph(body);
            for (Trap trap : trapChain) {
                Unit firstTrappedUnit = trap.getBeginUnit();
                Unit firstTrappedThrower = null;
                Unit firstUntrappedUnit = trap.getEndUnit();
                Unit lastTrappedUnit = unitChain.getPredOf(firstUntrappedUnit);
                Unit lastTrappedThrower = null;
                Unit u = firstTrappedUnit;
                while (u != null && u != firstUntrappedUnit) {
                    if (this.mightThrowTo(graph, u, trap)) {
                        firstTrappedThrower = u;
                        break;
                    }
                    u = unitChain.getSuccOf(u);
                }
                if (firstTrappedThrower != null) {
                    u = lastTrappedUnit;
                    while (u != null) {
                        if (this.mightThrowTo(graph, u, trap)) {
                            lastTrappedThrower = u;
                            break;
                        }
                        u = unitChain.getPredOf(u);
                    }
                }
                if (firstTrappedThrower != null && firstTrappedUnit != firstTrappedThrower) {
                    trap.setBeginUnit(firstTrappedThrower);
                }
                if (lastTrappedThrower == null) {
                    lastTrappedThrower = firstTrappedUnit;
                }
                if (lastTrappedUnit == lastTrappedThrower) continue;
                trap.setEndUnit(unitChain.getSuccOf(lastTrappedThrower));
            }
        }
    }

    protected boolean mightThrowTo(ExceptionalUnitGraph g, Unit u, Trap t) {
        Collection<ExceptionalUnitGraph.ExceptionDest> dests = g.getExceptionDests(u);
        for (ExceptionalUnitGraph.ExceptionDest dest : dests) {
            if (dest.getTrap() != t) continue;
            return true;
        }
        return false;
    }
}

