/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.Arrays;
import java.util.List;
import soot.toolkits.scalar.AbstractFlowSet;
import soot.toolkits.scalar.FlowSet;

public class ArraySparseSet
extends AbstractFlowSet {
    protected static final int DEFAULT_SIZE = 8;
    protected int numElements;
    protected int maxElements;
    protected Object[] elements;

    public ArraySparseSet() {
        this.maxElements = 8;
        this.elements = new Object[8];
        this.numElements = 0;
    }

    private ArraySparseSet(ArraySparseSet other) {
        this.numElements = other.numElements;
        this.maxElements = other.maxElements;
        this.elements = (Object[])other.elements.clone();
    }

    private boolean sameType(Object flowSet) {
        return flowSet instanceof ArraySparseSet;
    }

    @Override
    public ArraySparseSet clone() {
        return new ArraySparseSet(this);
    }

    @Override
    public Object emptySet() {
        return new ArraySparseSet();
    }

    @Override
    public void clear() {
        this.numElements = 0;
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public boolean isEmpty() {
        return this.numElements == 0;
    }

    @Override
    public List toList() {
        Object[] copiedElements = new Object[this.numElements];
        System.arraycopy(this.elements, 0, copiedElements, 0, this.numElements);
        return Arrays.asList(copiedElements);
    }

    @Override
    public void add(Object e) {
        if (!this.contains(e)) {
            if (this.numElements == this.maxElements) {
                this.doubleCapacity();
            }
            this.elements[this.numElements++] = e;
        }
    }

    private void doubleCapacity() {
        int newSize = this.maxElements * 2;
        Object[] newElements = new Object[newSize];
        System.arraycopy(this.elements, 0, newElements, 0, this.numElements);
        this.elements = newElements;
        this.maxElements = newSize;
    }

    @Override
    public void remove(Object obj) {
        for (int i = 0; i < this.numElements; ++i) {
            if (!this.elements[i].equals(obj)) continue;
            --this.numElements;
            this.elements[i] = this.elements[this.numElements];
            this.elements[this.numElements] = null;
            return;
        }
    }

    @Override
    public void union(FlowSet otherFlow, FlowSet destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArraySparseSet dest = (ArraySparseSet)destFlow;
            ArraySparseSet other = (ArraySparseSet)otherFlow;
            if (dest == other) {
                for (int i = 0; i < this.numElements; ++i) {
                    dest.add(this.elements[i]);
                }
            } else {
                if (this != dest) {
                    this.copy(dest);
                }
                for (int i = 0; i < other.numElements; ++i) {
                    dest.add(other.elements[i]);
                }
            }
        } else {
            super.union(otherFlow, destFlow);
        }
    }

    @Override
    public void intersection(FlowSet otherFlow, FlowSet destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArraySparseSet workingSet;
            ArraySparseSet dest = (ArraySparseSet)destFlow;
            ArraySparseSet other = (ArraySparseSet)otherFlow;
            if (dest == other || dest == this) {
                workingSet = new ArraySparseSet();
            } else {
                workingSet = dest;
                workingSet.clear();
            }
            for (int i = 0; i < this.numElements; ++i) {
                if (!other.contains(this.elements[i])) continue;
                workingSet.add(this.elements[i]);
            }
            if (workingSet != dest) {
                workingSet.copy(dest);
            }
        } else {
            super.intersection(otherFlow, destFlow);
        }
    }

    @Override
    public void difference(FlowSet otherFlow, FlowSet destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArraySparseSet workingSet;
            ArraySparseSet dest = (ArraySparseSet)destFlow;
            ArraySparseSet other = (ArraySparseSet)otherFlow;
            if (dest == other || dest == this) {
                workingSet = new ArraySparseSet();
            } else {
                workingSet = dest;
                workingSet.clear();
            }
            for (int i = 0; i < this.numElements; ++i) {
                if (other.contains(this.elements[i])) continue;
                workingSet.add(this.elements[i]);
            }
            if (workingSet != dest) {
                workingSet.copy(dest);
            }
        } else {
            super.difference(otherFlow, destFlow);
        }
    }

    @Override
    public boolean contains(Object obj) {
        for (int i = 0; i < this.numElements; ++i) {
            if (!this.elements[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object otherFlow) {
        if (this.sameType(otherFlow)) {
            ArraySparseSet other = (ArraySparseSet)otherFlow;
            if (other.numElements != this.numElements) {
                return false;
            }
            int size = this.numElements;
            for (int i = 0; i < size; ++i) {
                if (other.contains(this.elements[i])) continue;
                return false;
            }
            return true;
        }
        return super.equals(otherFlow);
    }

    @Override
    public void copy(FlowSet destFlow) {
        if (this.sameType(destFlow)) {
            ArraySparseSet dest = (ArraySparseSet)destFlow;
            while (dest.maxElements < this.maxElements) {
                dest.doubleCapacity();
            }
            dest.numElements = this.numElements;
            System.arraycopy(this.elements, 0, dest.elements, 0, this.numElements);
        } else {
            super.copy(destFlow);
        }
    }
}

