/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import soot.util.Chain;

public class HashChain<E>
extends AbstractCollection<E>
implements Chain<E> {
    private final HashMap<E, Link> map = new HashMap();
    private E firstItem = null;
    private E lastItem = null;
    private long stateCount = 0L;
    private HashMap<E, Integer> objectIndexes = null;

    private HashMap<E, Integer> getObjectIndexes() {
        if (this.objectIndexes == null) {
            Object[] array = this.toArray();
            this.objectIndexes = new HashMap(array.length);
            for (int i = 0; i < array.length; ++i) {
                this.objectIndexes.put(array[i], i);
            }
        }
        return this.objectIndexes;
    }

    @Override
    public void clear() {
        ++this.stateCount;
        this.lastItem = null;
        this.firstItem = null;
        this.map.clear();
        this.objectIndexes = null;
    }

    @Override
    public void swapWith(E out, E in) {
        this.insertBefore(in, out);
        this.remove(out);
        this.objectIndexes = null;
    }

    @Override
    public boolean add(E item) {
        this.addLast(item);
        return true;
    }

    public static List toList(Chain c) {
        Iterator it = c.iterator();
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public HashChain() {
    }

    public HashChain(Chain<E> src) {
        this();
        for (E e : src) {
            this.add(e);
        }
    }

    @Override
    public boolean follows(E someObject, E someReferenceObject) {
        if (someObject == null) {
            return true;
        }
        Integer idx1 = this.getObjectIndexes().get(someObject);
        if (idx1 == null) {
            throw new NoSuchElementException("HashChain.follows(...) with object that is not in the chain: " + someObject.toString());
        }
        Integer idx2 = this.getObjectIndexes().get(someReferenceObject);
        if (idx2 == null) {
            return true;
        }
        return idx1 > idx2;
    }

    public boolean followsOld(E someObject, E someReferenceObject) {
        Iterator<E> it = this.iterator(someObject);
        while (it.hasNext()) {
            if (it.next() != someReferenceObject) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (this.map.containsKey(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void insertAfter(E toInsert, E point) {
        if (toInsert == null) {
            throw new RuntimeException("Bad idea! You tried to insert  a null object into a Chain!");
        }
        if (this.map.containsKey(toInsert)) {
            throw new RuntimeException("Chain already contains object.");
        }
        ++this.stateCount;
        Link temp = this.map.get(point);
        Link<E> newLink = temp.insertAfter(toInsert);
        this.map.put(toInsert, newLink);
        this.objectIndexes = null;
    }

    @Override
    public void insertAfter(List<E> toInsert, E point) {
        if (toInsert == null) {
            throw new RuntimeException("Warning! You tried to insert a null list into a Chain!");
        }
        E previousPoint = point;
        for (E o : toInsert) {
            this.insertAfter(o, previousPoint);
            previousPoint = o;
        }
        this.objectIndexes = null;
    }

    @Override
    public void insertAfter(Chain<E> toInsert, E point) {
        if (toInsert == null) {
            throw new RuntimeException("Warning! You tried to insert a null list into a Chain!");
        }
        E previousPoint = point;
        for (E o : toInsert) {
            this.insertAfter(o, previousPoint);
            previousPoint = o;
        }
        this.objectIndexes = null;
    }

    @Override
    public void insertBefore(E toInsert, E point) {
        if (toInsert == null) {
            throw new RuntimeException("Bad idea! You tried to insert a null object into a Chain!");
        }
        if (this.map.containsKey(toInsert)) {
            throw new RuntimeException("Chain already contains object.");
        }
        Link temp = this.map.get(point);
        if (temp == null) {
            throw new RuntimeException("Insertion point not found in chain!");
        }
        ++this.stateCount;
        Link<E> newLink = temp.insertBefore(toInsert);
        this.map.put(toInsert, newLink);
        this.objectIndexes = null;
    }

    @Override
    public void insertBefore(List<E> toInsert, E point) {
        if (toInsert == null) {
            throw new RuntimeException("Warning! You tried to insert a null list into a Chain!");
        }
        for (E o : toInsert) {
            this.insertBefore(o, point);
        }
        this.objectIndexes = null;
    }

    @Override
    public void insertBefore(Chain<E> toInsert, E point) {
        if (toInsert == null) {
            throw new RuntimeException("Warning! You tried to insert a null list into a Chain!");
        }
        for (E o : toInsert) {
            this.insertBefore(o, point);
        }
        this.objectIndexes = null;
    }

    public static HashChain listToHashChain(List list) {
        HashChain c = new HashChain();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            c.addLast(it.next());
        }
        return c;
    }

    @Override
    public boolean remove(Object item) {
        if (item == null) {
            throw new RuntimeException("Bad idea! You tried to remove  a null object from a Chain!");
        }
        ++this.stateCount;
        if (this.map.get(item) != null) {
            Link link = this.map.get(item);
            link.unlinkSelf();
            this.map.remove(item);
            this.objectIndexes = null;
            return true;
        }
        return false;
    }

    @Override
    public void addFirst(E item) {
        Link<E> newLink;
        if (item == null) {
            throw new RuntimeException("Bad idea!  You tried to insert a null object into a Chain!");
        }
        ++this.stateCount;
        if (this.map.containsKey(item)) {
            throw new RuntimeException("Chain already contains object.");
        }
        if (this.firstItem != null) {
            Link temp = this.map.get(this.firstItem);
            newLink = temp.insertBefore(item);
        } else {
            newLink = new Link<E>(item);
            this.lastItem = item;
            this.firstItem = this.lastItem;
        }
        this.map.put(item, newLink);
        this.objectIndexes = null;
    }

    @Override
    public void addLast(E item) {
        Link<E> newLink;
        if (item == null) {
            throw new RuntimeException("Bad idea! You tried to insert  a null object into a Chain!");
        }
        ++this.stateCount;
        if (this.map.containsKey(item)) {
            throw new RuntimeException("Chain already contains object: " + item);
        }
        if (this.lastItem != null) {
            Link temp = this.map.get(this.lastItem);
            newLink = temp.insertAfter(item);
        } else {
            newLink = new Link<E>(item);
            this.lastItem = item;
            this.firstItem = this.lastItem;
        }
        this.map.put(item, newLink);
        this.objectIndexes = null;
    }

    @Override
    public void removeFirst() {
        ++this.stateCount;
        E item = this.firstItem;
        this.map.get(this.firstItem).unlinkSelf();
        this.map.remove(item);
        this.objectIndexes = null;
    }

    @Override
    public void removeLast() {
        ++this.stateCount;
        E item = this.lastItem;
        this.map.get(this.lastItem).unlinkSelf();
        this.map.remove(item);
        this.objectIndexes = null;
    }

    @Override
    public E getFirst() {
        if (this.firstItem == null) {
            throw new NoSuchElementException();
        }
        return this.firstItem;
    }

    @Override
    public E getLast() {
        if (this.lastItem == null) {
            throw new NoSuchElementException();
        }
        return this.lastItem;
    }

    @Override
    public E getSuccOf(E point) throws NoSuchElementException {
        Link link = this.map.get(point);
        try {
            link = link.getNext();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException();
        }
        if (link == null) {
            return null;
        }
        return (E)link.getItem();
    }

    @Override
    public E getPredOf(E point) throws NoSuchElementException {
        Link link = this.map.get(point);
        if (point == null) {
            throw new RuntimeException("trying to hash null value.");
        }
        try {
            link = link.getPrevious();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException();
        }
        if (link == null) {
            return null;
        }
        return (E)link.getItem();
    }

    @Override
    public Iterator<E> snapshotIterator() {
        ArrayList l = new ArrayList(this.map.size());
        l.addAll(this);
        return l.iterator();
    }

    public Iterator<E> snapshotIterator(Object item) {
        ArrayList l = new ArrayList(this.map.size());
        LinkIterator<Object> it = new LinkIterator<Object>(item);
        while (it.hasNext()) {
            l.add(it.next());
        }
        return l.iterator();
    }

    @Override
    public Iterator<E> iterator() {
        return new LinkIterator<E>(this.firstItem);
    }

    @Override
    public Iterator<E> iterator(E item) {
        return new LinkIterator<E>(item);
    }

    @Override
    public Iterator<E> iterator(E head, E tail) {
        if (head != null && this.getPredOf(head) == tail) {
            return new LinkIterator<Object>(null, null);
        }
        return new LinkIterator<E>(head, tail);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        Iterator<E> it = this.iterator();
        boolean b = false;
        strBuf.append("[");
        while (it.hasNext()) {
            if (!b) {
                b = true;
            } else {
                strBuf.append(", ");
            }
            strBuf.append(it.next().toString());
        }
        strBuf.append("]");
        return strBuf.toString();
    }

    class LinkIterator<X extends E>
    implements Iterator {
        private Link<X> currentLink;
        boolean state;
        private X destination;
        private long iteratorStateCount;

        public LinkIterator(X item) {
            Link nextLink = (Link)HashChain.this.map.get(item);
            if (nextLink == null && item != null) {
                throw new NoSuchElementException("HashChain.LinkIterator(obj) with obj that is not in the chain: " + item.toString());
            }
            this.currentLink = new Link<Object>(null);
            this.currentLink.setNext(nextLink);
            this.state = false;
            this.destination = null;
            this.iteratorStateCount = HashChain.this.stateCount;
        }

        public LinkIterator(X from, X to) {
            this(from);
            this.destination = to;
        }

        @Override
        public boolean hasNext() {
            if (HashChain.this.stateCount != this.iteratorStateCount) {
                throw new ConcurrentModificationException();
            }
            if (this.destination == null) {
                return this.currentLink.getNext() != null;
            }
            return this.destination != this.currentLink.getItem();
        }

        public X next() throws NoSuchElementException {
            if (HashChain.this.stateCount != this.iteratorStateCount) {
                throw new ConcurrentModificationException();
            }
            Link<X> temp = this.currentLink.getNext();
            if (temp == null) {
                String exceptionMsg = this.destination != null && this.destination != this.currentLink.getItem() ? "HashChain.LinkIterator.next() reached end of chain without reaching specified tail unit" : "HashChain.LinkIterator.next() called past the end of the Chain";
                throw new NoSuchElementException(exceptionMsg);
            }
            this.currentLink = temp;
            this.state = true;
            return this.currentLink.getItem();
        }

        @Override
        public void remove() throws IllegalStateException {
            if (HashChain.this.stateCount != this.iteratorStateCount) {
                throw new ConcurrentModificationException();
            }
            HashChain.this.stateCount++;
            ++this.iteratorStateCount;
            if (!this.state) {
                throw new IllegalStateException();
            }
            this.currentLink.unlinkSelf();
            HashChain.this.map.remove(this.currentLink.getItem());
            this.state = false;
            HashChain.this.objectIndexes = null;
        }

        public String toString() {
            if (this.currentLink == null) {
                return "Current object under iterator is null" + super.toString();
            }
            return this.currentLink.toString();
        }
    }

    class Link<X extends E>
    implements Serializable {
        private Link<X> nextLink;
        private Link<X> previousLink;
        private X item;

        public Link(X item) {
            this.item = item;
            this.previousLink = null;
            this.nextLink = null;
        }

        public Link<X> getNext() {
            return this.nextLink;
        }

        public Link<X> getPrevious() {
            return this.previousLink;
        }

        public void setNext(Link<X> link) {
            this.nextLink = link;
        }

        public void setPrevious(Link<X> link) {
            this.previousLink = link;
        }

        public void unlinkSelf() {
            this.bind(this.previousLink, this.nextLink);
        }

        public Link<X> insertAfter(X item) {
            Link<X> newLink = new Link<X>(item);
            this.bind(newLink, this.nextLink);
            this.bind(this, newLink);
            return newLink;
        }

        public Link<X> insertBefore(X item) {
            Link<X> newLink = new Link<X>(item);
            this.bind(this.previousLink, newLink);
            this.bind(newLink, this);
            return newLink;
        }

        private void bind(Link<X> a, Link<X> b) {
            if (a == null) {
                if (b != null) {
                    HashChain.this.firstItem = b.getItem();
                } else {
                    HashChain.this.firstItem = null;
                }
            } else {
                a.setNext(b);
            }
            if (b == null) {
                if (a != null) {
                    HashChain.this.lastItem = a.getItem();
                } else {
                    HashChain.this.lastItem = null;
                }
            } else {
                b.setPrevious(a);
            }
        }

        public X getItem() {
            return this.item;
        }

        public String toString() {
            if (this.item != null) {
                return this.item.toString();
            }
            return "Link item is null" + super.toString();
        }
    }
}

