/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.util.MultiMap;

public class HashMultiMap
implements MultiMap {
    Map<Object, Set> m = new HashMap<Object, Set>(0);

    public HashMultiMap() {
    }

    public HashMultiMap(MultiMap m) {
        this.putAll(m);
    }

    @Override
    public void putAll(MultiMap m) {
        for (Object o : m.keySet()) {
            this.putAll(o, m.get(o));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.numKeys() == 0;
    }

    @Override
    public int numKeys() {
        return this.m.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Set s : this.m.values()) {
            if (!s.contains(value)) continue;
            return true;
        }
        return false;
    }

    protected Set newSet() {
        return new HashSet(4);
    }

    private Set findSet(Object key) {
        Set s = this.m.get(key);
        if (s == null) {
            s = this.newSet();
            this.m.put(key, s);
        }
        return s;
    }

    @Override
    public boolean put(Object key, Object value) {
        return this.findSet(key).add(value);
    }

    @Override
    public boolean putAll(Object key, Set values) {
        if (values.isEmpty()) {
            return false;
        }
        return this.findSet(key).addAll(values);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Set s = this.m.get(key);
        if (s == null) {
            return false;
        }
        boolean ret = s.remove(value);
        if (s.isEmpty()) {
            this.m.remove(key);
        }
        return ret;
    }

    @Override
    public boolean remove(Object key) {
        return null != this.m.remove(key);
    }

    @Override
    public boolean removeAll(Object key, Set values) {
        Set s = this.m.get(key);
        if (s == null) {
            return false;
        }
        boolean ret = s.removeAll(values);
        if (s.isEmpty()) {
            this.m.remove(key);
        }
        return ret;
    }

    @Override
    public Set get(Object o) {
        Set ret = this.m.get(o);
        if (ret == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set keySet() {
        return this.m.keySet();
    }

    @Override
    public Set values() {
        HashSet ret = new HashSet(0);
        for (Set s : this.m.values()) {
            ret.addAll(s);
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof MultiMap)) {
            return false;
        }
        MultiMap mm = (MultiMap)o;
        if (!this.keySet().equals(mm.keySet())) {
            return false;
        }
        for (Map.Entry<Object, Set> e : this.m.entrySet()) {
            Set s = e.getValue();
            if (s.equals(mm.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.m.hashCode();
    }
}

