/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.dom4j.Document;
import org.rundeck.api.generator.XmlDocumentGenerator;
import org.rundeck.api.util.ParametersUtil;

class ApiPathBuilder {
    private final StringBuilder apiPath;
    private String accept = "text/xml";
    private final Map<String, InputStream> attachments;
    private final Map<String, File> fileAttachments;
    private final List<NameValuePair> form = new ArrayList<NameValuePair>();
    private Document xmlDocument;
    private InputStream contentStream;
    private byte[] contents;
    private File contentFile;
    private String contentType;
    private String requiredContentType;
    private boolean emptyContent = false;
    private boolean firstParamDone = false;

    public ApiPathBuilder(String ... paths) {
        this.apiPath = new StringBuilder();
        this.attachments = new HashMap<String, InputStream>();
        this.fileAttachments = new HashMap<String, File>();
        this.paths(paths);
    }

    public ApiPathBuilder paths(String ... paths) {
        if (paths != null) {
            for (String path : paths) {
                if (!StringUtils.isNotBlank((String)path)) continue;
                this.append(path);
            }
        }
        return this;
    }

    public ApiPathBuilder accept(String mimeTypes) {
        this.accept = mimeTypes;
        return this;
    }

    public ApiPathBuilder param(BuildsParameters params) {
        params.buildParameters(this, false);
        return this;
    }

    public ApiPathBuilder field(BuildsParameters params) {
        params.buildParameters(this, true);
        return this;
    }

    public ApiPathBuilder param(String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.appendSeparator();
            this.append(key);
            this.append("=");
            this.append(ParametersUtil.urlEncode(value));
        }
        return this;
    }

    public ApiPathBuilder param(String key, Collection<String> values) {
        for (String value : values) {
            if (!StringUtils.isNotBlank((String)value)) continue;
            this.appendSeparator();
            this.append(key);
            this.append("=");
            this.append(ParametersUtil.urlEncode(value));
        }
        return this;
    }

    public ApiPathBuilder field(String key, Collection<String> values) {
        if (null != values) {
            for (String value : values) {
                if (!StringUtils.isNotBlank((String)value)) continue;
                this.form.add((NameValuePair)new BasicNameValuePair(key, value));
            }
        }
        return this;
    }

    public ApiPathBuilder field(String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.form.add((NameValuePair)new BasicNameValuePair(key, value));
        }
        return this;
    }

    public ApiPathBuilder param(String key, Enum<?> value) {
        if (value != null) {
            this.param(key, StringUtils.lowerCase((String)value.toString()));
        }
        return this;
    }

    public ApiPathBuilder param(String key, Date value) {
        if (value != null) {
            this.param(key, value.getTime());
        }
        return this;
    }

    public ApiPathBuilder param(String key, Long value) {
        if (value != null) {
            this.param(key, value.toString());
        }
        return this;
    }

    public ApiPathBuilder param(String key, Integer value) {
        if (value != null) {
            this.param(key, value.toString());
        }
        return this;
    }

    public ApiPathBuilder param(String key, Boolean value) {
        if (value != null) {
            this.param(key, value.toString());
        }
        return this;
    }

    public ApiPathBuilder nodeFilters(Properties nodeFilters) {
        String filters = ParametersUtil.generateNodeFiltersString(nodeFilters);
        if (StringUtils.isNotBlank((String)filters)) {
            this.appendSeparator();
            this.append(filters);
        }
        return this;
    }

    public ApiPathBuilder attach(String name, InputStream stream) {
        if (stream != null) {
            this.attachments.put(name, stream);
        }
        return this;
    }

    public ApiPathBuilder attach(String name, File file) {
        if (file != null) {
            this.fileAttachments.put(name, file);
        }
        return this;
    }

    public ApiPathBuilder content(String contentType, InputStream stream) {
        if (stream != null && contentType != null) {
            this.contentStream = stream;
            this.contentType = contentType;
        }
        return this;
    }

    public ApiPathBuilder content(String contentType, File file) {
        if (file != null && contentType != null) {
            this.contentFile = file;
            this.contentType = contentType;
        }
        return this;
    }

    public ApiPathBuilder content(String contentType, byte[] contents) {
        if (contents != null && contentType != null) {
            this.contents = contents;
            this.contentType = contentType;
        }
        return this;
    }

    public ApiPathBuilder content(String contentType, String contents) {
        return this.content(contentType, contents.getBytes(Charset.forName("UTF-8")));
    }

    public ApiPathBuilder emptyContent() {
        this.emptyContent = true;
        return this;
    }

    public ApiPathBuilder xml(Document document) {
        if (document != null) {
            this.xmlDocument = document;
        }
        return this;
    }

    public ApiPathBuilder xml(XmlDocumentGenerator document) {
        if (document != null) {
            this.xmlDocument = document.generateXmlDocument();
        }
        return this;
    }

    public Map<String, InputStream> getAttachments() {
        return this.attachments;
    }

    public String toString() {
        return this.apiPath.toString();
    }

    private void append(String str) {
        this.apiPath.append(str);
    }

    private void appendSeparator() {
        if (this.firstParamDone) {
            this.append("&");
        } else {
            this.append("?");
            this.firstParamDone = true;
        }
    }

    public List<NameValuePair> getForm() {
        return this.form;
    }

    public boolean hasPostContent() {
        return this.getAttachments().size() > 0 || this.getForm().size() > 0 || null != this.xmlDocument;
    }

    public String getAccept() {
        return this.accept;
    }

    public Document getXmlDocument() {
        return this.xmlDocument;
    }

    public InputStream getContentStream() {
        return this.contentStream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public File getContentFile() {
        return this.contentFile;
    }

    public boolean isEmptyContent() {
        return this.emptyContent;
    }

    public ApiPathBuilder requireContentType(String contentType) {
        this.requiredContentType = contentType;
        return this;
    }

    public String getRequiredContentType() {
        return this.requiredContentType;
    }

    public byte[] getContents() {
        return this.contents;
    }

    public Map<String, File> getFileAttachments() {
        return this.fileAttachments;
    }

    public static interface BuildsParameters {
        public boolean buildParameters(ApiPathBuilder var1, boolean var2);
    }
}

