/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api;

public class RundeckApiException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public RundeckApiException(String message) {
        super(message);
    }

    public RundeckApiException(String message, Throwable cause) {
        super(message, cause);
    }

    public static class RundeckApiHttpContentTypeException
    extends RundeckApiAuthException {
        private static final long serialVersionUID = 1L;
        private String contentType;
        private String requiredContentType;

        public RundeckApiHttpContentTypeException(String contentType, String requiredContentType) {
            super("Unexpected content-type: '" + contentType + "', expected: '" + requiredContentType + "'");
            this.contentType = contentType;
            this.requiredContentType = requiredContentType;
        }

        public RundeckApiHttpContentTypeException(String message, String contentType, String requiredContentType) {
            super(message);
            this.contentType = contentType;
            this.requiredContentType = requiredContentType;
        }

        public RundeckApiHttpContentTypeException(String message, Throwable cause, String contentType, String requiredContentType) {
            super(message, cause);
            this.contentType = contentType;
            this.requiredContentType = requiredContentType;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getRequiredContentType() {
            return this.requiredContentType;
        }
    }

    public static class RundeckApiHttpStatusException
    extends RundeckApiAuthException {
        private static final long serialVersionUID = 1L;
        private int statusCode;

        public RundeckApiHttpStatusException(String message, int statusCode) {
            super(message);
            this.statusCode = statusCode;
        }

        public RundeckApiHttpStatusException(String message, Throwable cause, int statusCode) {
            super(message, cause);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }

    public static class RundeckApiTokenException
    extends RundeckApiAuthException {
        private static final long serialVersionUID = 1L;

        public RundeckApiTokenException(String message) {
            super(message);
        }

        public RundeckApiTokenException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class RundeckApiLoginException
    extends RundeckApiAuthException {
        private static final long serialVersionUID = 1L;

        public RundeckApiLoginException(String message) {
            super(message);
        }

        public RundeckApiLoginException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class RundeckApiAuthException
    extends RundeckApiException {
        private static final long serialVersionUID = 1L;

        public RundeckApiAuthException(String message) {
            super(message);
        }

        public RundeckApiAuthException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

