/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.domain;

import java.util.ArrayList;
import java.util.List;
import org.rundeck.api.domain.BaseStorageResource;
import org.rundeck.api.domain.KeyResource;
import org.rundeck.api.domain.StorageResource;

public class BaseKeyResource
extends BaseStorageResource
implements KeyResource {
    private boolean privateKey;
    ArrayList<KeyResource> keyResources = new ArrayList();

    @Override
    public boolean isPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(boolean privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public void setDirectoryContents(List<? extends StorageResource> directoryContents) {
        for (StorageResource storageResource : directoryContents) {
            this.keyResources.add(BaseKeyResource.from(storageResource));
        }
    }

    @Override
    public List<KeyResource> getDirectoryContents() {
        return this.keyResources;
    }

    public static BaseKeyResource from(StorageResource source) {
        BaseKeyResource baseSshKeyResource = new BaseKeyResource();
        baseSshKeyResource.setDirectory(source.isDirectory());
        baseSshKeyResource.setPath(source.getPath());
        baseSshKeyResource.setName(source.getName());
        baseSshKeyResource.setMetadata(source.getMetadata());
        baseSshKeyResource.setUrl(source.getUrl());
        if (!baseSshKeyResource.isDirectory()) {
            baseSshKeyResource.setPrivateKey(null != baseSshKeyResource.getMetadata() && "private".equals(baseSshKeyResource.getMetadata().get("Rundeck-key-type")));
        } else if (null != source.getDirectoryContents()) {
            baseSshKeyResource.setDirectoryContents(source.getDirectoryContents());
        }
        return baseSshKeyResource;
    }
}

