/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;
import org.rundeck.api.domain.RundeckExecution;
import org.rundeck.api.domain.RundeckJob;
import org.rundeck.api.domain.RundeckNode;
import org.rundeck.api.domain.RundeckNodeIdentity;
import org.rundeck.api.parser.BaseXpathParser;
import org.rundeck.api.parser.JobParser;
import org.rundeck.api.parser.ListParser;
import org.rundeck.api.parser.NodeParser;

public class ExecutionParser
extends BaseXpathParser<RundeckExecution> {
    public ExecutionParser(String xpath) {
        super(xpath);
    }

    public ExecutionParser() {
    }

    @Override
    public RundeckExecution parse(Node execNode) {
        Node successfulNodes;
        Node jobNode;
        String endedAt;
        RundeckExecution execution = new RundeckExecution();
        execution.setId(Long.valueOf(execNode.valueOf("@id")));
        execution.setUrl(StringUtils.trimToNull((String)execNode.valueOf("@href")));
        try {
            execution.setStatus(RundeckExecution.ExecutionStatus.valueOf(StringUtils.replace((String)StringUtils.upperCase((String)execNode.valueOf("@status")), (String)"-", (String)"_")));
        }
        catch (IllegalArgumentException e) {
            execution.setStatus(null);
        }
        execution.setDescription(StringUtils.trimToNull((String)execNode.valueOf("description")));
        execution.setArgstring(StringUtils.trimToNull((String)execNode.valueOf("argstring")));
        execution.setStartedBy(StringUtils.trimToNull((String)execNode.valueOf("user")));
        execution.setAbortedBy(StringUtils.trimToNull((String)execNode.valueOf("abortedby")));
        execution.setProject(StringUtils.trimToNull((String)execNode.valueOf("@project")));
        String startedAt = StringUtils.trimToNull((String)execNode.valueOf("date-started/@unixtime"));
        if (startedAt != null) {
            execution.setStartedAt(new Date(Long.valueOf(startedAt)));
        }
        if ((endedAt = StringUtils.trimToNull((String)execNode.valueOf("date-ended/@unixtime"))) != null) {
            execution.setEndedAt(new Date(Long.valueOf(endedAt)));
        }
        if ((jobNode = execNode.selectSingleNode("job")) != null) {
            RundeckJob job = (RundeckJob)new JobParser().parseXmlNode(jobNode);
            execution.setJob(job);
        }
        if ((successfulNodes = execNode.selectSingleNode("successfulNodes")) != null) {
            Object rundeckNodes = new ListParser<RundeckNode>(new NodeParser(), "successfulNodes/node").parseXmlNode(execNode);
            execution.setSuccessfulNodes(new HashSet<RundeckNodeIdentity>((Collection<RundeckNodeIdentity>)rundeckNodes));
        } else {
            execution.setSuccessfulNodes(Collections.emptySet());
        }
        Node failedNodes = execNode.selectSingleNode("failedNodes");
        if (failedNodes != null) {
            Object rundeckNodes = new ListParser<RundeckNode>(new NodeParser(), "failedNodes/node").parseXmlNode(execNode);
            execution.setFailedNodes(new HashSet<RundeckNodeIdentity>((Collection<RundeckNodeIdentity>)rundeckNodes));
        } else {
            execution.setFailedNodes(Collections.emptySet());
        }
        return execution;
    }
}

